/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.utils;

import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.utils.CollectionUtil;
import com.lframework.starter.web.bo.BasePrintDataBo;
import com.lframework.starter.web.dto.BaseDto;
import com.lframework.starter.web.utils.JsonUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintUtil {
    private static final Logger log = LoggerFactory.getLogger(PrintUtil.class);

    private static Template getTemplate(String templateName) {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setClassForTemplateLoading(PrintUtil.class, "/");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            return cfg.getTemplate(templateName);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException(e.getMessage());
        }
    }

    public static <T extends BasePrintDataBo<? extends BaseDto>> String generate(String templateName, T data) {
        Template template = PrintUtil.getTemplate(templateName);
        Map root = data == null ? CollectionUtil.emptyMap() : JsonUtil.convert(data, Map.class);
        StringWriter stringWriter = new StringWriter();
        BufferedWriter writer = new BufferedWriter(stringWriter);
        try {
            template.process((Object)root, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            log.error(e.getMessage(), e);
            throw new DefaultSysException(e.getMessage());
        }
        return stringWriter.toString();
    }
}

