/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.utils;

import com.lframework.starter.common.utils.ArrayUtil;
import com.lframework.starter.common.utils.CollectionUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtil {
    private static final Logger log = LoggerFactory.getLogger(RequestUtil.class);

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        return request;
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
        return response;
    }

    public static Map<String, String> getHeaders() {
        HttpServletRequest request = RequestUtil.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        if (CollectionUtil.isEmpty((Enumeration)headerNames)) {
            return CollectionUtil.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, request.getHeader(headerName));
        }
        return headers;
    }

    public static Map<String, Object> getParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        HashMap<String, Object> parameters = new HashMap<String, Object>(parameterMap.size());
        parameterMap.entrySet().stream().forEach(entry -> {
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtil.isEmpty((Object[])values)) {
                parameters.put((String)entry.getKey(), values[0]);
            }
        });
        return parameters;
    }

    public static byte[] getRequestBody(HttpServletRequest request) {
        int len = request.getContentLength();
        ServletInputStream is = null;
        try {
            is = request.getInputStream();
            byte[] buffer = new byte[len];
            is.read(buffer, 0, len);
            return buffer;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] getRequestBody() {
        HttpServletRequest request = RequestUtil.getRequest();
        return RequestUtil.getRequestBody(request);
    }

    public static String getRequestBodyStr(HttpServletRequest request) {
        byte[] bytes = RequestUtil.getRequestBody(request);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String getRequestBodyStr() {
        byte[] bytes = RequestUtil.getRequestBody();
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static Map<String, Object> getParameters() {
        Map parameterMap = RequestUtil.getRequest().getParameterMap();
        HashMap<String, Object> parameters = new HashMap<String, Object>(parameterMap.size());
        parameterMap.entrySet().stream().forEach(entry -> {
            Object[] values = (String[])entry.getValue();
            if (!ArrayUtil.isEmpty((Object[])values)) {
                parameters.put((String)entry.getKey(), values[0]);
            }
        });
        return parameters;
    }

    public static String getRequestIp() {
        HttpServletRequest request = RequestUtil.getRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) && ip.indexOf(",") != -1) {
            ip = ip.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

