/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.utils;

import com.lframework.starter.common.exceptions.BaseException;
import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.utils.FileUtil;
import com.lframework.starter.web.resp.InvokeResultBuilder;
import com.lframework.starter.web.utils.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtil.class);

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
        return response;
    }

    public static void respFailJson(HttpServletResponse response, BaseException e) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        response.setHeader("Content-Type", "application/json");
        response.setCharacterEncoding("utf-8");
        try {
            response.getWriter().print(JsonUtil.toJsonString(InvokeResultBuilder.fail(e)));
        }
        catch (IOException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new DefaultSysException();
        }
    }

    public static void respSuccessJson(HttpServletResponse response, Object obj) {
        response.setStatus(HttpStatus.OK.value());
        response.setHeader("Content-Type", "application/json");
        response.setCharacterEncoding("utf-8");
        try {
            response.getWriter().print(JsonUtil.toJsonString(InvokeResultBuilder.success(obj)));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException();
        }
    }

    public static void download(File file) {
        ResponseUtil.download(file, file.getName());
    }

    public static void download(File file, String fileName) {
        ResponseUtil.download(file, fileName, "application/octet-stream");
    }

    public static void download(File file, String fileName, String contentType) {
        HttpServletResponse response = ResponseUtil.getResponse();
        response.setContentType(contentType);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setHeader("FileName", fileName);
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            os.write(FileUtil.readBytes((File)file));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException(e.getMessage());
        }
    }
}

