/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.web.utils;

import com.lframework.starter.common.exceptions.impl.DefaultSysException;
import com.lframework.starter.common.utils.Assert;
import com.lframework.starter.common.utils.DateUtil;
import com.lframework.starter.common.utils.FileUtil;
import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.common.utils.ApplicationUtil;
import com.lframework.starter.web.components.upload.UploadHandlerFactory;
import com.lframework.starter.web.components.upload.handler.UploadHandler;
import com.lframework.starter.web.service.SysParameterService;
import com.lframework.starter.web.utils.IdUtil;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class UploadUtil {
    private static final Logger log = LoggerFactory.getLogger(UploadUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String upload(MultipartFile file) {
        Assert.notNull((Object)file);
        SysParameterService sysParameterService = (SysParameterService)ApplicationUtil.getBean(SysParameterService.class);
        String uploadTypeStr = sysParameterService.findByKey("upload.type", "LOCAL");
        UploadHandler uploadHandler = UploadHandlerFactory.getInstance(uploadTypeStr);
        String suffix = FileUtil.getSuffix((String)file.getOriginalFilename());
        String fileName = IdUtil.getUUID();
        String fullFileName = fileName + (StringUtil.isEmpty((CharSequence)suffix) ? "" : "." + suffix);
        try (InputStream is = file.getInputStream();){
            String string = uploadHandler.upload(is, UploadUtil.getDefaultLocations(), fullFileName);
            return string;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new DefaultSysException(e.getMessage());
        }
    }

    private static List<String> getDefaultLocations() {
        LocalDate now = LocalDate.now();
        ArrayList<String> locations = new ArrayList<String>();
        locations.add(DateUtil.formatDate((LocalDate)now, (String)"yyyy"));
        locations.add(DateUtil.formatDate((LocalDate)now, (String)"MM"));
        locations.add(DateUtil.formatDate((LocalDate)now, (String)"dd"));
        return locations;
    }
}

