/*
 * Decompiled with CFR 0.152.
 */
package com.lframework.starter.websocket.handler;

import com.lframework.starter.common.utils.StringUtil;
import com.lframework.starter.web.common.security.AbstractUserDetails;
import com.lframework.starter.web.common.security.SecurityUtil;
import com.lframework.starter.web.common.tenant.TenantContextHolder;
import com.lframework.starter.web.common.utils.ApplicationUtil;
import com.lframework.starter.web.utils.JsonUtil;
import com.lframework.starter.web.utils.TenantUtil;
import com.lframework.starter.websocket.components.WsSessionManager;
import com.lframework.starter.websocket.entity.WsSession;
import com.lframework.starter.websocket.events.UserConnectEvent;
import com.lframework.starter.websocket.events.UserDisConnectEvent;
import com.lframework.starter.websocket.service.WsDataProcessService;
import com.lframework.starter.websocket.vo.WsVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WsHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WsHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        WsSession wsSession = WsSession.get(session);
        AbstractUserDetails currentUser = wsSession.getUser();
        try {
            if (TenantUtil.enableTenant()) {
                TenantContextHolder.setTenantId((Integer)currentUser.getTenantId());
            }
            SecurityUtil.setCurrentUser((AbstractUserDetails)currentUser);
            ApplicationUtil.publishEvent((ApplicationEvent)new UserConnectEvent((Object)this, session.getId(), currentUser));
        }
        finally {
            TenantContextHolder.clearTenantId();
            SecurityUtil.removeCurrentUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        WsSession wsSession = WsSessionManager.getSession(session.getId());
        AbstractUserDetails currentUser = wsSession.getUser();
        try {
            if (TenantUtil.enableTenant()) {
                TenantContextHolder.setTenantId((Integer)currentUser.getTenantId());
            }
            SecurityUtil.setCurrentUser((AbstractUserDetails)currentUser);
            ApplicationUtil.publishEvent((ApplicationEvent)new UserDisConnectEvent((Object)this, session.getId(), currentUser));
        }
        finally {
            TenantContextHolder.clearTenantId();
            SecurityUtil.removeCurrentUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTextMessage(WebSocketSession session, TextMessage message) {
        WsSession wsSession = WsSessionManager.getSession(session.getId());
        AbstractUserDetails currentUser = wsSession.getUser();
        if (currentUser == null) {
            return;
        }
        WsVo vo = this.parseVo((String)message.getPayload());
        if (vo == null) {
            return;
        }
        if (StringUtil.isBlank((CharSequence)vo.getBizType())) {
            return;
        }
        try {
            if (TenantUtil.enableTenant()) {
                TenantContextHolder.setTenantId((Integer)currentUser.getTenantId());
            }
            SecurityUtil.setCurrentUser((AbstractUserDetails)currentUser);
            try {
                WsDataProcessService bean = (WsDataProcessService)ApplicationUtil.getBean((String)(vo.getBizType() + "WsReceiveBean"));
                bean.process(vo);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                TenantContextHolder.clearTenantId();
                SecurityUtil.removeCurrentUser();
                return;
            }
        }
        finally {
            TenantContextHolder.clearTenantId();
            SecurityUtil.removeCurrentUser();
        }
    }

    private WsVo parseVo(String str) {
        if (StringUtil.isBlank((CharSequence)str)) {
            return null;
        }
        return (WsVo)JsonUtil.parseObject((String)str, WsVo.class);
    }
}

