/*
 * Copyright (C) 2016-2020 The lgou2w <lgou2w@hotmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.lgou2w.ldk.bukkit.attribute

/**
 * ## Attributable (可属性能力)
 *
 * * Get the attribute object from the given attribute type.
 * * 从给定的属性类型获取属性对象.
 *
 * @see [Attribute]
 * @see [AttributeType]
 * @author lgou2w
 */
interface Attributable {

  /**
   * * Get the attribute object from the given attribute type.
   * * 从给定的属性类型获取属性对象.
   *
   * @param type Attribute type.
   * @param type 属性类型.
   */
  fun getAttribute(type: AttributeType): Attribute
}
