/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.bukkit.attribute;

import com.lgou2w.ldk.bukkit.attribute.AttributeType;
import com.lgou2w.ldk.bukkit.attribute.Operation;
import com.lgou2w.ldk.bukkit.attribute.Slot;
import com.lgou2w.ldk.bukkit.nbt.NBTFactory;
import com.lgou2w.ldk.bukkit.version.MinecraftBukkitVersion;
import com.lgou2w.ldk.common.CommonKt;
import com.lgou2w.ldk.common.ComparisonChain;
import com.lgou2w.ldk.common.Enums;
import com.lgou2w.ldk.nbt.NBTSavable;
import com.lgou2w.ldk.nbt.NBTTagCompound;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u0086\b\u0018\u0000 12\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u00011B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000H\u0096\u0002J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010$\u001a\u00020\rH\u00c6\u0003J\t\u0010%\u001a\u00020\u000fH\u00c6\u0003JG\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010\u001f\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\u001eH\u00d6\u0001J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0016J\u0014\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020)0/H\u0016J\t\u00100\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Lcom/lgou2w/ldk/bukkit/attribute/AttributeItemModifier;", "Lorg/bukkit/configuration/serialization/ConfigurationSerializable;", "Lcom/lgou2w/ldk/nbt/NBTSavable;", "", "type", "Lcom/lgou2w/ldk/bukkit/attribute/AttributeType;", "name", "", "operation", "Lcom/lgou2w/ldk/bukkit/attribute/Operation;", "slot", "Lcom/lgou2w/ldk/bukkit/attribute/Slot;", "amount", "", "uuid", "Ljava/util/UUID;", "(Lcom/lgou2w/ldk/bukkit/attribute/AttributeType;Ljava/lang/String;Lcom/lgou2w/ldk/bukkit/attribute/Operation;Lcom/lgou2w/ldk/bukkit/attribute/Slot;DLjava/util/UUID;)V", "getAmount", "()D", "getName", "()Ljava/lang/String;", "getOperation", "()Lcom/lgou2w/ldk/bukkit/attribute/Operation;", "getSlot", "()Lcom/lgou2w/ldk/bukkit/attribute/Slot;", "getType", "()Lcom/lgou2w/ldk/bukkit/attribute/AttributeType;", "getUuid", "()Ljava/util/UUID;", "compareTo", "", "other", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "", "hashCode", "save", "Lcom/lgou2w/ldk/nbt/NBTTagCompound;", "root", "serialize", "", "toString", "Companion", "ldk-bukkit-common"})
public final class AttributeItemModifier
implements ConfigurationSerializable,
NBTSavable,
Comparable<AttributeItemModifier> {
    @NotNull
    private final AttributeType type;
    @NotNull
    private final String name;
    @NotNull
    private final Operation operation;
    @Nullable
    private final Slot slot;
    private final double amount;
    @NotNull
    private final UUID uuid;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public NBTTagCompound save(@NotNull NBTTagCompound root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        root.putString("AttributeName", this.type.getValue());
        root.putString("Name", this.type.getValue());
        root.putInt("Operation", this.operation.getValue().intValue());
        if (this.slot != null) {
            root.putString("Slot", this.slot.getValue());
        }
        root.putDouble("Amount", this.amount);
        if (MinecraftBukkitVersion.Companion.isV116OrLater()) {
            root.putIntArray("UUID", NBTFactory.writeUniqueIdIntArray((UUID)this.uuid));
        } else {
            root.putLong("UUIDLeast", this.uuid.getLeastSignificantBits());
            root.putLong("UUIDMost", this.uuid.getMostSignificantBits());
        }
        return root;
    }

    @Override
    public int compareTo(@NotNull AttributeItemModifier other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Slot slot = this.slot;
        Slot slot2 = other.slot;
        return ComparisonChain.Companion.start().compare((Comparable)((Object)this.type), (Comparable)((Object)other.type)).compare((Comparable)((Object)this.name), (Comparable)((Object)other.name)).compare((Comparable)((Object)this.operation), (Comparable)((Object)other.operation)).compare(slot != null ? slot.ordinal() : -1, slot2 != null ? slot2.ordinal() : -1).compare(this.amount, other.amount).compare((Comparable)this.uuid, (Comparable)other.uuid).getResult();
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap result = new LinkedHashMap();
        ((Map)result).put("type", this.type.getValue());
        ((Map)result).put("name", this.name);
        ((Map)result).put("operation", Integer.valueOf(this.operation.getValue()));
        if (this.slot != null) {
            ((Map)result).put("slot", this.slot.getValue());
        }
        ((Map)result).put("amount", this.amount);
        Map map = result;
        String string = this.uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid.toString()");
        map.put("uuid", string);
        return result;
    }

    @NotNull
    public final AttributeType getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Operation getOperation() {
        return this.operation;
    }

    @Nullable
    public final Slot getSlot() {
        return this.slot;
    }

    public final double getAmount() {
        return this.amount;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public AttributeItemModifier(@NotNull AttributeType type, @NotNull String name, @NotNull Operation operation, @Nullable Slot slot, double amount, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.type = type;
        this.name = name;
        this.operation = operation;
        this.slot = slot;
        this.amount = amount;
        this.uuid = uuid;
    }

    public /* synthetic */ AttributeItemModifier(AttributeType attributeType, String string, Operation operation, Slot slot, double d, UUID uUID, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = attributeType.name();
        }
        this(attributeType, string, operation, slot, d, uUID);
    }

    static {
        ConfigurationSerialization.registerClass(AttributeItemModifier.class);
    }

    @NotNull
    public final AttributeType component1() {
        return this.type;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Operation component3() {
        return this.operation;
    }

    @Nullable
    public final Slot component4() {
        return this.slot;
    }

    public final double component5() {
        return this.amount;
    }

    @NotNull
    public final UUID component6() {
        return this.uuid;
    }

    @NotNull
    public final AttributeItemModifier copy(@NotNull AttributeType type, @NotNull String name, @NotNull Operation operation, @Nullable Slot slot, double amount, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return new AttributeItemModifier(type, name, operation, slot, amount, uuid);
    }

    public static /* synthetic */ AttributeItemModifier copy$default(AttributeItemModifier attributeItemModifier, AttributeType attributeType, String string, Operation operation, Slot slot, double d, UUID uUID, int n, Object object) {
        if ((n & 1) != 0) {
            attributeType = attributeItemModifier.type;
        }
        if ((n & 2) != 0) {
            string = attributeItemModifier.name;
        }
        if ((n & 4) != 0) {
            operation = attributeItemModifier.operation;
        }
        if ((n & 8) != 0) {
            slot = attributeItemModifier.slot;
        }
        if ((n & 0x10) != 0) {
            d = attributeItemModifier.amount;
        }
        if ((n & 0x20) != 0) {
            uUID = attributeItemModifier.uuid;
        }
        return attributeItemModifier.copy(attributeType, string, operation, slot, d, uUID);
    }

    @NotNull
    public String toString() {
        return "AttributeItemModifier(type=" + (Object)((Object)this.type) + ", name=" + this.name + ", operation=" + (Object)((Object)this.operation) + ", slot=" + (Object)((Object)this.slot) + ", amount=" + this.amount + ", uuid=" + this.uuid + ")";
    }

    public int hashCode() {
        AttributeType attributeType = this.type;
        String string = this.name;
        Operation operation = this.operation;
        Slot slot = this.slot;
        UUID uUID = this.uuid;
        return (((((attributeType != null ? ((Object)((Object)attributeType)).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (operation != null ? ((Object)((Object)operation)).hashCode() : 0)) * 31 + (slot != null ? ((Object)((Object)slot)).hashCode() : 0)) * 31 + Double.hashCode(this.amount)) * 31 + (uUID != null ? ((Object)uUID).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AttributeItemModifier)) break block3;
                AttributeItemModifier attributeItemModifier = (AttributeItemModifier)object;
                if (!Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)attributeItemModifier.type)) || !Intrinsics.areEqual((Object)this.name, (Object)attributeItemModifier.name) || !Intrinsics.areEqual((Object)((Object)this.operation), (Object)((Object)attributeItemModifier.operation)) || !Intrinsics.areEqual((Object)((Object)this.slot), (Object)((Object)attributeItemModifier.slot)) || Double.compare(this.amount, attributeItemModifier.amount) != 0 || !Intrinsics.areEqual((Object)this.uuid, (Object)attributeItemModifier.uuid)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final AttributeItemModifier deserialize(@NotNull Map<String, ? extends Object> args) {
        return Companion.deserialize(args);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/lgou2w/ldk/bukkit/attribute/AttributeItemModifier$Companion;", "", "()V", "deserialize", "Lcom/lgou2w/ldk/bukkit/attribute/AttributeItemModifier;", "args", "", "", "ldk-bukkit-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final AttributeItemModifier deserialize(@NotNull Map<String, ? extends Object> args) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            AttributeType type = AttributeType.Companion.of(CommonKt.notNull((Object)args.get("type"), (String)"Attribute type").toString());
            Integer n = StringsKt.toIntOrNull((String)String.valueOf(args.get("operation")));
            Operation operation = (Operation)Enums.ofValuableNotNull$default(Operation.class, (Object)(n != null ? n : 0), null, (int)4, null);
            Object object = args.get("slot");
            Slot slot = (Slot)Enums.ofValuable$default(Slot.class, (Object)(object != null ? object.toString() : null), null, (int)4, null);
            Double d = StringsKt.toDoubleOrNull((String)String.valueOf(args.get("amount")));
            double amount = d != null ? d : 0.0;
            Object object2 = args.get("uuid");
            UUID uuid = UUID.fromString(object2 != null ? object2.toString() : null);
            Object object3 = args.get("name");
            if (object3 == null || (object3 = object3.toString()) == null) {
                object3 = type.name();
            }
            Object name = object3;
            UUID uUID = uuid;
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
            return new AttributeItemModifier(type, (String)name, operation, slot, amount, uUID);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

