/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.bukkit.block;

import com.lgou2w.ldk.bukkit.block.BlockFactory;
import com.lgou2w.ldk.bukkit.nbt.NBTFactory;
import com.lgou2w.ldk.bukkit.packet.PacketFactory;
import com.lgou2w.ldk.bukkit.reflect.LazyReflectionKt;
import com.lgou2w.ldk.bukkit.version.MinecraftBukkitVersion;
import com.lgou2w.ldk.nbt.NBTBase;
import com.lgou2w.ldk.nbt.NBTTagCompound;
import com.lgou2w.ldk.nbt.NBTType;
import com.lgou2w.ldk.reflect.AccessorConstructor;
import com.lgou2w.ldk.reflect.AccessorMethod;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010\u00012\u0006\u0010?\u001a\u00020@H\u0007J3\u0010A\u001a\u00020@2\u0006\u0010?\u001a\u00020@2!\u0010B\u001a\u001d\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020E0Cj\b\u0012\u0004\u0012\u00020D`F\u00a2\u0006\u0002\bGH\u0007J\u0010\u0010H\u001a\u00020D2\u0006\u0010?\u001a\u00020@H\u0007J\u0018\u0010I\u001a\u00020E2\u0006\u0010?\u001a\u00020@2\u0006\u0010J\u001a\u00020DH\u0007R%\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R%\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\t\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\u0007R%\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\t\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0007R%\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\t\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0007R%\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\t\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0007R%\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\t\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0007R'\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\t\u0012\u0004\b \u0010\u0002\u001a\u0004\b!\u0010\"R-\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010%8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010\t\u0012\u0004\b&\u0010\u0002\u001a\u0004\b'\u0010(R/\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010%8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010\t\u0012\u0004\b+\u0010\u0002\u001a\u0004\b,\u0010(R-\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010%8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b1\u0010\t\u0012\u0004\b/\u0010\u0002\u001a\u0004\b0\u0010(R/\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010%8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b5\u0010\t\u0012\u0004\b3\u0010\u0002\u001a\u0004\b4\u0010(R-\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010%8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b9\u0010\t\u0012\u0004\b7\u0010\u0002\u001a\u0004\b8\u0010(R-\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010%8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b=\u0010\t\u0012\u0004\b;\u0010\u0002\u001a\u0004\b<\u0010(\u00a8\u0006K"}, d2={"Lcom/lgou2w/ldk/bukkit/block/BlockFactory;", "", "()V", "CLASS_BLOCK_POSITION", "Ljava/lang/Class;", "getCLASS_BLOCK_POSITION$annotations", "getCLASS_BLOCK_POSITION", "()Ljava/lang/Class;", "CLASS_BLOCK_POSITION$delegate", "Lkotlin/Lazy;", "CLASS_CRAFT_WORLD", "getCLASS_CRAFT_WORLD$annotations", "getCLASS_CRAFT_WORLD", "CLASS_CRAFT_WORLD$delegate", "CLASS_IBLOCK_ACCESS", "getCLASS_IBLOCK_ACCESS$annotations", "getCLASS_IBLOCK_ACCESS", "CLASS_IBLOCK_ACCESS$delegate", "CLASS_IBLOCK_DATA", "getCLASS_IBLOCK_DATA$annotations", "getCLASS_IBLOCK_DATA", "CLASS_IBLOCK_DATA$delegate", "CLASS_TILE_ENTITY", "getCLASS_TILE_ENTITY$annotations", "getCLASS_TILE_ENTITY", "CLASS_TILE_ENTITY$delegate", "CLASS_WORLD", "getCLASS_WORLD$annotations", "getCLASS_WORLD", "CLASS_WORLD$delegate", "CONSTRUCTOR_BLOCK_POSITION", "Lcom/lgou2w/ldk/reflect/AccessorConstructor;", "getCONSTRUCTOR_BLOCK_POSITION$annotations", "getCONSTRUCTOR_BLOCK_POSITION", "()Lcom/lgou2w/ldk/reflect/AccessorConstructor;", "CONSTRUCTOR_BLOCK_POSITION$delegate", "METHOD_CRAFT_WORLD_HANDLE", "Lcom/lgou2w/ldk/reflect/AccessorMethod;", "getMETHOD_CRAFT_WORLD_HANDLE$annotations", "getMETHOD_CRAFT_WORLD_HANDLE", "()Lcom/lgou2w/ldk/reflect/AccessorMethod;", "METHOD_CRAFT_WORLD_HANDLE$delegate", "METHOD_IBLOCK_ACCESS_GET_TILE_ENTITY", "getMETHOD_IBLOCK_ACCESS_GET_TILE_ENTITY$annotations", "getMETHOD_IBLOCK_ACCESS_GET_TILE_ENTITY", "METHOD_IBLOCK_ACCESS_GET_TILE_ENTITY$delegate", "METHOD_IBLOCK_ACCESS_GET_TYPE", "getMETHOD_IBLOCK_ACCESS_GET_TYPE$annotations", "getMETHOD_IBLOCK_ACCESS_GET_TYPE", "METHOD_IBLOCK_ACCESS_GET_TYPE$delegate", "METHOD_TILE_ENTITY_GET_UPDATE_PACKET", "getMETHOD_TILE_ENTITY_GET_UPDATE_PACKET$annotations", "getMETHOD_TILE_ENTITY_GET_UPDATE_PACKET", "METHOD_TILE_ENTITY_GET_UPDATE_PACKET$delegate", "METHOD_TILE_ENTITY_READ", "getMETHOD_TILE_ENTITY_READ$annotations", "getMETHOD_TILE_ENTITY_READ", "METHOD_TILE_ENTITY_READ$delegate", "METHOD_TILE_ENTITY_WRITE", "getMETHOD_TILE_ENTITY_WRITE$annotations", "getMETHOD_TILE_ENTITY_WRITE", "METHOD_TILE_ENTITY_WRITE$delegate", "getTileEntity", "block", "Lorg/bukkit/block/Block;", "modifyTag", "applicator", "Lkotlin/Function1;", "Lcom/lgou2w/ldk/nbt/NBTTagCompound;", "", "Lcom/lgou2w/ldk/common/Applicator;", "Lkotlin/ExtensionFunctionType;", "readTag", "writeTag", "tag", "ldk-bukkit-common"})
public final class BlockFactory {
    @NotNull
    private static final Lazy CLASS_WORLD$delegate;
    @NotNull
    private static final Lazy CLASS_TILE_ENTITY$delegate;
    @NotNull
    private static final Lazy CLASS_BLOCK_POSITION$delegate;
    @NotNull
    private static final Lazy CLASS_IBLOCK_ACCESS$delegate;
    @NotNull
    private static final Lazy CLASS_IBLOCK_DATA$delegate;
    @NotNull
    private static final Lazy CLASS_CRAFT_WORLD$delegate;
    @NotNull
    private static final Lazy CONSTRUCTOR_BLOCK_POSITION$delegate;
    @NotNull
    private static final Lazy METHOD_CRAFT_WORLD_HANDLE$delegate;
    @NotNull
    private static final Lazy METHOD_IBLOCK_ACCESS_GET_TILE_ENTITY$delegate;
    @NotNull
    private static final Lazy METHOD_IBLOCK_ACCESS_GET_TYPE$delegate;
    @NotNull
    private static final Lazy METHOD_TILE_ENTITY_GET_UPDATE_PACKET$delegate;
    @NotNull
    private static final Lazy METHOD_TILE_ENTITY_WRITE$delegate;
    @NotNull
    private static final Lazy METHOD_TILE_ENTITY_READ$delegate;
    public static final BlockFactory INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getCLASS_WORLD$annotations() {
    }

    @NotNull
    public static final Class<?> getCLASS_WORLD() {
        Lazy lazy = CLASS_WORLD$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (Class)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getCLASS_TILE_ENTITY$annotations() {
    }

    @NotNull
    public static final Class<?> getCLASS_TILE_ENTITY() {
        Lazy lazy = CLASS_TILE_ENTITY$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (Class)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getCLASS_BLOCK_POSITION$annotations() {
    }

    @NotNull
    public static final Class<?> getCLASS_BLOCK_POSITION() {
        Lazy lazy = CLASS_BLOCK_POSITION$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (Class)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getCLASS_IBLOCK_ACCESS$annotations() {
    }

    @NotNull
    public static final Class<?> getCLASS_IBLOCK_ACCESS() {
        Lazy lazy = CLASS_IBLOCK_ACCESS$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (Class)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getCLASS_IBLOCK_DATA$annotations() {
    }

    @NotNull
    public static final Class<?> getCLASS_IBLOCK_DATA() {
        Lazy lazy = CLASS_IBLOCK_DATA$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (Class)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getCLASS_CRAFT_WORLD$annotations() {
    }

    @NotNull
    public static final Class<?> getCLASS_CRAFT_WORLD() {
        Lazy lazy = CLASS_CRAFT_WORLD$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (Class)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getCONSTRUCTOR_BLOCK_POSITION$annotations() {
    }

    @NotNull
    public static final AccessorConstructor<Object> getCONSTRUCTOR_BLOCK_POSITION() {
        Lazy lazy = CONSTRUCTOR_BLOCK_POSITION$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (AccessorConstructor)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getMETHOD_CRAFT_WORLD_HANDLE$annotations() {
    }

    @NotNull
    public static final AccessorMethod<Object, Object> getMETHOD_CRAFT_WORLD_HANDLE() {
        Lazy lazy = METHOD_CRAFT_WORLD_HANDLE$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (AccessorMethod)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getMETHOD_IBLOCK_ACCESS_GET_TILE_ENTITY$annotations() {
    }

    @NotNull
    public static final AccessorMethod<Object, Object> getMETHOD_IBLOCK_ACCESS_GET_TILE_ENTITY() {
        Lazy lazy = METHOD_IBLOCK_ACCESS_GET_TILE_ENTITY$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (AccessorMethod)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getMETHOD_IBLOCK_ACCESS_GET_TYPE$annotations() {
    }

    @NotNull
    public static final AccessorMethod<Object, Object> getMETHOD_IBLOCK_ACCESS_GET_TYPE() {
        Lazy lazy = METHOD_IBLOCK_ACCESS_GET_TYPE$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (AccessorMethod)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getMETHOD_TILE_ENTITY_GET_UPDATE_PACKET$annotations() {
    }

    @NotNull
    public static final AccessorMethod<Object, Object> getMETHOD_TILE_ENTITY_GET_UPDATE_PACKET() {
        Lazy lazy = METHOD_TILE_ENTITY_GET_UPDATE_PACKET$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (AccessorMethod)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getMETHOD_TILE_ENTITY_WRITE$annotations() {
    }

    @NotNull
    public static final AccessorMethod<Object, Object> getMETHOD_TILE_ENTITY_WRITE() {
        Lazy lazy = METHOD_TILE_ENTITY_WRITE$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (AccessorMethod)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getMETHOD_TILE_ENTITY_READ$annotations() {
    }

    @NotNull
    public static final AccessorMethod<Object, Object> getMETHOD_TILE_ENTITY_READ() {
        Lazy lazy = METHOD_TILE_ENTITY_READ$delegate;
        BlockFactory blockFactory = INSTANCE;
        Object var2_2 = null;
        boolean bl = false;
        return (AccessorMethod)lazy.getValue();
    }

    @JvmStatic
    @Nullable
    public static final Object getTileEntity(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        Object world = BlockFactory.getMETHOD_CRAFT_WORLD_HANDLE().invoke((Object)block.getWorld(), new Object[0]);
        Object position = BlockFactory.getCONSTRUCTOR_BLOCK_POSITION().newInstance(new Object[]{x, y, z});
        return BlockFactory.getMETHOD_IBLOCK_ACCESS_GET_TILE_ENTITY().invoke(world, new Object[]{position});
    }

    @JvmStatic
    @NotNull
    public static final NBTTagCompound readTag(@NotNull Block block) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Object object = BlockFactory.getTileEntity(block);
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("The block type is not a TileEntity object.");
        }
        Object tileEntity = object;
        Object tag = NBTFactory.createInternal$default((NBTType)NBTType.TAG_COMPOUND, null, (int)2, null);
        BlockFactory.getMETHOD_TILE_ENTITY_READ().invoke(tileEntity, new Object[]{tag});
        NBTBase nBTBase = NBTFactory.fromNMS((Object)tag);
        if (nBTBase == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.lgou2w.ldk.nbt.NBTTagCompound");
        }
        return (NBTTagCompound)nBTBase;
    }

    @JvmStatic
    public static final void writeTag(@NotNull Block block, @NotNull NBTTagCompound tag) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object object = BlockFactory.getTileEntity(block);
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("The block type is not a TileEntity object.");
        }
        Object tileEntity = object;
        Object internal = NBTFactory.toNMS((NBTBase)((NBTBase)tag));
        if (MinecraftBukkitVersion.Companion.isV116OrLater()) {
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            Object world = BlockFactory.getMETHOD_CRAFT_WORLD_HANDLE().invoke((Object)block.getWorld(), new Object[0]);
            Object position = BlockFactory.getCONSTRUCTOR_BLOCK_POSITION().newInstance(new Object[]{x, y, z});
            Object blockData = BlockFactory.getMETHOD_IBLOCK_ACCESS_GET_TYPE().invoke(world, new Object[]{position});
            BlockFactory.getMETHOD_TILE_ENTITY_WRITE().invoke(tileEntity, new Object[]{blockData, internal});
        } else {
            BlockFactory.getMETHOD_TILE_ENTITY_WRITE().invoke(tileEntity, new Object[]{internal});
        }
        Object packet = BlockFactory.getMETHOD_TILE_ENTITY_GET_UPDATE_PACKET().invoke(tileEntity, new Object[0]);
        if (packet != null) {
            Server server = Bukkit.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)server, (String)"Bukkit.getServer()");
            double range = (double)(server.getViewDistance() * 32) + 0.0;
            Location location = block.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"block.location");
            PacketFactory.sendPacketToNearby(packet, location, range);
        }
    }

    @JvmStatic
    @NotNull
    public static final Block modifyTag(@NotNull Block block, @NotNull Function1<? super NBTTagCompound, Unit> applicator) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(applicator, (String)"applicator");
        NBTTagCompound tag = BlockFactory.readTag(block);
        applicator.invoke((Object)tag);
        BlockFactory.writeTag(block, tag);
        return block;
    }

    private BlockFactory() {
    }

    static {
        BlockFactory blockFactory;
        INSTANCE = blockFactory = new BlockFactory();
        CLASS_WORLD$delegate = LazyReflectionKt.lazyMinecraftClass((String)"World");
        CLASS_TILE_ENTITY$delegate = LazyReflectionKt.lazyMinecraftClass((String)"TileEntity");
        CLASS_BLOCK_POSITION$delegate = LazyReflectionKt.lazyMinecraftClass((String)"BlockPosition");
        CLASS_IBLOCK_ACCESS$delegate = LazyReflectionKt.lazyMinecraftClass((String)"IBlockAccess");
        CLASS_IBLOCK_DATA$delegate = LazyReflectionKt.lazyMinecraftClass((String)"IBlockData");
        CLASS_CRAFT_WORLD$delegate = LazyReflectionKt.lazyCraftBukkitClass((String)"CraftWorld");
        CONSTRUCTOR_BLOCK_POSITION$delegate = LazyKt.lazy((Function0)CONSTRUCTOR_BLOCK_POSITION.2.INSTANCE);
        METHOD_CRAFT_WORLD_HANDLE$delegate = LazyKt.lazy((Function0)METHOD_CRAFT_WORLD_HANDLE.2.INSTANCE);
        METHOD_IBLOCK_ACCESS_GET_TILE_ENTITY$delegate = LazyKt.lazy((Function0)METHOD_IBLOCK_ACCESS_GET_TILE_ENTITY.2.INSTANCE);
        METHOD_IBLOCK_ACCESS_GET_TYPE$delegate = LazyKt.lazy((Function0)METHOD_IBLOCK_ACCESS_GET_TYPE.2.INSTANCE);
        METHOD_TILE_ENTITY_GET_UPDATE_PACKET$delegate = LazyKt.lazy((Function0)METHOD_TILE_ENTITY_GET_UPDATE_PACKET.2.INSTANCE);
        METHOD_TILE_ENTITY_WRITE$delegate = LazyKt.lazy((Function0)METHOD_TILE_ENTITY_WRITE.2.INSTANCE);
        METHOD_TILE_ENTITY_READ$delegate = LazyKt.lazy((Function0)METHOD_TILE_ENTITY_READ.2.INSTANCE);
    }
}

