/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.bukkit.firework;

import com.lgou2w.ldk.bukkit.BukkitExtendedKt;
import com.lgou2w.ldk.bukkit.firework.FireworkEffect;
import com.lgou2w.ldk.bukkit.firework.FireworkType;
import com.lgou2w.ldk.common.Builder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u0002H\u0016J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0000J\u001f\u0010\u0010\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0011\"\u00020\n\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0000J\u001f\u0010\u0014\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0011\"\u00020\n\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/lgou2w/ldk/bukkit/firework/FireworkEffectBuilder;", "Lcom/lgou2w/ldk/common/Builder;", "Lcom/lgou2w/ldk/bukkit/firework/FireworkEffect;", "type", "Lcom/lgou2w/ldk/bukkit/firework/FireworkType;", "(Lcom/lgou2w/ldk/bukkit/firework/FireworkType;)V", "canFlicker", "", "colors", "", "Lorg/bukkit/Color;", "fades", "hasTrail", "build", "with", "withColorRandom", "withColors", "", "([Lorg/bukkit/Color;)Lcom/lgou2w/ldk/bukkit/firework/FireworkEffectBuilder;", "withFadeRandom", "withFades", "withFlicker", "withFlickerRandom", "withTrail", "withTrailRandom", "ldk-bukkit-common"})
public final class FireworkEffectBuilder
implements Builder<FireworkEffect> {
    private boolean canFlicker;
    private boolean hasTrail;
    private final List<Color> colors;
    private final List<Color> fades;
    private FireworkType type;

    @NotNull
    public final FireworkEffectBuilder with(@NotNull FireworkType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        return this;
    }

    @NotNull
    public final FireworkEffectBuilder withFlicker() {
        this.canFlicker = true;
        return this;
    }

    @NotNull
    public final FireworkEffectBuilder withFlickerRandom() {
        this.canFlicker = Random.Default.nextBoolean();
        return this;
    }

    @NotNull
    public final FireworkEffectBuilder withTrail() {
        this.hasTrail = true;
        return this;
    }

    @NotNull
    public final FireworkEffectBuilder withTrailRandom() {
        this.hasTrail = Random.Default.nextBoolean();
        return this;
    }

    @NotNull
    public final FireworkEffectBuilder withColors(Color ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        CollectionsKt.addAll((Collection)this.colors, (Object[])colors);
        return this;
    }

    @NotNull
    public final FireworkEffectBuilder withColorRandom() {
        this.colors.add(BukkitExtendedKt.randomColor());
        return this;
    }

    @NotNull
    public final FireworkEffectBuilder withFades(Color ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        CollectionsKt.addAll((Collection)this.fades, (Object[])colors);
        return this;
    }

    @NotNull
    public final FireworkEffectBuilder withFadeRandom() {
        this.fades.add(BukkitExtendedKt.randomColor());
        return this;
    }

    @NotNull
    public FireworkEffect build() {
        List<Color> list = Collections.unmodifiableList(this.colors);
        Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.unmodifiableList(colors)");
        List<Color> list2 = Collections.unmodifiableList(this.fades);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"Collections.unmodifiableList(fades)");
        return new FireworkEffect(this.type, this.canFlicker, this.hasTrail, list, list2);
    }

    public FireworkEffectBuilder(@NotNull FireworkType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.colors = new ArrayList();
        this.fades = new ArrayList();
    }
}

