/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.bukkit.potion;

import com.lgou2w.ldk.bukkit.potion.PotionType;
import com.lgou2w.ldk.common.ComparisonChain;
import com.lgou2w.ldk.common.Enums;
import com.lgou2w.ldk.common.Valuable;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001\u001bB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/lgou2w/ldk/bukkit/potion/PotionBase;", "Lcom/lgou2w/ldk/common/Valuable;", "", "", "type", "Lcom/lgou2w/ldk/bukkit/potion/PotionType;", "isUpgraded", "", "isExtended", "(Lcom/lgou2w/ldk/bukkit/potion/PotionType;ZZ)V", "()Z", "getType", "()Lcom/lgou2w/ldk/bukkit/potion/PotionType;", "value", "getValue", "()Ljava/lang/String;", "compareTo", "", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "Companion", "ldk-bukkit-common"})
public final class PotionBase
implements Valuable<String>,
Comparable<PotionBase> {
    @NotNull
    private final PotionType type;
    private final boolean isUpgraded;
    private final boolean isExtended;
    @NotNull
    public static final String PREFIX_UPGRADED = "strong";
    @NotNull
    public static final String PREFIX_EXTENDED = "long";
    @NotNull
    public static final String REPLACEMENT = "_";
    public static final Companion Companion = new Companion(null);

    @Override
    public int compareTo(@NotNull PotionBase other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ComparisonChain.Companion.start().compare((Comparable)((Object)this.type), (Comparable)((Object)other.type)).compare((Comparable)Boolean.valueOf(this.isUpgraded), (Comparable)Boolean.valueOf(other.isUpgraded)).compare((Comparable)Boolean.valueOf(this.isExtended), (Comparable)Boolean.valueOf(other.isExtended)).getResult();
    }

    @NotNull
    public String getValue() {
        return this.isUpgraded ? "strong_" + this.type.getValue() : (this.isExtended ? "long_" + this.type.getValue() : this.type.getValue());
    }

    @NotNull
    public final PotionType getType() {
        return this.type;
    }

    public final boolean isUpgraded() {
        return this.isUpgraded;
    }

    public final boolean isExtended() {
        return this.isExtended;
    }

    public PotionBase(@NotNull PotionType type, boolean isUpgraded, boolean isExtended) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.isUpgraded = isUpgraded;
        this.isExtended = isExtended;
        if (this.isUpgraded && !this.type.getCanUpgradable()) {
            throw (Throwable)new IllegalArgumentException("Potion Type " + (Object)((Object)this.type) + " is not upgradable.");
        }
        if (this.isExtended && !this.type.getCanExtendable()) {
            throw (Throwable)new IllegalArgumentException("Potion Type " + (Object)((Object)this.type) + " is not extendable.");
        }
        if (this.isExtended && this.isUpgraded) {
            throw (Throwable)new IllegalArgumentException("Potion cannot be both extended and upgraded.");
        }
    }

    @NotNull
    public final PotionType component1() {
        return this.type;
    }

    public final boolean component2() {
        return this.isUpgraded;
    }

    public final boolean component3() {
        return this.isExtended;
    }

    @NotNull
    public final PotionBase copy(@NotNull PotionType type, boolean isUpgraded, boolean isExtended) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new PotionBase(type, isUpgraded, isExtended);
    }

    public static /* synthetic */ PotionBase copy$default(PotionBase potionBase, PotionType potionType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            potionType = potionBase.type;
        }
        if ((n & 2) != 0) {
            bl = potionBase.isUpgraded;
        }
        if ((n & 4) != 0) {
            bl2 = potionBase.isExtended;
        }
        return potionBase.copy(potionType, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "PotionBase(type=" + (Object)((Object)this.type) + ", isUpgraded=" + this.isUpgraded + ", isExtended=" + this.isExtended + ")";
    }

    public int hashCode() {
        PotionType potionType = this.type;
        int n = (potionType != null ? ((Object)((Object)potionType)).hashCode() : 0) * 31;
        int n2 = this.isUpgraded ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        int n3 = (n + n2) * 31;
        int n4 = this.isExtended ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        return n3 + n4;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PotionBase)) break block3;
                PotionBase potionBase = (PotionBase)object;
                if (!Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)potionBase.type)) || this.isUpgraded != potionBase.isUpgraded || this.isExtended != potionBase.isExtended) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final PotionBase valueOf(@NotNull String value) throws IllegalArgumentException {
        return Companion.valueOf(value);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/lgou2w/ldk/bukkit/potion/PotionBase$Companion;", "", "()V", "PREFIX_EXTENDED", "", "PREFIX_UPGRADED", "REPLACEMENT", "valueOf", "Lcom/lgou2w/ldk/bukkit/potion/PotionBase;", "value", "ldk-bukkit-common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PotionBase valueOf(@NotNull String value) throws IllegalArgumentException {
            PotionType potionType;
            boolean bl;
            int n;
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            boolean isUpgraded = StringsKt.startsWith$default((String)value, (String)PotionBase.PREFIX_UPGRADED, (boolean)false, (int)2, null);
            boolean isExtended = StringsKt.startsWith$default((String)value, (String)PotionBase.PREFIX_EXTENDED, (boolean)false, (int)2, null);
            int replacement = PotionBase.REPLACEMENT.length();
            if (isUpgraded) {
                string = value;
                n = PotionBase.PREFIX_UPGRADED.length() + replacement;
                bl = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                potionType = (PotionType)Enums.ofValuableNotNull$default(PotionType.class, (Object)string2, null, (int)4, null);
            } else if (isExtended) {
                string = value;
                n = PotionBase.PREFIX_EXTENDED.length() + replacement;
                bl = false;
                String string3 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                potionType = (PotionType)Enums.ofValuableNotNull$default(PotionType.class, (Object)string3, null, (int)4, null);
            } else {
                potionType = PotionType.WATER;
            }
            PotionType type = potionType;
            return type == PotionType.WATER ? new PotionBase(PotionType.WATER, false, false) : new PotionBase(type, isUpgraded, isExtended);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

