/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.chat;

import com.lgou2w.ldk.chat.ChatComponent;
import com.lgou2w.ldk.chat.ChatComponentText;
import com.lgou2w.ldk.chat.ChatSerializer;
import com.lgou2w.ldk.chat.ChatStyle;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\u0011\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\u0012\u0010\u0010\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00010\bj\b\u0012\u0004\u0012\u00020\u0001`\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/lgou2w/ldk/chat/ChatComponentAbstract;", "Lcom/lgou2w/ldk/chat/ChatComponent;", "()V", "extraSize", "", "getExtraSize", "()I", "extras", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getExtras", "()Ljava/util/ArrayList;", "style", "Lcom/lgou2w/ldk/chat/ChatStyle;", "getStyle", "()Lcom/lgou2w/ldk/chat/ChatStyle;", "setStyle", "(Lcom/lgou2w/ldk/chat/ChatStyle;)V", "append", "extra", "text", "", "equals", "", "other", "", "hashCode", "plus", "toJson", "toRaw", "color", "toString", "ldk-chat"})
public abstract class ChatComponentAbstract
implements ChatComponent {
    @NotNull
    private ChatStyle style = new ChatStyle();
    @NotNull
    private final ArrayList<ChatComponent> extras = new ArrayList();

    @Override
    @NotNull
    public ChatStyle getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(@NotNull ChatStyle chatStyle) {
        Intrinsics.checkNotNullParameter((Object)chatStyle, (String)"<set-?>");
        this.style = chatStyle;
    }

    @NotNull
    public ArrayList<ChatComponent> getExtras() {
        return this.extras;
    }

    @Override
    @NotNull
    public ChatComponent setStyle(@Nullable ChatStyle style) {
        ChatStyle chatStyle = style;
        if (chatStyle == null) {
            chatStyle = new ChatStyle();
        }
        this.setStyle(chatStyle);
        return this;
    }

    @Override
    public int getExtraSize() {
        return ((ArrayList)this.getExtras()).size();
    }

    @Override
    @NotNull
    public ChatComponent append(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.append(new ChatComponentText(text));
    }

    @Override
    @NotNull
    public ChatComponent append(@NotNull ChatComponent extra) {
        Intrinsics.checkNotNullParameter((Object)extra, (String)"extra");
        ((ArrayList)this.getExtras()).add(extra);
        return this;
    }

    @Override
    @NotNull
    public String toJson() {
        return ChatSerializer.toJson(this);
    }

    @Override
    @NotNull
    public String toRaw() {
        return ChatSerializer.toRaw(this);
    }

    @Override
    @NotNull
    public String toRaw(boolean color) {
        return ChatSerializer.toRaw(this, color);
    }

    @Override
    @NotNull
    public ChatComponent plus(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.plus(ChatSerializer.fromRaw(text));
    }

    @Override
    @NotNull
    public ChatComponent plus(@NotNull ChatComponent extra) {
        Intrinsics.checkNotNullParameter((Object)extra, (String)"extra");
        return this.append(extra);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ChatComponentAbstract) {
            return Intrinsics.areEqual((Object)this.getStyle(), (Object)((ChatComponentAbstract)other).getStyle()) && Intrinsics.areEqual((Object)this.getExtras(), (Object)((ChatComponentAbstract)other).getExtras());
        }
        return false;
    }

    public int hashCode() {
        int result = this.getStyle().hashCode();
        result = 31 * result + ((ArrayList)this.getExtras()).hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "ChatComponentAbstract(style=" + this.getStyle() + ", extras=" + this.getExtras() + ')';
    }
}

