/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.chat;

import com.lgou2w.ldk.chat.ChatClickEvent;
import com.lgou2w.ldk.chat.ChatComponent;
import com.lgou2w.ldk.chat.ChatComponentText;
import com.lgou2w.ldk.chat.ChatHoverEvent;
import com.lgou2w.ldk.chat.ChatSerializer;
import com.lgou2w.ldk.chat.Color;
import com.lgou2w.ldk.common.Builder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0002J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0002J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u001f\u0010)\u001a\u00020\u00002\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040+\"\u00020\u0004\u00a2\u0006\u0002\u0010,J\u0014\u0010)\u001a\u00020\u00002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040.J\u0006\u0010/\u001a\u00020\u0000J\u0016\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0004J\u0016\u00105\u001a\u00020\u00002\u0006\u00101\u001a\u0002062\u0006\u0010\u001b\u001a\u00020\u0002J\u000e\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0004J\u0006\u00109\u001a\u00020\u0000J\u0006\u0010:\u001a\u00020\u0000J\u0006\u0010;\u001a\u00020\u0000J\u0006\u0010<\u001a\u00020\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00028DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006="}, d2={"Lcom/lgou2w/ldk/chat/ChatComponentFancy;", "Lcom/lgou2w/ldk/common/Builder;", "Lcom/lgou2w/ldk/chat/ChatComponent;", "text", "", "(Ljava/lang/String;)V", "component", "(Lcom/lgou2w/ldk/chat/ChatComponent;)V", "extras", "", "getExtras", "()Ljava/util/List;", "last", "getLast", "()Lcom/lgou2w/ldk/chat/ChatComponent;", "size", "", "getSize", "()I", "build", "changePage", "index", "clear", "color", "Lcom/lgou2w/ldk/chat/Color;", "command", "copyToClipboard", "value", "file", "path", "join", "componentFancy", "link", "url", "suggest", "then", "thenNewLine", "tooltipComponent", "tooltipItem", "itemMojangson", "tooltipText", "tooltipTexts", "texts", "", "([Ljava/lang/String;)Lcom/lgou2w/ldk/chat/ChatComponentFancy;", "collection", "", "withBold", "withClickEvent", "action", "Lcom/lgou2w/ldk/chat/ChatClickEvent$Action;", "withFont", "font", "withHoverEvent", "Lcom/lgou2w/ldk/chat/ChatHoverEvent$Action;", "withInsertion", "insertion", "withItalic", "withObfuscated", "withStrikethrough", "withUnderlined", "ldk-chat"})
public class ChatComponentFancy
implements Builder<ChatComponent> {
    @NotNull
    private final List<ChatComponent> extras;

    @NotNull
    protected final List<ChatComponent> getExtras() {
        return this.extras;
    }

    @NotNull
    protected final ChatComponent getLast() {
        return (ChatComponent)CollectionsKt.last(this.extras);
    }

    @NotNull
    public final ChatComponentFancy then(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.then(new ChatComponentText(text));
    }

    @NotNull
    public final ChatComponentFancy then(@NotNull ChatComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.extras.add(component);
        return this;
    }

    @NotNull
    public final ChatComponentFancy color(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.getLast().getStyle().color = color;
        return this;
    }

    @NotNull
    public final ChatComponentFancy withBold() {
        this.getLast().getStyle().bold = true;
        return this;
    }

    @NotNull
    public final ChatComponentFancy withItalic() {
        this.getLast().getStyle().italic = true;
        return this;
    }

    @NotNull
    public final ChatComponentFancy withUnderlined() {
        this.getLast().getStyle().underlined = true;
        return this;
    }

    @NotNull
    public final ChatComponentFancy withStrikethrough() {
        this.getLast().getStyle().strikethrough = true;
        return this;
    }

    @NotNull
    public final ChatComponentFancy withObfuscated() {
        this.getLast().getStyle().obfuscated = true;
        return this;
    }

    @NotNull
    public final ChatComponentFancy withInsertion(@NotNull String insertion) {
        Intrinsics.checkNotNullParameter((Object)insertion, (String)"insertion");
        this.getLast().getStyle().insertion = insertion;
        return this;
    }

    @NotNull
    public final ChatComponentFancy withFont(@NotNull String font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.getLast().getStyle().font = font;
        return this;
    }

    @NotNull
    public final ChatComponentFancy withClickEvent(@NotNull ChatClickEvent.Action action, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getLast().getStyle().clickEvent = new ChatClickEvent(action, value);
        return this;
    }

    @NotNull
    public final ChatComponentFancy withHoverEvent(@NotNull ChatHoverEvent.Action action, @NotNull ChatComponent value) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getLast().getStyle().hoverEvent = new ChatHoverEvent(action, value);
        return this;
    }

    @NotNull
    public final ChatComponentFancy file(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.getLast().getStyle().clickEvent = new ChatClickEvent(ChatClickEvent.Action.OPEN_FILE, path);
        return this;
    }

    @NotNull
    public final ChatComponentFancy link(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.getLast().getStyle().clickEvent = new ChatClickEvent(ChatClickEvent.Action.OPEN_URL, url);
        return this;
    }

    @NotNull
    public final ChatComponentFancy suggest(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.getLast().getStyle().clickEvent = new ChatClickEvent(ChatClickEvent.Action.SUGGEST_COMMAND, command);
        return this;
    }

    @NotNull
    public final ChatComponentFancy command(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.getLast().getStyle().clickEvent = new ChatClickEvent(ChatClickEvent.Action.RUN_COMMAND, command);
        return this;
    }

    @NotNull
    public final ChatComponentFancy changePage(int index) {
        this.getLast().getStyle().clickEvent = new ChatClickEvent(ChatClickEvent.Action.CHANGE_PAGE, String.valueOf(index));
        return this;
    }

    @NotNull
    public final ChatComponentFancy copyToClipboard(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getLast().getStyle().clickEvent = new ChatClickEvent(ChatClickEvent.Action.COPY_TO_CLIPBOARD, value);
        return this;
    }

    @NotNull
    public final ChatComponentFancy tooltipText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.tooltipComponent(ChatSerializer.fromRaw(text));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChatComponentFancy tooltipTexts(String ... texts) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
        int lastIndex = texts.length - 1;
        String[] $this$mapIndexed$iv = texts;
        boolean $i$f$mapIndexed = false;
        String[] stringArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void str;
            void index;
            int n = index$iv$iv++;
            void var14_13 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var18_17 = index != lastIndex ? (String)str + '\n' : str;
            collection.add(var18_17);
        }
        List text = (List)destination$iv$iv;
        return this.tooltipText(CollectionsKt.joinToString$default((Iterable)text, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
    }

    @NotNull
    public final ChatComponentFancy tooltipTexts(@NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Collection<String> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<String> thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return this.tooltipTexts(Arrays.copyOf(stringArray, stringArray.length));
    }

    @NotNull
    public final ChatComponentFancy tooltipComponent(@NotNull ChatComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.getLast().getStyle().hoverEvent = new ChatHoverEvent(ChatHoverEvent.Action.SHOW_TEXT, component);
        return this;
    }

    @NotNull
    public final ChatComponentFancy tooltipItem(@NotNull String itemMojangson) {
        Intrinsics.checkNotNullParameter((Object)itemMojangson, (String)"itemMojangson");
        ChatSerializer.ChatComponentRaw componentRaw = new ChatSerializer.ChatComponentRaw(itemMojangson);
        this.getLast().getStyle().hoverEvent = new ChatHoverEvent(ChatHoverEvent.Action.SHOW_ITEM, componentRaw);
        return this;
    }

    @NotNull
    public final ChatComponentFancy join(@NotNull ChatComponentFancy componentFancy) {
        Intrinsics.checkNotNullParameter((Object)componentFancy, (String)"componentFancy");
        this.extras.addAll((Collection<ChatComponent>)componentFancy.extras);
        return this;
    }

    @NotNull
    public final ChatComponentFancy thenNewLine() {
        return this.then("\n");
    }

    public final int getSize() {
        return this.extras.size();
    }

    @NotNull
    public final ChatComponentFancy clear() {
        this.extras.clear();
        return this;
    }

    @NotNull
    public ChatComponent build() {
        ChatComponentText chatComponent = new ChatComponentText("");
        ((ArrayList)chatComponent.getExtras()).addAll((Collection)this.extras);
        return chatComponent;
    }

    public ChatComponentFancy(@NotNull ChatComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.extras = new ArrayList();
        this.then(component);
    }

    public ChatComponentFancy(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(new ChatComponentText(text));
    }
}

