/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.lgou2w.ldk.chat.ChatClickEvent;
import com.lgou2w.ldk.chat.ChatColor;
import com.lgou2w.ldk.chat.ChatComponent;
import com.lgou2w.ldk.chat.ChatComponentAbstract;
import com.lgou2w.ldk.chat.ChatComponentKeybind;
import com.lgou2w.ldk.chat.ChatComponentNBT;
import com.lgou2w.ldk.chat.ChatComponentNBTBlock;
import com.lgou2w.ldk.chat.ChatComponentNBTEntity;
import com.lgou2w.ldk.chat.ChatComponentNBTStorage;
import com.lgou2w.ldk.chat.ChatComponentScore;
import com.lgou2w.ldk.chat.ChatComponentSelector;
import com.lgou2w.ldk.chat.ChatComponentText;
import com.lgou2w.ldk.chat.ChatComponentTranslation;
import com.lgou2w.ldk.chat.ChatHoverEvent;
import com.lgou2w.ldk.chat.ChatKt;
import com.lgou2w.ldk.chat.ChatStyle;
import com.lgou2w.ldk.chat.Color;
import com.lgou2w.ldk.common.CommonKt;
import com.lgou2w.ldk.common.Enums;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\"#$%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0007J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0007J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0007J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0007J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u0007J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0013H\u0007J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020 H\u0007J$\u0010!\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020 2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\"\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006&"}, d2={"Lcom/lgou2w/ldk/chat/ChatSerializer;", "", "()V", "GSON", "Lcom/google/gson/Gson;", "getGSON$annotations", "RGB_FORMATTING_TABLE", "", "", "", "getRGB_FORMATTING_TABLE$annotations", "appendColor", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "color", "Lcom/lgou2w/ldk/chat/ChatColor;", "fromJson", "Lcom/lgou2w/ldk/chat/ChatComponent;", "json", "fromJsonLenient", "fromJsonOrLenient", "fromJsonOrNull", "fromRaw", "raw", "fromRawOrNull", "rgbToHex", "rgb", "toJson", "component", "toRaw", "", "toRaw0", "ChatComponentRaw", "ChatComponentSerializer", "ChatStyleSerializer", "RawMessage", "ldk-chat"})
public final class ChatSerializer {
    private static final Gson GSON;
    private static final Map<Integer, String> RGB_FORMATTING_TABLE;
    public static final ChatSerializer INSTANCE;

    @JvmStatic
    private static /* synthetic */ void getGSON$annotations() {
    }

    @JvmStatic
    private static /* synthetic */ void getRGB_FORMATTING_TABLE$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final ChatComponent fromJson(@NotNull String json) throws JsonParseException {
        ChatComponent chatComponent;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
            jsonReader.setLenient(false);
            Object object = GSON.getAdapter(ChatComponent.class).read(jsonReader);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GSON.getAdapter(ChatComp\u2026ss.java).read(jsonReader)");
            chatComponent = (ChatComponent)object;
        }
        catch (IOException e) {
            throw (Throwable)new JsonParseException((Throwable)e);
        }
        return chatComponent;
    }

    @JvmStatic
    @Nullable
    public static final ChatComponent fromJsonOrNull(@Nullable String json) throws JsonParseException {
        return json == null ? null : ChatSerializer.fromJson(json);
    }

    @JvmStatic
    @NotNull
    public static final ChatComponent fromJsonLenient(@NotNull String json) throws JsonParseException {
        ChatComponent chatComponent;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
            jsonReader.setLenient(true);
            Object object = GSON.getAdapter(ChatComponent.class).read(jsonReader);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GSON.getAdapter(ChatComp\u2026ss.java).read(jsonReader)");
            chatComponent = (ChatComponent)object;
        }
        catch (IOException e) {
            throw (Throwable)new JsonParseException((Throwable)e);
        }
        return chatComponent;
    }

    @JvmStatic
    @NotNull
    public static final ChatComponent fromJsonOrLenient(@NotNull String json) throws JsonParseException {
        ChatComponent chatComponent;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            chatComponent = ChatSerializer.fromJson(json);
        }
        catch (JsonParseException e) {
            chatComponent = ChatSerializer.fromJsonLenient(json);
        }
        return chatComponent;
    }

    @JvmStatic
    @NotNull
    public static final String toJson(@NotNull ChatComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        String string = GSON.toJson((Object)component);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GSON.toJson(component)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ChatComponent fromRaw(@Nullable String raw) {
        block3: {
            block2: {
                if (raw == null) break block2;
                CharSequence charSequence = raw;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return new ChatComponentText("");
        }
        return new RawMessage(ChatKt.toColor$default(raw, '\u0000', 1, null)).get();
    }

    @JvmStatic
    @Nullable
    public static final ChatComponent fromRawOrNull(@Nullable String raw) {
        return raw == null ? null : ChatSerializer.fromRaw(raw);
    }

    @JvmStatic
    @NotNull
    public static final String toRaw(@NotNull ChatComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return ChatSerializer.toRaw(component, true);
    }

    @JvmStatic
    @NotNull
    public static final String toRaw(@NotNull ChatComponent component, boolean color) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        StringBuilder builder = new StringBuilder();
        INSTANCE.toRaw0(component, color, builder);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final void toRaw0(ChatComponent component, boolean color, StringBuilder builder) {
        if (color) {
            ChatStyle chatStyle = component.getStyle();
            Color chatColor = chatStyle.color;
            if (chatColor instanceof ChatColor) {
                this.appendColor(builder, (ChatColor)chatColor);
            }
            if (CommonKt.isTrue((Boolean)chatStyle.bold)) {
                this.appendColor(builder, ChatColor.BOLD);
            }
            if (CommonKt.isTrue((Boolean)chatStyle.italic)) {
                this.appendColor(builder, ChatColor.ITALIC);
            }
            if (CommonKt.isTrue((Boolean)chatStyle.strikethrough)) {
                this.appendColor(builder, ChatColor.STRIKETHROUGH);
            }
            if (CommonKt.isTrue((Boolean)chatStyle.underlined)) {
                this.appendColor(builder, ChatColor.UNDERLINE);
            }
            if (CommonKt.isTrue((Boolean)chatStyle.obfuscated)) {
                this.appendColor(builder, ChatColor.OBFUSCATED);
            }
        }
        if (component instanceof ChatComponentText) {
            builder.append(((ChatComponentText)component).getText());
        }
        Iterable $this$forEach$iv = component.getExtras();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatComponent it = (ChatComponent)element$iv;
            boolean bl = false;
            INSTANCE.toRaw0(it, color, builder);
        }
    }

    private final void appendColor(StringBuilder builder, ChatColor color) {
        builder.append(color.toString());
    }

    private final String rgbToHex(int rgb) {
        int n = rgb >> 16 & 0xFF;
        int n2 = 16;
        int n3 = 0;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String r = string;
        n2 = rgb >> 8 & 0xFF;
        n3 = 16;
        int n4 = 0;
        String string2 = Integer.toString(n2, CharsKt.checkRadix((int)n3));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String g = string2;
        n3 = rgb & 0xFF;
        n4 = 16;
        boolean bl = false;
        String string3 = Integer.toString(n3, CharsKt.checkRadix((int)n4));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String b = string3;
        n3 = 0;
        n4 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        bl = false;
        boolean bl2 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl3 = false;
        $this$buildString.append("#");
        $this$buildString.append(r.length() == 1 ? '0' + r : r);
        $this$buildString.append(g.length() == 1 ? '0' + g : g);
        $this$buildString.append(b.length() == 1 ? '0' + b : b);
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    private ChatSerializer() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        ChatColor it;
        void $this$filterTo$iv$iv;
        ChatSerializer chatSerializer;
        INSTANCE = chatSerializer = new ChatSerializer();
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(ChatStyle.class, (Object)new ChatStyleSerializer()).registerTypeHierarchyAdapter(ChatComponent.class, (Object)new ChatComponentSerializer()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n      .reg\u2026alizer())\n      .create()");
        GSON = gson;
        ChatColor[] $this$filter$iv = ChatColor.values();
        boolean $i$f$filter = false;
        ChatColor[] chatColorArray = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            boolean bl = false;
            if (!(it.getRgb() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            it = (ChatColor)element$iv$iv;
            boolean bl = false;
            Integer n = it.getRgb();
            Intrinsics.checkNotNull((Object)n);
            String string = it.name();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            Pair pair = TuplesKt.to((Object)n, (Object)string3);
            boolean bl3 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map map = Collections.unmodifiableMap(destination$iv$iv2);
        Intrinsics.checkNotNullExpressionValue(map, (String)"Collections.unmodifiable\u2026 it.name.toLowerCase() })");
        RGB_FORMATTING_TABLE = map;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0006\u0010\u0010\u001a\u00020\u0006R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/lgou2w/ldk/chat/ChatSerializer$RawMessage;", "", "raw", "", "(Ljava/lang/String;)V", "currentComponent", "Lcom/lgou2w/ldk/chat/ChatComponent;", "currentIndex", "", "getRaw", "()Ljava/lang/String;", "style", "Lcom/lgou2w/ldk/chat/ChatStyle;", "append", "", "index", "get", "Companion", "ldk-chat"})
    private static final class RawMessage {
        private ChatComponent currentComponent;
        private ChatStyle style;
        private int currentIndex;
        @NotNull
        private final String raw;
        private static final Pattern PATTERN;
        public static final Companion Companion;

        private final void append(int index) {
            if (index > this.currentIndex) {
                String string = this.raw;
                int n = this.currentIndex;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                ChatComponentText extra = new ChatComponentText(string3);
                extra.setStyle(this.style);
                this.currentIndex = index;
                this.style = this.style.clone();
                if (this.currentComponent == null) {
                    this.currentComponent = new ChatComponentText("");
                }
                ((ChatComponent)CommonKt.notNull$default((Object)this.currentComponent, null, (int)1, null)).append(extra);
            }
        }

        @NotNull
        public final ChatComponent get() {
            ChatComponent chatComponent = this.currentComponent;
            if (chatComponent == null) {
                chatComponent = new ChatComponentText("");
            }
            return chatComponent;
        }

        @NotNull
        public final String getRaw() {
            return this.raw;
        }

        public RawMessage(@NotNull String raw) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            this.raw = raw;
            this.style = new ChatStyle();
            Matcher matcher = PATTERN.matcher(this.raw);
            while (matcher.find()) {
                String match;
                Intrinsics.checkNotNullExpressionValue((Object)matcher.group(1), (String)"matcher.group(1)");
                this.append(matcher.start(1));
                String string = (String)CommonKt.notNull$default((Object)match, null, (int)1, null);
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                String code = String.valueOf(string3.charAt(1));
                Color color = Color.Companion.ofSafely(code);
                this.style = ChatColor.RESET == color ? new ChatStyle() : (ChatColor.BOLD == color ? this.style.setBold(true) : (ChatColor.ITALIC == color ? this.style.setItalic(true) : (ChatColor.UNDERLINE == color ? this.style.setUnderlined(true) : (ChatColor.STRIKETHROUGH == color ? this.style.setStrikethrough(true) : (ChatColor.OBFUSCATED == color ? this.style.setObfuscated(true) : this.style.setColor(color))))));
                this.currentIndex = matcher.end(1);
            }
            if (this.currentIndex < this.raw.length()) {
                this.append(this.raw.length());
            }
        }

        static {
            Companion = new Companion(null);
            PATTERN = Pattern.compile("(\u00a7[0-9a-fk-or])", 2);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/lgou2w/ldk/chat/ChatSerializer$RawMessage$Companion;", "", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ldk-chat"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/lgou2w/ldk/chat/ChatSerializer$ChatStyleSerializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/lgou2w/ldk/chat/ChatStyle;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "ldk-chat"})
    private static final class ChatStyleSerializer
    implements JsonDeserializer<ChatStyle>,
    JsonSerializer<ChatStyle> {
        @Nullable
        public ChatStyle deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            String string;
            String insertion;
            String string2;
            Boolean obfuscated;
            Boolean bl;
            Boolean strikethrough;
            Boolean bl2;
            Boolean underlined;
            Boolean bl3;
            Boolean italic;
            Boolean bl4;
            Boolean bold;
            Boolean bl5;
            Color color;
            Color color2;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"json.asJsonObject");
            JsonObject jsonObject2 = jsonObject;
            ChatStyle style = new ChatStyle();
            if (jsonObject2.has("color")) {
                JsonElement jsonElement = jsonObject2.get("color");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"color\")");
                String string3 = jsonElement.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jsonObject.get(\"color\").asString");
                color2 = Color.Companion.ofSafely(string3);
            } else {
                color2 = color = null;
            }
            if (jsonObject2.has("bold")) {
                JsonElement jsonElement = jsonObject2.get("bold");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"bold\")");
                bl5 = jsonElement.getAsBoolean();
            } else {
                bl5 = bold = null;
            }
            if (jsonObject2.has("italic")) {
                JsonElement jsonElement = jsonObject2.get("italic");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"italic\")");
                bl4 = jsonElement.getAsBoolean();
            } else {
                bl4 = italic = null;
            }
            if (jsonObject2.has("underlined")) {
                JsonElement jsonElement = jsonObject2.get("underlined");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"underlined\")");
                bl3 = jsonElement.getAsBoolean();
            } else {
                bl3 = underlined = null;
            }
            if (jsonObject2.has("strikethrough")) {
                JsonElement jsonElement = jsonObject2.get("strikethrough");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"strikethrough\")");
                bl2 = jsonElement.getAsBoolean();
            } else {
                bl2 = strikethrough = null;
            }
            if (jsonObject2.has("obfuscated")) {
                JsonElement jsonElement = jsonObject2.get("obfuscated");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"obfuscated\")");
                bl = jsonElement.getAsBoolean();
            } else {
                bl = obfuscated = null;
            }
            if (jsonObject2.has("insertion")) {
                JsonElement jsonElement = jsonObject2.get("obfuscated");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"obfuscated\")");
                string2 = jsonElement.getAsString();
            } else {
                string2 = insertion = null;
            }
            if (jsonObject2.has("font")) {
                JsonElement jsonElement = jsonObject2.get("font");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"font\")");
                string = jsonElement.getAsString();
            } else {
                string = null;
            }
            String font = string;
            ChatClickEvent clickEvent = null;
            if (jsonObject2.has("clickEvent")) {
                JsonObject jsonObjectClickEvent;
                JsonElement jsonElement = jsonObject2.get("clickEvent");
                if (!(jsonElement instanceof JsonObject)) {
                    jsonElement = null;
                }
                if ((jsonObjectClickEvent = (JsonObject)jsonElement) != null) {
                    String value;
                    JsonElement jsonElement2 = jsonObjectClickEvent.get("action");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonObjectClickEvent.get(\"action\")");
                    String string4 = jsonElement2.getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"jsonObjectClickEvent.get(\"action\").asString");
                    String string5 = string4;
                    boolean bl6 = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toUpperCase()");
                    ChatClickEvent.Action action = (ChatClickEvent.Action)Enums.ofName$default(ChatClickEvent.Action.class, (String)string7, null, (int)4, null);
                    JsonElement jsonElement3 = jsonObjectClickEvent.get("value");
                    String string8 = value = jsonElement3 != null ? jsonElement3.getAsString() : null;
                    if (action != null && value != null) {
                        clickEvent = new ChatClickEvent(action, value);
                    }
                }
            }
            ChatHoverEvent hoverEvent = null;
            if (jsonObject2.has("hoverEvent")) {
                JsonObject jsonObjectHoverEvent;
                JsonElement jsonElement = jsonObject2.get("hoverEvent");
                if (!(jsonElement instanceof JsonObject)) {
                    jsonElement = null;
                }
                if ((jsonObjectHoverEvent = (JsonObject)jsonElement) != null) {
                    JsonElement value;
                    JsonElement jsonElement4 = jsonObjectHoverEvent.get("action");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"jsonObjectHoverEvent.get(\"action\")");
                    String string9 = jsonElement4.getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"jsonObjectHoverEvent.get(\"action\").asString");
                    String string10 = string9;
                    boolean bl7 = false;
                    String string11 = string10;
                    if (string11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string12 = string11.toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).toUpperCase()");
                    ChatHoverEvent.Action action = (ChatHoverEvent.Action)Enums.ofName$default(ChatHoverEvent.Action.class, (String)string12, null, (int)4, null);
                    JsonElement jsonElement5 = jsonObjectHoverEvent.get("value");
                    if (jsonElement5 == null) {
                        jsonElement5 = value = null;
                    }
                    if (action != null && value != null) {
                        Object object = context.deserialize(value, (Type)((Object)ChatComponent.class));
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.deserialize(valu\u2026hatComponent::class.java)");
                        hoverEvent = new ChatHoverEvent(action, (ChatComponent)object);
                    }
                }
            }
            style.color = color;
            style.bold = bold;
            style.italic = italic;
            style.underlined = underlined;
            style.strikethrough = strikethrough;
            style.obfuscated = obfuscated;
            style.clickEvent = clickEvent;
            style.hoverEvent = hoverEvent;
            style.insertion = insertion;
            style.font = font;
            return style;
        }

        @Nullable
        public JsonElement serialize(@NotNull ChatStyle src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            boolean bl;
            String string;
            Integer rgb;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (src.isEmpty()) {
                return null;
            }
            JsonObject jsonObject = new JsonObject();
            Color color = src.color;
            Integer n = rgb = color != null ? color.getRgb() : null;
            if (rgb != null) {
                String string2 = (String)RGB_FORMATTING_TABLE.get(rgb);
                if (string2 == null) {
                    string2 = INSTANCE.rgbToHex(rgb);
                }
                jsonObject.addProperty("color", string2);
            }
            if (src.bold != null) {
                jsonObject.addProperty("bold", src.bold);
            }
            if (src.italic != null) {
                jsonObject.addProperty("italic", src.italic);
            }
            if (src.underlined != null) {
                jsonObject.addProperty("underlined", src.underlined);
            }
            if (src.strikethrough != null) {
                jsonObject.addProperty("strikethrough", src.strikethrough);
            }
            if (src.obfuscated != null) {
                jsonObject.addProperty("obfuscated", src.obfuscated);
            }
            if (src.insertion != null) {
                jsonObject.add("insertion", context.serialize((Object)src.insertion));
            }
            if (src.clickEvent != null) {
                ChatClickEvent clickEvent = (ChatClickEvent)CommonKt.notNull$default((Object)src.clickEvent, null, (int)1, null);
                JsonObject jsonObjectClickEvent = new JsonObject();
                string = clickEvent.getAction().name();
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                jsonObjectClickEvent.addProperty("action", string4);
                jsonObjectClickEvent.addProperty("value", clickEvent.getValue());
                jsonObject.add("clickEvent", (JsonElement)jsonObjectClickEvent);
            }
            if (src.hoverEvent != null) {
                ChatHoverEvent hoverEvent = (ChatHoverEvent)CommonKt.notNull$default((Object)src.hoverEvent, null, (int)1, null);
                JsonObject jsonObjectHoverEvent = new JsonObject();
                string = hoverEvent.getAction().name();
                bl = false;
                String string5 = string;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                jsonObjectHoverEvent.addProperty("action", string6);
                if (hoverEvent.getValue() instanceof ChatComponentRaw) {
                    jsonObjectHoverEvent.addProperty("value", ((ChatComponentRaw)hoverEvent.getValue()).getRaw());
                } else {
                    jsonObjectHoverEvent.add("value", context.serialize((Object)hoverEvent.getValue()));
                }
                jsonObject.add("hoverEvent", (JsonElement)jsonObjectHoverEvent);
            }
            if (src.font != null) {
                jsonObject.addProperty("font", src.font);
            }
            return (JsonElement)jsonObject;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/lgou2w/ldk/chat/ChatSerializer$ChatComponentSerializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/lgou2w/ldk/chat/ChatComponent;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "ldk-chat"})
    private static final class ChatComponentSerializer
    implements JsonDeserializer<ChatComponent>,
    JsonSerializer<ChatComponent> {
        @Nullable
        public ChatComponent deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (json.isJsonPrimitive()) {
                String string = json.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.asString");
                return new ChatComponentText(string);
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray;
                ChatComponent component = null;
                JsonArray jsonArray2 = jsonArray = json.getAsJsonArray();
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray2, (String)"jsonArray");
                Iterable $this$forEach$iv = (Iterable)jsonArray2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JsonElement it = (JsonElement)element$iv;
                    boolean bl = false;
                    JsonElement jsonElement = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"it");
                    ChatComponent component1 = this.deserialize(jsonElement, it.getClass(), context);
                    if (component == null) {
                        component = component1;
                        continue;
                    }
                    if (component1 == null) continue;
                    ((ChatComponent)CommonKt.notNull$default((Object)component, null, (int)1, null)).append(component1);
                }
                return component;
            }
            ChatComponent component = null;
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("text")) {
                JsonElement jsonElement = jsonObject.get("text");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"text\")");
                String string = jsonElement.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.get(\"text\").asString");
                component = new ChatComponentText(string);
            } else if (jsonObject.has("translate")) {
                JsonElement jsonElement = jsonObject.get("translate");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"translate\")");
                String translate = jsonElement.getAsString();
                if (jsonObject.has("with")) {
                    JsonArray jsonArray = jsonObject.getAsJsonArray("with");
                    Object[] withs = new Object[jsonArray.size()];
                    Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((Object[])withs);
                    boolean $i$f$forEach = false;
                    Iterator bl = $this$forEach$iv.iterator();
                    while (bl.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)bl).nextInt();
                        boolean bl2 = false;
                        JsonElement jsonElement2 = jsonArray.get(it);
                        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"jsonArray[it]");
                        withs[it] = this.deserialize(jsonElement2, typeOfT, context);
                        if (!(withs[it] instanceof ChatComponentText)) continue;
                        Object object = withs[it];
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.lgou2w.ldk.chat.ChatComponentText");
                        }
                        ChatComponentText componentText = (ChatComponentText)object;
                        if (!componentText.getStyle().isEmpty() || !((ArrayList)componentText.getExtras()).isEmpty()) continue;
                        withs[it] = componentText.getText();
                    }
                    String string = translate;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translate");
                    Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])withs);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                    if (objectArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    component = new ChatComponentTranslation(string, null, 2, null).addWiths(objectArray);
                } else {
                    String string = translate;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translate");
                    component = new ChatComponentTranslation(string, null, 2, null);
                }
            } else if (jsonObject.has("score")) {
                JsonObject jsonObjectScore = jsonObject.getAsJsonObject("score");
                if (!jsonObjectScore.has("name") || !jsonObjectScore.has("objective")) {
                    throw (Throwable)new JsonParseException("A score component needs a least a name and an objective.");
                }
                JsonElement jsonElement = jsonObjectScore.get("name");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObjectScore.get(\"name\")");
                String string = jsonElement.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObjectScore.get(\"name\").asString");
                JsonElement jsonElement3 = jsonObjectScore.get("objective");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"jsonObjectScore.get(\"objective\")");
                String string2 = jsonElement3.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObjectScore.get(\"objective\").asString");
                component = new ChatComponentScore(string, string2, null, 4, null);
                if (jsonObjectScore.has("value")) {
                    ChatComponentScore chatComponentScore = (ChatComponentScore)component;
                    JsonElement jsonElement4 = jsonObjectScore.get("value");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"jsonObjectScore.get(\"value\")");
                    chatComponentScore.setValue(jsonElement4.getAsString());
                }
            } else if (jsonObject.has("selector")) {
                JsonElement jsonElement = jsonObject.get("selector");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"selector\")");
                String string = jsonElement.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.get(\"selector\").asString");
                component = new ChatComponentSelector(string);
            } else if (jsonObject.has("keybind")) {
                JsonElement jsonElement = jsonObject.get("keybind");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"keybind\")");
                String string = jsonElement.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.get(\"keybind\").asString");
                component = new ChatComponentKeybind(string);
            } else if (jsonObject.has("nbt")) {
                ChatComponent chatComponent;
                Boolean bl;
                JsonElement jsonElement = jsonObject.get("nbt");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonObject.get(\"nbt\")");
                String nbt = jsonElement.getAsString();
                if (jsonObject.has("interpret")) {
                    JsonElement jsonElement5 = jsonObject.get("interpret");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement5, (String)"jsonObject.get(\"interpret\")");
                    bl = jsonElement5.getAsBoolean();
                } else {
                    bl = null;
                }
                Boolean interpret = bl;
                if (jsonObject.has("block")) {
                    String string = nbt;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nbt");
                    JsonElement jsonElement6 = jsonObject.get("block");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement6, (String)"jsonObject.get(\"block\")");
                    chatComponent = new ChatComponentNBTBlock(string, interpret, jsonElement6.getAsString());
                } else if (jsonObject.has("entity")) {
                    String string = nbt;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nbt");
                    JsonElement jsonElement7 = jsonObject.get("entity");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement7, (String)"jsonObject.get(\"entity\")");
                    chatComponent = new ChatComponentNBTEntity(string, interpret, jsonElement7.getAsString());
                } else if (jsonObject.has("storage")) {
                    String string = nbt;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nbt");
                    JsonElement jsonElement8 = jsonObject.get("storage");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement8, (String)"jsonObject.get(\"storage\")");
                    chatComponent = new ChatComponentNBTStorage(string, interpret, jsonElement8.getAsString());
                } else {
                    throw (Throwable)new JsonParseException("Don't know how to turn " + json + " into a Component");
                }
                component = chatComponent;
            } else {
                throw (Throwable)new JsonParseException("Don't know how to parse " + json + " into a chat component.");
            }
            if (jsonObject.has("extra")) {
                JsonArray jsonArray = jsonObject.getAsJsonArray("extra");
                if (jsonArray.size() <= 0) {
                    throw (Throwable)new JsonParseException("Invalid empty array component.");
                }
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)jsonArray.size());
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    JsonElement jsonElement = jsonArray.get(it);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"jsonArray[it]");
                    ChatComponent component1 = this.deserialize(jsonElement, typeOfT, context);
                    if (component1 == null) continue;
                    component.append(component1);
                }
            }
            component.setStyle((ChatStyle)context.deserialize(json, (Type)((Object)ChatStyle.class)));
            return component;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public JsonElement serialize(@NotNull ChatComponent src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
            Object jsonArray;
            Object it;
            boolean $i$f$forEach;
            Collection jsonObjectStyle;
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject jsonObject = new JsonObject();
            if (!src.getStyle().isEmpty()) {
                JsonElement jsonElement = context.serialize((Object)src.getStyle());
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"context.serialize(src.style)");
                jsonObjectStyle = jsonElement.getAsJsonObject();
                Set set = jsonObjectStyle.entrySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"jsonObjectStyle.entrySet()");
                Iterable $this$forEach$iv = set;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Map.Entry)element$iv;
                    boolean bl = false;
                    jsonObject.add((String)it.getKey(), (JsonElement)it.getValue());
                }
            }
            jsonObjectStyle = src.getExtras();
            boolean $this$forEach$iv = false;
            if (!jsonObjectStyle.isEmpty()) {
                jsonArray = new JsonArray();
                Iterable $this$forEach$iv2 = src.getExtras();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (ChatComponent)element$iv;
                    boolean bl = false;
                    jsonArray.add(this.serialize((ChatComponent)it, (Type)it.getClass(), context));
                }
                jsonObject.add("extra", (JsonElement)jsonArray);
            }
            if (src instanceof ChatComponentText) {
                jsonObject.addProperty("text", ((ChatComponentText)src).getText());
                return (JsonElement)jsonObject;
            } else if (src instanceof ChatComponentTranslation) {
                jsonObject.addProperty("translate", ((ChatComponentTranslation)src).getKey());
                jsonArray = ((ChatComponentTranslation)src).getWiths();
                boolean $this$forEach$iv2 = false;
                if (!(!jsonArray.isEmpty())) return (JsonElement)jsonObject;
                jsonArray = new JsonArray();
                Iterable $this$forEach$iv22 = ((ChatComponentTranslation)src).getWiths();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv22) {
                    it = element$iv;
                    boolean bl = false;
                    if (it instanceof ChatComponent) {
                        jsonArray.add(this.serialize((ChatComponent)it, (Type)it.getClass(), context));
                        continue;
                    }
                    jsonArray.add((JsonElement)new JsonPrimitive(it.toString()));
                }
                jsonObject.add("with", (JsonElement)jsonArray);
                return (JsonElement)jsonObject;
            } else if (src instanceof ChatComponentScore) {
                JsonObject jsonObjectScore = new JsonObject();
                jsonObjectScore.addProperty("name", ((ChatComponentScore)src).getName());
                jsonObjectScore.addProperty("objective", ((ChatComponentScore)src).getObjective());
                if (((ChatComponentScore)src).getValue() != null) {
                    jsonObjectScore.addProperty("value", ((ChatComponentScore)src).getValue());
                }
                jsonObject.add("score", (JsonElement)jsonObjectScore);
                return (JsonElement)jsonObject;
            } else if (src instanceof ChatComponentSelector) {
                jsonObject.addProperty("selector", ((ChatComponentSelector)src).getSelector());
                return (JsonElement)jsonObject;
            } else if (src instanceof ChatComponentKeybind) {
                jsonObject.addProperty("keybind", ((ChatComponentKeybind)src).getKeybind());
                return (JsonElement)jsonObject;
            } else {
                ChatComponent chatComponent;
                if (!(src instanceof ChatComponentNBT)) throw (Throwable)new JsonParseException("Don't know how to serialize " + src + " as a Component");
                jsonObject.addProperty("nbt", ((ChatComponentNBT)src).getNBT());
                if (((ChatComponentNBT)src).getInterpret() != null) {
                    jsonObject.addProperty("interpret", ((ChatComponentNBT)src).getInterpret());
                }
                if ((chatComponent = src) instanceof ChatComponentNBTBlock) {
                    jsonObject.addProperty("block", ((ChatComponentNBT)src).getPath());
                    return (JsonElement)jsonObject;
                } else if (chatComponent instanceof ChatComponentNBTEntity) {
                    jsonObject.addProperty("entity", ((ChatComponentNBT)src).getPath());
                    return (JsonElement)jsonObject;
                } else {
                    if (!(chatComponent instanceof ChatComponentNBTStorage)) throw (Throwable)new JsonParseException("Don't know how to serialize " + src + " as a Component");
                    jsonObject.addProperty("storage", ((ChatComponentNBT)src).getPath());
                }
            }
            return (JsonElement)jsonObject;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/lgou2w/ldk/chat/ChatSerializer$ChatComponentRaw;", "Lcom/lgou2w/ldk/chat/ChatComponentAbstract;", "raw", "", "(Ljava/lang/String;)V", "getRaw", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "ldk-chat"})
    public static final class ChatComponentRaw
    extends ChatComponentAbstract {
        @NotNull
        private final String raw;

        @NotNull
        public final String getRaw() {
            return this.raw;
        }

        public ChatComponentRaw(@NotNull String raw) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            this.raw = raw;
        }

        @NotNull
        public final String component1() {
            return this.raw;
        }

        @NotNull
        public final ChatComponentRaw copy(@NotNull String raw) {
            Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
            return new ChatComponentRaw(raw);
        }

        public static /* synthetic */ ChatComponentRaw copy$default(ChatComponentRaw chatComponentRaw, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = chatComponentRaw.raw;
            }
            return chatComponentRaw.copy(string);
        }

        @Override
        @NotNull
        public String toString() {
            return "ChatComponentRaw(raw=" + this.raw + ")";
        }

        @Override
        public int hashCode() {
            String string = this.raw;
            return string != null ? string.hashCode() : 0;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ChatComponentRaw)) break block3;
                    ChatComponentRaw chatComponentRaw = (ChatComponentRaw)object;
                    if (!Intrinsics.areEqual((Object)this.raw, (Object)chatComponentRaw.raw)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

