/*
 * Decompiled with CFR 0.152.
 */
package com.lgou2w.ldk.chat;

import com.lgou2w.ldk.chat.ChatColor;
import com.lgou2w.ldk.chat.ChatHexColor;
import com.lgou2w.ldk.common.Enums;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/lgou2w/ldk/chat/Color;", "", "rgb", "", "getRgb", "()Ljava/lang/Integer;", "Companion", "ldk-chat"})
public interface Color {
    public static final Companion Companion = com.lgou2w.ldk.chat.Color$Companion.$$INSTANCE;

    @Nullable
    public Integer getRgb();

    @JvmStatic
    @NotNull
    public static Color of(int rgb) {
        return Companion.of(rgb);
    }

    @JvmStatic
    @NotNull
    public static Color of(@NotNull String codeOrHexRgb) throws IllegalArgumentException {
        return Companion.of(codeOrHexRgb);
    }

    @JvmStatic
    @Nullable
    public static Color ofSafely(@NotNull String codeOrHexRgb) {
        return Companion.ofSafely(codeOrHexRgb);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0007H\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0007H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/lgou2w/ldk/chat/Color$Companion;", "", "()V", "HEX_RGB", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "hexCompletion", "", "hex", "of", "Lcom/lgou2w/ldk/chat/Color;", "rgb", "", "codeOrHexRgb", "ofSafely", "ldk-chat"})
    public static final class Companion {
        private static final Pattern HEX_RGB;
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        @NotNull
        public final Color of(int rgb) {
            return new ChatHexColor(rgb);
        }

        @JvmStatic
        @NotNull
        public final Color of(@NotNull String codeOrHexRgb) throws IllegalArgumentException {
            ChatColor formatting;
            Intrinsics.checkNotNullParameter((Object)codeOrHexRgb, (String)"codeOrHexRgb");
            if (StringsKt.isBlank((CharSequence)codeOrHexRgb)) {
                throw (Throwable)new IllegalArgumentException("Invalid rgb, is blank.");
            }
            String string = codeOrHexRgb;
            boolean bl = false;
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
            ChatColor chatColor = (ChatColor)Enums.ofName$default(ChatColor.class, (String)string2, null, (int)4, null);
            if (chatColor == null) {
                string = codeOrHexRgb;
                bl = false;
                String string3 = string.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                chatColor = formatting = (ChatColor)Enums.ofValuable$default(ChatColor.class, (Object)Character.valueOf(StringsKt.first((CharSequence)string3)), null, (int)4, null);
            }
            if (formatting != null) {
                return formatting;
            }
            if (!HEX_RGB.matcher(codeOrHexRgb).matches()) {
                throw (Throwable)new IllegalArgumentException("Invalid rgb hex: " + codeOrHexRgb);
            }
            String string4 = this.hexCompletion(codeOrHexRgb);
            int n = 16;
            boolean bl2 = false;
            int rgb = Integer.parseInt(string4, CharsKt.checkRadix((int)n));
            return new ChatHexColor(rgb);
        }

        @JvmStatic
        @Nullable
        public final Color ofSafely(@NotNull String codeOrHexRgb) {
            Color color;
            Intrinsics.checkNotNullParameter((Object)codeOrHexRgb, (String)"codeOrHexRgb");
            try {
                color = this.of(codeOrHexRgb);
            }
            catch (IllegalArgumentException e) {
                color = null;
            }
            return color;
        }

        private final String hexCompletion(String hex) {
            CharSequence charSequence = hex;
            Regex regex = new Regex("^#");
            String string = "";
            boolean bl = false;
            String r = regex.replace(charSequence, string);
            if (r.length() == 3) {
                r = String.valueOf(r.charAt(0)) + r.charAt(0) + r.charAt(1) + r.charAt(1) + r.charAt(2) + r.charAt(2);
            }
            return r;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            HEX_RGB = Pattern.compile("^#([0-9a-fA-f]{3}|[0-9a-fA-f]{6})$");
        }
    }
}

