/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.librato.metrics.Measurement;
import com.librato.metrics.Preconditions;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSampleGaugeMeasurement
implements Measurement {
    private final String name;
    private final Long count;
    private final Number sum;
    private final Number max;
    private final Number min;
    private final Number sumSquares;

    public MultiSampleGaugeMeasurement(String name, Long count, Number sum, Number max, Number min, Number sumSquares) {
        try {
            if (count == null || count == 0L) {
                throw new IllegalArgumentException("The Librato API requires the count to be > 0 for complex metrics. See http://dev.librato.com/v1/post/metrics");
            }
            this.name = Preconditions.checkNotNull(name);
            this.count = count;
            this.sum = Preconditions.checkNumeric(sum);
            this.max = Preconditions.checkNumeric(max);
            this.min = Preconditions.checkNumeric(min);
            this.sumSquares = Preconditions.checkNumeric(sumSquares);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid multi-sample gauge measurement name=" + name, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Number> toMap() {
        HashMap<String, Number> result = new HashMap<String, Number>(5);
        result.put("count", this.count);
        result.put("sum", this.sum);
        if (this.max != null) {
            result.put("max", this.max);
        }
        if (this.min != null) {
            result.put("min", this.min);
        }
        if (this.sumSquares != null) {
            result.put("sum_squares", this.sumSquares);
        }
        return result;
    }
}

