/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.librato.metrics.Authorization;
import com.librato.metrics.HttpPoster;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NingHttpPoster
implements HttpPoster {
    private final AsyncHttpClient httpClient = new AsyncHttpClient();
    private final String authHeader;
    private final String apiUrl;

    public NingHttpPoster(String authHeader, String apiUrl) {
        this.authHeader = authHeader;
        this.apiUrl = apiUrl;
    }

    public static NingHttpPoster newPoster(String username, String token, String apiUrl) {
        return new NingHttpPoster(Authorization.buildAuthHeader(username, token), apiUrl);
    }

    @Override
    public Future<HttpPoster.Response> post(String userAgent, String payload) throws IOException {
        AsyncHttpClient.BoundRequestBuilder builder = this.httpClient.preparePost(this.apiUrl);
        builder.addHeader("Content-Type", "application/json");
        builder.addHeader("Authorization", this.authHeader);
        builder.addHeader("User-Agent", userAgent);
        builder.setBody(payload);
        return new FutureAdapter((Future<Response>)builder.execute());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FutureAdapter
    implements Future<HttpPoster.Response> {
        private final Future<Response> delegate;

        FutureAdapter(Future<Response> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public HttpPoster.Response get() throws InterruptedException, ExecutionException {
            return this.adapt(this.delegate.get());
        }

        @Override
        public HttpPoster.Response get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.adapt(this.delegate.get(timeout, unit));
        }

        private HttpPoster.Response adapt(final Response response) {
            return new HttpPoster.Response(){

                public int getStatusCode() {
                    return response.getStatusCode();
                }

                public String getBody() throws IOException {
                    return response.getResponseBody();
                }
            };
        }
    }
}

