/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.librato.metrics.Measurement;
import com.librato.metrics.Preconditions;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleValueGaugeMeasurement
implements Measurement {
    private final String name;
    private final Number reading;

    public SingleValueGaugeMeasurement(String name, Number reading) {
        try {
            this.name = Preconditions.checkNotNull(name);
            this.reading = Preconditions.checkNumeric(Preconditions.checkNumeric(reading));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid single-gauge measurement name=" + name, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Number> toMap() {
        HashMap<String, Number> value = new HashMap<String, Number>();
        value.put("value", this.reading);
        return value;
    }
}

