/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.librato.metrics.CounterMeasurementBuilder;
import com.librato.metrics.Measurement;
import com.librato.metrics.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterMeasurement
implements Measurement {
    private static final Map<String, Object> emptyAttributes = Collections.emptyMap();
    private final Number period;
    private final String source;
    private final String name;
    private final Long count;
    private final Map<String, Object> metricAttributes;
    private final Long measureTime;

    public static CounterMeasurementBuilder builder(String name, Long count) {
        return new CounterMeasurementBuilder(name, count);
    }

    public CounterMeasurement(String name, Long count) {
        this(null, null, name, count);
    }

    public CounterMeasurement(String source, String name, Long count) {
        this(source, null, name, count);
    }

    public CounterMeasurement(String source, Number period, String name, Long count) {
        this(source, period, name, count, emptyAttributes, null);
    }

    public CounterMeasurement(String source, Number period, String name, Long count, Map<String, Object> metricAttributes, Long measureTime) {
        this.source = source;
        this.period = period;
        this.name = Preconditions.checkNotNull(name);
        this.count = Preconditions.checkNotNull(count);
        this.metricAttributes = metricAttributes;
        this.measureTime = measureTime;
    }

    @Override
    public Long getMeasureTime() {
        return this.measureTime;
    }

    @Override
    public Map<String, Object> getMetricAttributes() {
        return this.metricAttributes;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Number getPeriod() {
        return this.period;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Number> toMap() {
        HashMap<String, Number> value = new HashMap<String, Number>(1);
        value.put("value", this.count);
        return value;
    }
}

