/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.librato.metrics.BatchResult;
import com.librato.metrics.CounterMeasurement;
import com.librato.metrics.HttpPoster;
import com.librato.metrics.Measurement;
import com.librato.metrics.PostResult;
import com.librato.metrics.Preconditions;
import com.librato.metrics.Sanitizer;
import com.librato.metrics.SingleValueGaugeMeasurement;
import com.librato.metrics.Versions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibratoBatch {
    public static final int DEFAULT_BATCH_SIZE = 500;
    private static final String LIB_VERSION = Versions.getVersion("META-INF/maven/com.librato.metrics/librato-java/pom.properties", LibratoBatch.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final List<Measurement> measurements = new ArrayList<Measurement>();
    private final int postBatchSize;
    private final Sanitizer sanitizer;
    private final long timeout;
    private final TimeUnit timeoutUnit;
    private final String userAgent;
    private final HttpPoster httpPoster;

    public LibratoBatch(int postBatchSize, final Sanitizer sanitizer, long timeout, TimeUnit timeoutUnit, String agentIdentifier, HttpPoster httpPoster) {
        this.postBatchSize = postBatchSize;
        this.sanitizer = new Sanitizer(){

            public String apply(String name) {
                return Sanitizer.LAST_PASS.apply(sanitizer.apply(name));
            }
        };
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        this.userAgent = String.format("%s librato-java/%s", agentIdentifier, LIB_VERSION);
        this.httpPoster = Preconditions.checkNotNull(httpPoster);
    }

    public void addMeasurement(Measurement measurement) {
        this.measurements.add(measurement);
    }

    public void addCounterMeasurement(String name, Long value) {
        this.addMeasurement(CounterMeasurement.builder(name, value).build());
    }

    public void addCounterMeasurement(String source, String name, Long value) {
        this.addMeasurement(CounterMeasurement.builder(name, value).setSource(source).build());
    }

    public void addCounterMeasurement(String source, Number period, String name, Long value) {
        this.addMeasurement(CounterMeasurement.builder(name, value).setSource(source).setPeriod(period).build());
    }

    public void addGaugeMeasurement(String name, Number value) {
        this.addMeasurement(SingleValueGaugeMeasurement.builder(name, value).build());
    }

    public void addGaugeMeasurement(String source, String name, Number value) {
        this.addMeasurement(SingleValueGaugeMeasurement.builder(name, value).setSource(source).build());
    }

    public void addGaugeMeasurement(String source, Number period, String name, Number value) {
        this.addMeasurement(SingleValueGaugeMeasurement.builder(name, value).setSource(source).setPeriod(period).build());
    }

    public BatchResult post(String source) {
        return this.post(source, null);
    }

    public BatchResult post(String source, Long epoch) {
        BatchResult result = new BatchResult();
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("source", source);
        if (epoch != null) {
            payloadMap.put("measure_time", epoch);
        }
        ArrayList gaugeData = new ArrayList();
        ArrayList counterData = new ArrayList();
        int counter = 0;
        Iterator<Measurement> measurementIterator = this.measurements.iterator();
        while (measurementIterator.hasNext()) {
            Measurement measurement = measurementIterator.next();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", this.sanitizer.apply(measurement.getName()));
            if (measurement.getSource() != null) {
                data.put("source", this.sanitizer.apply(measurement.getSource()));
            }
            if (measurement.getPeriod() != null) {
                data.put("period", measurement.getPeriod());
            }
            if (!measurement.getMetricAttributes().isEmpty()) {
                data.put("attributes", measurement.getMetricAttributes());
            }
            if (measurement.getMeasureTime() != null) {
                data.put("measure_time", measurement.getMeasureTime());
            }
            data.putAll(measurement.toMap());
            if (measurement instanceof CounterMeasurement) {
                counterData.add(data);
            } else {
                gaugeData.add(data);
            }
            if (++counter % this.postBatchSize != 0 && (measurementIterator.hasNext() || counterData.isEmpty() && gaugeData.isEmpty())) continue;
            String countersKey = "counters";
            String gaugesKey = "gauges";
            payloadMap.put("counters", new ArrayList(counterData));
            payloadMap.put("gauges", new ArrayList(gaugeData));
            result.addPostResult(this.postPortion(payloadMap));
            payloadMap.remove("gauges");
            payloadMap.remove("counters");
            gaugeData.clear();
            counterData.clear();
        }
        return result;
    }

    private PostResult postPortion(Map<String, Object> chunk) {
        try {
            String payload = OBJECT_MAPPER.writeValueAsString(chunk);
            Future<HttpPoster.Response> future = this.httpPoster.post(this.userAgent, payload);
            HttpPoster.Response response = future.get(this.timeout, this.timeoutUnit);
            int statusCode = response.getStatusCode();
            String responseBody = response.getBody();
            return new PostResult(chunk, statusCode, responseBody);
        }
        catch (Exception e) {
            return new PostResult(chunk, e);
        }
    }
}

