/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.librato.metrics.Measurement;
import com.librato.metrics.Preconditions;
import com.librato.metrics.SingleValueGaugeMeasurementBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleValueGaugeMeasurement
implements Measurement {
    private static final Map<String, Object> emptyAttributes = Collections.emptyMap();
    private final Number period;
    private final String source;
    private final String name;
    private final Number reading;
    private final Map<String, Object> metricAttributes;
    private Long measureTime;

    public static SingleValueGaugeMeasurementBuilder builder(String name, Number reading) {
        return new SingleValueGaugeMeasurementBuilder(name, reading);
    }

    public SingleValueGaugeMeasurement(String name, Number reading) {
        this(null, null, name, reading);
    }

    public SingleValueGaugeMeasurement(String source, String name, Number reading) {
        this(source, null, name, reading);
    }

    public SingleValueGaugeMeasurement(String source, Number period, String name, Number reading) {
        this(source, period, name, reading, emptyAttributes, null);
    }

    public SingleValueGaugeMeasurement(String source, Number period, String name, Number reading, Map<String, Object> metricAttributes, Long measureTime) {
        try {
            this.source = source;
            this.period = period;
            this.name = Preconditions.checkNotNull(name);
            this.reading = Preconditions.checkNumeric(Preconditions.checkNumeric(reading));
            this.metricAttributes = metricAttributes;
            this.measureTime = measureTime;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid single-gauge measurement name=" + name, e);
        }
    }

    @Override
    public Long getMeasureTime() {
        return this.measureTime;
    }

    @Override
    public Map<String, Object> getMetricAttributes() {
        return this.metricAttributes;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Number getPeriod() {
        return this.period;
    }

    @Override
    public Map<String, Number> toMap() {
        HashMap<String, Number> value = new HashMap<String, Number>(1);
        value.put("value", this.reading);
        return value;
    }
}

