package com.librato.metrics;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;

/**
 * Posts data to an HTTP endpoint.
 */
public interface HttpPoster extends Closeable {
    /**
     * A generic interface to represent an HTTP response
     */
    public static interface Response {
        int getStatusCode();
        String getBody() throws IOException;
    }

    /**
     * POST the payload as JSON to librato.
     *
     * @param userAgent the user agent to use
     * @param payload the payload to post
     * @return a Future that returns the response
     * @throws IOException on IO-related error
     */
    Future<Response> post(String userAgent, String payload) throws IOException;
}
