/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.reporter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.librato.metrics.client.Duration;
import com.librato.metrics.client.GaugeMeasure;
import com.librato.metrics.client.LibratoClient;
import com.librato.metrics.client.Measures;
import com.librato.metrics.client.PostMeasuresResult;
import com.librato.metrics.client.PostResult;
import com.librato.metrics.client.Tag;
import com.librato.metrics.client.TaggedMeasure;
import com.librato.metrics.reporter.DeltaMetricSupplier;
import com.librato.metrics.reporter.DeltaTracker;
import com.librato.metrics.reporter.DurationConverter;
import com.librato.metrics.reporter.ExpandedMetric;
import com.librato.metrics.reporter.Librato;
import com.librato.metrics.reporter.MetricExpansionConfig;
import com.librato.metrics.reporter.Numbers;
import com.librato.metrics.reporter.RateConverter;
import com.librato.metrics.reporter.ReporterAttributes;
import com.librato.metrics.reporter.ReporterBuilder;
import com.librato.metrics.reporter.Signal;
import com.librato.metrics.reporter.SourceInformation;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibratoReporter
extends ScheduledReporter
implements RateConverter,
DurationConverter {
    private static final Logger log = LoggerFactory.getLogger(LibratoReporter.class);
    private static MetricRegistry registry;
    private final LibratoClient client;
    private final DeltaTracker deltaTracker;
    private final Pattern sourceRegex;
    private final String prefix;
    private final String prefixDelimiter;
    private final MetricExpansionConfig expansionConfig;
    private final boolean deleteIdleStats;
    private final boolean omitComplexGauges;
    private final String source;
    private final List<Tag> tags;
    private final boolean enableLegacy;
    private final boolean enableTagging;
    private final RateConverter rateConverter;
    private final DurationConverter durationConverter;
    private volatile Integer defaultPeriod;

    public static ReporterBuilder builder(MetricRegistry registry, String email, String token) {
        return new ReporterBuilder(registry, email, token);
    }

    LibratoReporter(ReporterAttributes atts) {
        super(atts.registry, atts.reporterName, atts.metricFilter, atts.rateUnit, atts.durationUnit);
        Librato.defaultRegistry.set(atts.registry);
        this.client = atts.libratoClientFactory.build(atts);
        this.deltaTracker = new DeltaTracker(new DeltaMetricSupplier(atts.registry));
        this.sourceRegex = atts.sourceRegex;
        this.prefix = this.checkPrefix(atts.prefix);
        this.prefixDelimiter = atts.prefixDelimiter;
        this.expansionConfig = atts.expansionConfig;
        this.deleteIdleStats = atts.deleteIdleStats;
        this.omitComplexGauges = atts.omitComplexGauges;
        this.source = atts.source;
        this.tags = atts.tags;
        this.enableLegacy = atts.enableLegacy;
        this.enableTagging = atts.enableTagging;
        this.rateConverter = atts.rateConverter != null ? atts.rateConverter : this;
        this.durationConverter = atts.durationConverter != null ? atts.durationConverter : this;
    }

    public void start(long period, TimeUnit unit) {
        Librato.defaultWindow.set(new Duration(period, unit));
        this.defaultPeriod = (int)unit.toSeconds(period);
        super.start(period, unit);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long epoch = System.currentTimeMillis() / 1000L;
        Measures measures = new Measures(this.source, Collections.emptyList(), Long.valueOf(epoch), this.defaultPeriod);
        this.addGauges(measures, gauges);
        this.addCounters(measures, counters);
        this.addHistograms(measures, histograms);
        this.addMeters(measures, meters);
        this.addTimers(measures, timers);
        try {
            PostMeasuresResult postResults = this.client.postMeasures(measures);
            for (PostResult result : postResults.results) {
                if (!result.isError()) continue;
                this.handlePostFailure(result);
            }
        }
        catch (Exception e) {
            log.error("Failure to post to Librato", (Throwable)e);
        }
    }

    private void handlePostFailure(PostResult result) {
        Exception exception = result.exception;
        if (exception != null) {
            this.handlePostFailure(exception);
            return;
        }
        log.error("Failure to post to Librato: " + result.toString());
    }

    private void handlePostFailure(Exception e) {
        Throwable cause = this.getCause(e);
        if (cause instanceof SocketTimeoutException) {
            log.warn("Could not connect to Librato", cause);
            return;
        }
        log.warn("Failure to post to Librato", (Throwable)e);
    }

    private Throwable getCause(Exception e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private void addGauges(Measures measures, SortedMap<String, Gauge> gauges) {
        for (String metricName : gauges.keySet()) {
            Gauge gauge = (Gauge)gauges.get(metricName);
            Number number = Numbers.getNumberFrom(gauge.getValue());
            if (number == null) continue;
            this.addLibratoGauge(measures, this.convertToSignal(metricName), number.doubleValue());
        }
    }

    private void addCounters(Measures measures, SortedMap<String, Counter> counters) {
        for (String metricName : counters.keySet()) {
            Counter counter = (Counter)counters.get(metricName);
            long count = counter.getCount();
            this.addLibratoGauge(measures, this.convertToSignal(metricName), count);
        }
    }

    private void addHistograms(Measures measures, SortedMap<String, Histogram> histograms) {
        for (String metricName : histograms.keySet()) {
            Histogram histogram;
            if (this.skipMetric(metricName, (Counting)(histogram = (Histogram)histograms.get(metricName)))) continue;
            Long countDelta = this.deltaTracker.getDelta(metricName, histogram.getCount());
            this.maybeAdd(measures, ExpandedMetric.COUNT, metricName, countDelta);
            boolean convertDurations = false;
            this.addSampling(measures, metricName, (Sampling)histogram, false);
        }
    }

    private void addMeters(Measures measures, SortedMap<String, Meter> meters) {
        for (String metricName : meters.keySet()) {
            Meter meter;
            if (this.skipMetric(metricName, (Counting)(meter = (Meter)meters.get(metricName)))) continue;
            this.addMeter(measures, metricName, (Metered)meter);
        }
    }

    private void addMeter(Measures measures, String metricName, Metered meter) {
        Long countDelta = this.deltaTracker.getDelta(metricName, meter.getCount());
        this.maybeAdd(measures, ExpandedMetric.COUNT, metricName, countDelta);
        this.maybeAdd(measures, ExpandedMetric.RATE_MEAN, metricName, this.doConvertRate(meter.getMeanRate()));
        this.maybeAdd(measures, ExpandedMetric.RATE_1_MINUTE, metricName, this.doConvertRate(meter.getOneMinuteRate()));
        this.maybeAdd(measures, ExpandedMetric.RATE_5_MINUTE, metricName, this.doConvertRate(meter.getFiveMinuteRate()));
        this.maybeAdd(measures, ExpandedMetric.RATE_15_MINUTE, metricName, this.doConvertRate(meter.getFifteenMinuteRate()));
    }

    private void addTimers(Measures measures, SortedMap<String, Timer> timers) {
        for (String metricName : timers.keySet()) {
            Timer timer;
            if (this.skipMetric(metricName, (Counting)(timer = (Timer)timers.get(metricName)))) continue;
            this.addMeter(measures, metricName, (Metered)timer);
            boolean convertDurations = true;
            this.addSampling(measures, metricName, (Sampling)timer, true);
        }
    }

    private void addSampling(Measures measures, String name, Sampling sampling, boolean convert) {
        Snapshot snapshot = sampling.getSnapshot();
        this.maybeAdd(measures, ExpandedMetric.MEDIAN, name, this.doConvertDuration(snapshot.getMedian(), convert));
        this.maybeAdd(measures, ExpandedMetric.PCT_75, name, this.doConvertDuration(snapshot.get75thPercentile(), convert));
        this.maybeAdd(measures, ExpandedMetric.PCT_95, name, this.doConvertDuration(snapshot.get95thPercentile(), convert));
        this.maybeAdd(measures, ExpandedMetric.PCT_98, name, this.doConvertDuration(snapshot.get98thPercentile(), convert));
        this.maybeAdd(measures, ExpandedMetric.PCT_99, name, this.doConvertDuration(snapshot.get99thPercentile(), convert));
        this.maybeAdd(measures, ExpandedMetric.PCT_999, name, this.doConvertDuration(snapshot.get999thPercentile(), convert));
        if (!this.omitComplexGauges) {
            double sum = (double)snapshot.size() * snapshot.getMean();
            long count = snapshot.size();
            if (count > 0L) {
                try {
                    this.addLibratoGauge(measures, this.convertToSignal(name), this.doConvertDuration(sum, convert), count, this.doConvertDuration(snapshot.getMin(), convert), this.doConvertDuration(snapshot.getMax(), convert));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Could not create gauge", (Throwable)e);
                }
            }
        }
    }

    private void addLibratoGauge(Measures measures, Signal signal, double sum, long count, double min, double max) {
        GaugeMeasure gauge = new GaugeMeasure(signal.name, sum, count, min, max);
        this.addLibratoGauge(measures, signal, gauge);
    }

    private void addLibratoGauge(Measures measures, Signal signal, double value) {
        GaugeMeasure gauge = new GaugeMeasure(signal.name, value);
        this.addLibratoGauge(measures, signal, gauge);
    }

    private void addLibratoGauge(Measures measures, Signal signal, GaugeMeasure gauge) {
        if (this.enableLegacy) {
            gauge.setSource(signal.source);
            measures.add(gauge);
        }
        if (this.enableTagging) {
            TaggedMeasure taggedMeasure = new TaggedMeasure(gauge);
            for (Tag tag : signal.tags) {
                taggedMeasure.addTag(tag);
            }
            boolean addedSourceTag = false;
            if (!signal.overrideTags && signal.tags.isEmpty() && signal.source != null) {
                taggedMeasure.addTag(new Tag("source", signal.source));
                addedSourceTag = true;
            }
            if (!signal.overrideTags) {
                for (Tag tag : this.tags) {
                    if (addedSourceTag && "source".equals(tag.name)) continue;
                    taggedMeasure.addTag(tag);
                }
            }
            measures.add(taggedMeasure);
        }
    }

    private String addPrefix(String metricName) {
        if (this.prefix == null || this.prefix.length() == 0) {
            return metricName;
        }
        return this.prefix + this.prefixDelimiter + metricName;
    }

    private String checkPrefix(String prefix) {
        if ("".equals(prefix)) {
            throw new IllegalArgumentException("Prefix may either be null or a non-empty string");
        }
        return prefix;
    }

    private void maybeAdd(Measures measures, ExpandedMetric expandedMetric, String name, Number reading) {
        if (this.expansionConfig.isSet(expandedMetric)) {
            if (!Numbers.isANumber(reading)) {
                return;
            }
            Signal signal = this.convertToSignal(name, expandedMetric);
            this.addLibratoGauge(measures, signal, reading.doubleValue());
        }
    }

    private Signal convertToSignal(String registryName) {
        return this.convertToSignal(registryName, null);
    }

    private Signal convertToSignal(String registryName, ExpandedMetric expandedMetric) {
        SourceInformation sourceInfo = SourceInformation.from(this.sourceRegex, registryName);
        if (sourceInfo.source != null) {
            String metricName = sourceInfo.name;
            if (expandedMetric != null) {
                metricName = expandedMetric.buildMetricName(metricName);
            }
            metricName = this.addPrefix(metricName);
            return new Signal(metricName, sourceInfo.source);
        }
        Signal signal = Signal.decode(registryName);
        if (expandedMetric != null) {
            signal.name = expandedMetric.buildMetricName(signal.name);
        }
        signal.name = this.addPrefix(signal.name);
        return signal;
    }

    private boolean skipMetric(String name, Counting counting) {
        return this.deleteIdleStats() && this.deltaTracker.peekDelta(name, counting.getCount()) == 0L;
    }

    private boolean deleteIdleStats() {
        return this.deleteIdleStats;
    }

    private double doConvertDuration(double duration, boolean convert) {
        return convert ? this.durationConverter.convertDuration(duration) : duration;
    }

    private double doConvertRate(double rate) {
        return this.rateConverter.convertRate(rate);
    }

    @Override
    public double convertRate(double rate) {
        return super.convertRate(rate);
    }

    @Override
    public double convertDuration(double duration) {
        return super.convertDuration(duration);
    }
}

