/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.password;

import com.h3xstream.findsecbugs.common.StackUtils;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.injection.InjectionPoint;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;

public class HashUnsafeEqualsDetector
extends BasicInjectionDetector
implements TaintFrameAdditionalVisitor {
    private static final String UNSAFE_HASH_EQUALS_TYPE = "UNSAFE_HASH_EQUALS";
    private static final InvokeMatcherBuilder STRING_EQUALS_METHOD = InstructionDSL.invokeInstruction().atClass("java/lang/String").atMethod("equals").withArgs("(Ljava/lang/Object;)Z");
    private static final InvokeMatcherBuilder ARRAYS_EQUALS_METHOD = InstructionDSL.invokeInstruction().atClass("java/util/Arrays").atMethod("equals").withArgs("([B[B)Z");
    private static final boolean DEBUG = false;
    public static final List<String> HASH_WORDS = new ArrayList<String>();

    public HashUnsafeEqualsDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.registerVisitor(this);
    }

    @Override
    protected int getPriorityFromTaintFrame(TaintFrame fact, int offset) throws DataflowAnalysisException {
        boolean passwordVariableRight;
        Taint rightValue = (Taint)fact.getStackValue(offset);
        Taint leftValue = (Taint)fact.getStackValue(offset == 0 ? 1 : 0);
        boolean passwordVariableLeft = leftValue.isUnknown() && leftValue.hasTag(Taint.Tag.HASH_VARIABLE);
        boolean bl = passwordVariableRight = rightValue.isUnknown() && rightValue.hasTag(Taint.Tag.HASH_VARIABLE);
        if (passwordVariableLeft || passwordVariableRight) {
            return 2;
        }
        return 5;
    }

    @Override
    protected InjectionPoint getInjectionPoint(InvokeInstruction invoke, ConstantPoolGen cpg, InstructionHandle handle) {
        if (STRING_EQUALS_METHOD.matches((Instruction)invoke, cpg) || ARRAYS_EQUALS_METHOD.matches((Instruction)invoke, cpg)) {
            return new InjectionPoint(new int[]{0, 1}, UNSAFE_HASH_EQUALS_TYPE);
        }
        return InjectionPoint.NONE;
    }

    @Override
    public void visitInvoke(InvokeInstruction invoke, MethodGen methodGen, TaintFrame frameType, List<Taint> parameters, ConstantPoolGen cpg) {
    }

    @Override
    public void visitReturn(MethodGen methodGen, Taint returnValue, ConstantPoolGen cpg) throws Exception {
    }

    @Override
    public void visitLoad(LoadInstruction instruction, MethodGen methodGen, TaintFrame frameType, int numProduced, ConstantPoolGen cpg) {
        int index = instruction.getIndex();
        LocalVariableGen var = StackUtils.getLocalVariable(methodGen, index);
        if (var == null) {
            return;
        }
        String fieldName = var.getName();
        boolean isHashVariable = false;
        String fieldNameLower = fieldName.toLowerCase();
        for (String password : HASH_WORDS) {
            if (!fieldNameLower.contains(password)) continue;
            isHashVariable = true;
        }
        if (!isHashVariable) {
            return;
        }
        Taint passwordValue = (Taint)frameType.getValue(index);
        passwordValue.addTag(Taint.Tag.HASH_VARIABLE);
        if (numProduced <= 0) {
            return;
        }
        try {
            for (int indexStack = 0; indexStack < numProduced; ++indexStack) {
                Taint value = (Taint)frameType.getStackValue(indexStack);
                value.addTag(Taint.Tag.HASH_VARIABLE);
            }
        }
        catch (DataflowAnalysisException dataflowAnalysisException) {
            // empty catch block
        }
    }

    @Override
    public void visitField(FieldInstruction put, MethodGen methodGen, TaintFrame frameType, Taint taint, int numProduced, ConstantPoolGen cpg) throws Exception {
    }

    static {
        HASH_WORDS.add("hash");
        HASH_WORDS.add("md5");
        HASH_WORDS.add("sha");
        HASH_WORDS.add("digest");
    }
}

