/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.spring;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class SpringEntityLeakDetector
implements Detector {
    private static final String SPRING_ENTITY_LEAK_TYPE = "SPRING_ENTITY_LEAK";
    private static final List<String> REQUEST_MAPPING_ANNOTATION_TYPES = Arrays.asList("Lorg/springframework/web/bind/annotation/RequestMapping;", "Lorg/springframework/web/bind/annotation/GetMapping;", "Lorg/springframework/web/bind/annotation/PostMapping;", "Lorg/springframework/web/bind/annotation/PutMapping;", "Lorg/springframework/web/bind/annotation/DeleteMapping;", "Lorg/springframework/web/bind/annotation/PatchMapping;");
    private static final List<String> ENTITY_ANNOTATION_TYPES = Arrays.asList("Ljavax/persistence/Entity;", "Ljavax/jdo/spi/PersistenceCapable;", "Lorg/springframework/data/mongodb/core/mapping/Document;");
    private BugReporter reporter;

    public SpringEntityLeakDetector(BugReporter bugReporter) {
        this.reporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass clazz = classContext.getJavaClass();
        if (this.hasRequestMapping(clazz)) {
            Method[] methods;
            for (Method m : methods = clazz.getMethods()) {
                this.analyzeMethod(m, classContext);
            }
        }
    }

    private boolean hasRequestMapping(JavaClass clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            AnnotationEntry[] annotations = m.getAnnotationEntries();
            m.getReturnType();
            for (AnnotationEntry ae : annotations) {
                if (!REQUEST_MAPPING_ANNOTATION_TYPES.contains(ae.getAnnotationType())) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> getAnnotationList(JavaClass javaClass) {
        ArrayList<String> annotations = new ArrayList<String>();
        for (AnnotationEntry annotationEntry : javaClass.getAnnotationEntries()) {
            annotations.add(annotationEntry.getAnnotationType());
        }
        try {
            for (AnnotationEntry annotationEntry : javaClass.getSuperClasses()) {
                annotations.addAll(this.getAnnotationList((JavaClass)annotationEntry));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return annotations;
    }

    private void analyzeMethod(Method m, ClassContext classContext) {
        JavaClass clazz = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(m);
        ArrayList<String> annotations = new ArrayList<String>();
        ArrayList<String> classesToInspect = new ArrayList<String>(Arrays.asList(methodGen.getReturnType().toString()));
        for (Type type : methodGen.getArgumentTypes()) {
            classesToInspect.add(type.toString());
        }
        for (String classToInspect : classesToInspect) {
            try {
                JavaClass javaClass = Repository.lookupClass((String)classToInspect);
                annotations.addAll(this.getAnnotationList(javaClass));
            }
            catch (Exception javaClass) {}
        }
        for (String annotation : annotations) {
            if (!ENTITY_ANNOTATION_TYPES.contains(annotation)) continue;
            BugInstance bug = new BugInstance((Detector)this, SPRING_ENTITY_LEAK_TYPE, 2);
            bug.addClassAndMethod(clazz, m);
            this.reporter.reportBug(bug);
            break;
        }
    }

    public void report() {
    }
}

