/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.constants;

import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalServiceUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Objects;

public class AccountRoleConstants {
    public static final String REQUIRED_ROLE_NAME_ACCOUNT_ADMINISTRATOR = "Account Administrator";
    public static final String REQUIRED_ROLE_NAME_ACCOUNT_MANAGER = "Account Manager";
    public static final String REQUIRED_ROLE_NAME_ACCOUNT_MEMBER = "Account Member";
    @Deprecated
    public static final String REQUIRED_ROLE_NAME_ACCOUNT_OWNER = "Account Owner";
    @Deprecated
    public static final String REQUIRED_ROLE_NAME_ACCOUNT_POWER_USER = "Account Power User";
    @Deprecated
    public static final String REQUIRED_ROLE_NAME_ACCOUNT_USER = "Account User";
    public static final String[] REQUIRED_ROLE_NAMES = new String[]{"Account Administrator", "Account Manager", "Account Member"};

    public static boolean isImpliedRole(Role role) {
        return Objects.equals(REQUIRED_ROLE_NAME_ACCOUNT_MEMBER, role.getName());
    }

    public static boolean isRequiredRole(Role role) {
        return ArrayUtil.contains((Object[])REQUIRED_ROLE_NAMES, (Object)role.getName());
    }

    public static boolean isSharedRole(Role role) {
        AccountRole accountRole = AccountRoleLocalServiceUtil.fetchAccountRoleByRoleId(role.getRoleId());
        return Objects.equals(accountRole.getAccountEntryId(), 0L);
    }
}

