/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.exception;

import com.liferay.portal.kernel.exception.PortalException;

public class DefaultAccountGroupException
extends PortalException {
    public DefaultAccountGroupException() {
    }

    public DefaultAccountGroupException(String msg) {
        super(msg);
    }

    public DefaultAccountGroupException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public DefaultAccountGroupException(Throwable throwable) {
        super(throwable);
    }

    public static class MustNotUpdateDefaultAccountGroup
    extends DefaultAccountGroupException {
        public long accountGroupId;

        public MustNotUpdateDefaultAccountGroup(long accountGroupId) {
            super(String.format("The default account group %s cannot be updated", accountGroupId));
            this.accountGroupId = accountGroupId;
        }
    }

    public static class MustNotDuplicateDefaultAccountGroup
    extends DefaultAccountGroupException {
        public long companyId;

        public MustNotDuplicateDefaultAccountGroup(long companyId) {
            super(String.format("There is already a default account group for company %s", companyId));
            this.companyId = companyId;
        }
    }

    public static class MustNotDeleteDefaultAccountGroup
    extends DefaultAccountGroupException {
        public long accountGroupId;

        public MustNotDeleteDefaultAccountGroup(long accountGroupId) {
            super(String.format("The default account group %s cannot be deleted", accountGroupId));
            this.accountGroupId = accountGroupId;
        }
    }
}

