/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.rest.internal.dto.v1_0.converter;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRelModel;
import com.liferay.account.rest.dto.v1_0.Account;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.account.model.AccountEntry"}, service={AccountResourceDTOConverter.class, DTOConverter.class})
public class AccountResourceDTOConverter
implements DTOConverter<AccountEntry, Account> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;

    public long getAccountEntryId(String externalReferenceCode) throws Exception {
        AccountEntry accountEntry = this.getObject(externalReferenceCode);
        return accountEntry.getAccountEntryId();
    }

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public AccountEntry getObject(String externalReferenceCode) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntryByReferenceCode(CompanyThreadLocal.getCompanyId().longValue(), externalReferenceCode);
        if (accountEntry == null) {
            accountEntry = this._accountEntryLocalService.getAccountEntry(GetterUtil.getLong((String)externalReferenceCode));
        }
        return accountEntry;
    }

    public Account toDTO(DTOConverterContext dtoConverterContext, final AccountEntry accountEntry) {
        if (accountEntry == null) {
            return null;
        }
        return new Account(){
            {
                this.description = accountEntry.getDescription();
                this.domains = StringUtil.split((String)accountEntry.getDomains());
                this.externalReferenceCode = accountEntry.getExternalReferenceCode();
                this.id = accountEntry.getAccountEntryId();
                this.name = accountEntry.getName();
                this.organizationIds = (Long[])TransformUtil.transformToArray((Collection)AccountResourceDTOConverter.this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntry.getAccountEntryId()), AccountEntryOrganizationRelModel::getOrganizationId, Long.class);
                this.parentAccountId = accountEntry.getParentAccountEntryId();
                this.status = accountEntry.getStatus();
            }
        };
    }
}

