/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.rest.internal.dto.v1_0.converter;

import com.liferay.account.rest.dto.v1_0.Account;
import com.liferay.account.rest.dto.v1_0.AccountUser;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.User"}, service={AccountUserResourceDTOConverter.class, DTOConverter.class})
public class AccountUserResourceDTOConverter
implements DTOConverter<User, AccountUser> {
    @Reference
    private ListTypeLocalService _listTypeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return Account.class.getSimpleName();
    }

    public User getObject(String externalReferenceCode) throws Exception {
        User user = this._userLocalService.fetchUserByReferenceCode(CompanyThreadLocal.getCompanyId().longValue(), externalReferenceCode);
        if (user == null) {
            user = this._userLocalService.getUser(GetterUtil.getLong((String)externalReferenceCode));
        }
        return user;
    }

    public long getUserId(String externalReferenceCode) throws Exception {
        User user = this.getObject(externalReferenceCode);
        return user.getUserId();
    }

    public AccountUser toDTO(DTOConverterContext dtoConverterContext, final User user) throws Exception {
        if (user == null) {
            return null;
        }
        final Contact contact = user.getContact();
        return new AccountUser(){
            {
                this.emailAddress = user.getEmailAddress();
                this.externalReferenceCode = user.getExternalReferenceCode();
                this.firstName = user.getFirstName();
                this.id = user.getUserId();
                this.lastName = user.getLastName();
                this.middleName = user.getMiddleName();
                this.screenName = user.getScreenName();
                this.setPrefix(() -> {
                    long prefixId = contact.getPrefixId();
                    if (prefixId <= 0L) {
                        return null;
                    }
                    ListType prefixListType = AccountUserResourceDTOConverter.this._listTypeLocalService.getListType(prefixId);
                    return prefixListType.getName();
                });
                this.setSuffix(() -> {
                    long suffixId = contact.getSuffixId();
                    if (suffixId <= 0L) {
                        return null;
                    }
                    ListType suffixListType = AccountUserResourceDTOConverter.this._listTypeLocalService.getListType(suffixId);
                    return suffixListType.getName();
                });
            }
        };
    }
}

