/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.rest.internal.graphql.query.v1_0;

import com.liferay.account.rest.dto.v1_0.Account;
import com.liferay.account.rest.dto.v1_0.AccountRole;
import com.liferay.account.rest.dto.v1_0.AccountUser;
import com.liferay.account.rest.resource.v1_0.AccountResource;
import com.liferay.account.rest.resource.v1_0.AccountRoleResource;
import com.liferay.account.rest.resource.v1_0.AccountUserResource;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.ComponentServiceObjects;

public class Query {
    private static ComponentServiceObjects<AccountResource> _accountResourceComponentServiceObjects;
    private static ComponentServiceObjects<AccountRoleResource> _accountRoleResourceComponentServiceObjects;
    private static ComponentServiceObjects<AccountUserResource> _accountUserResourceComponentServiceObjects;
    private AcceptLanguage _acceptLanguage;
    private Company _company;
    private BiFunction<Object, String, Filter> _filterBiFunction;
    private GroupLocalService _groupLocalService;
    private HttpServletRequest _httpServletRequest;
    private HttpServletResponse _httpServletResponse;
    private RoleLocalService _roleLocalService;
    private BiFunction<Object, String, Sort[]> _sortsBiFunction;
    private UriInfo _uriInfo;
    private User _user;

    public static void setAccountResourceComponentServiceObjects(ComponentServiceObjects<AccountResource> accountResourceComponentServiceObjects) {
        _accountResourceComponentServiceObjects = accountResourceComponentServiceObjects;
    }

    public static void setAccountRoleResourceComponentServiceObjects(ComponentServiceObjects<AccountRoleResource> accountRoleResourceComponentServiceObjects) {
        _accountRoleResourceComponentServiceObjects = accountRoleResourceComponentServiceObjects;
    }

    public static void setAccountUserResourceComponentServiceObjects(ComponentServiceObjects<AccountUserResource> accountUserResourceComponentServiceObjects) {
        _accountUserResourceComponentServiceObjects = accountUserResourceComponentServiceObjects;
    }

    @GraphQLField(description="Retrieves the accounts. Results can be paginated, filtered, searched, and sorted.")
    public @GraphQLField(description="Retrieves the accounts. Results can be paginated, filtered, searched, and sorted.") AccountPage accounts(@GraphQLName(value="keywords") String keywords, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountPage)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> new AccountPage(accountResource.getAccountsPage(keywords, this._filterBiFunction.apply(accountResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountResource, sortsString))));
    }

    @GraphQLField(description="")
    public @GraphQLField(description="") Account accountByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.getAccountByExternalReferenceCode(externalReferenceCode));
    }

    @GraphQLField(description="")
    public @GraphQLField(description="") Account account(@GraphQLName(value="accountId") Long accountId) throws Exception {
        return (Account)this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, this::_populateResourceContext, accountResource -> accountResource.getAccount(accountId));
    }

    @GraphQLField(description="Gets the account's roles")
    public @GraphQLField(description="Gets the account's roles") AccountRolePage accountRolesByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountRolePage)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountRolesByExternalReferenceCodePage(externalReferenceCode, keywords, Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountRoleResource, sortsString))));
    }

    @GraphQLField(description="Gets the account's roles")
    public @GraphQLField(description="Gets the account's roles") AccountRolePage accountRoles(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountRolePage)this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, this::_populateResourceContext, accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountRolesPage(accountId, keywords, Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountRoleResource, sortsString))));
    }

    @GraphQLField(description="Gets the users assigned to an account")
    public @GraphQLField(description="Gets the users assigned to an account") AccountUserPage accountUsersByExternalReferenceCode(@GraphQLName(value="externalReferenceCode") String externalReferenceCode, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountUserPage)this._applyComponentServiceObjects(_accountUserResourceComponentServiceObjects, this::_populateResourceContext, accountUserResource -> new AccountUserPage(accountUserResource.getAccountUsersByExternalReferenceCodePage(externalReferenceCode, search, this._filterBiFunction.apply(accountUserResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountUserResource, sortsString))));
    }

    @GraphQLField(description="Gets the users assigned to an account")
    public @GraphQLField(description="Gets the users assigned to an account") AccountUserPage accountUsers(@GraphQLName(value="accountId") Long accountId, @GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
        return (AccountUserPage)this._applyComponentServiceObjects(_accountUserResourceComponentServiceObjects, this::_populateResourceContext, accountUserResource -> new AccountUserPage(accountUserResource.getAccountUsersPage(accountId, search, this._filterBiFunction.apply(accountUserResource, filterString), Pagination.of((int)page, (int)pageSize), this._sortsBiFunction.apply(accountUserResource, sortsString))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R, E1 extends Throwable, E2 extends Throwable> R _applyComponentServiceObjects(ComponentServiceObjects<T> componentServiceObjects, UnsafeConsumer<T, E1> unsafeConsumer, UnsafeFunction<T, R, E2> unsafeFunction) throws E1, E2 {
        Object resource = componentServiceObjects.getService();
        try {
            unsafeConsumer.accept(resource);
            Object object = unsafeFunction.apply(resource);
            return (R)object;
        }
        finally {
            componentServiceObjects.ungetService(resource);
        }
    }

    private void _populateResourceContext(AccountResource accountResource) throws Exception {
        accountResource.setContextAcceptLanguage(this._acceptLanguage);
        accountResource.setContextCompany(this._company);
        accountResource.setContextHttpServletRequest(this._httpServletRequest);
        accountResource.setContextHttpServletResponse(this._httpServletResponse);
        accountResource.setContextUriInfo(this._uriInfo);
        accountResource.setContextUser(this._user);
        accountResource.setGroupLocalService(this._groupLocalService);
        accountResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(AccountRoleResource accountRoleResource) throws Exception {
        accountRoleResource.setContextAcceptLanguage(this._acceptLanguage);
        accountRoleResource.setContextCompany(this._company);
        accountRoleResource.setContextHttpServletRequest(this._httpServletRequest);
        accountRoleResource.setContextHttpServletResponse(this._httpServletResponse);
        accountRoleResource.setContextUriInfo(this._uriInfo);
        accountRoleResource.setContextUser(this._user);
        accountRoleResource.setGroupLocalService(this._groupLocalService);
        accountRoleResource.setRoleLocalService(this._roleLocalService);
    }

    private void _populateResourceContext(AccountUserResource accountUserResource) throws Exception {
        accountUserResource.setContextAcceptLanguage(this._acceptLanguage);
        accountUserResource.setContextCompany(this._company);
        accountUserResource.setContextHttpServletRequest(this._httpServletRequest);
        accountUserResource.setContextHttpServletResponse(this._httpServletResponse);
        accountUserResource.setContextUriInfo(this._uriInfo);
        accountUserResource.setContextUser(this._user);
        accountUserResource.setGroupLocalService(this._groupLocalService);
        accountUserResource.setRoleLocalService(this._roleLocalService);
    }

    @GraphQLTypeExtension(value=Account.class)
    public class ParentAccountAccountIdTypeExtension {
        private Account _account;

        public ParentAccountAccountIdTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="")
        public @GraphQLField(description="") Account parentAccount() throws Exception {
            if (this._account.getParentAccountId() == null) {
                return null;
            }
            return (Account)Query.this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountResource -> accountResource.getAccount(this._account.getParentAccountId()));
        }
    }

    @GraphQLName(value="AccountUserPage")
    public class AccountUserPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<AccountUser> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public AccountUserPage(Page accountUserPage) {
            this.actions = accountUserPage.getActions();
            this.items = accountUserPage.getItems();
            this.lastPage = accountUserPage.getLastPage();
            this.page = accountUserPage.getPage();
            this.pageSize = accountUserPage.getPageSize();
            this.totalCount = accountUserPage.getTotalCount();
        }
    }

    @GraphQLName(value="AccountRolePage")
    public class AccountRolePage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<AccountRole> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public AccountRolePage(Page accountRolePage) {
            this.actions = accountRolePage.getActions();
            this.items = accountRolePage.getItems();
            this.lastPage = accountRolePage.getLastPage();
            this.page = accountRolePage.getPage();
            this.pageSize = accountRolePage.getPageSize();
            this.totalCount = accountRolePage.getTotalCount();
        }
    }

    @GraphQLName(value="AccountPage")
    public class AccountPage {
        @GraphQLField
        protected Map<String, Map> actions;
        @GraphQLField
        protected Collection<Account> items;
        @GraphQLField
        protected long lastPage;
        @GraphQLField
        protected long page;
        @GraphQLField
        protected long pageSize;
        @GraphQLField
        protected long totalCount;

        public AccountPage(Page accountPage) {
            this.actions = accountPage.getActions();
            this.items = accountPage.getItems();
            this.lastPage = accountPage.getLastPage();
            this.page = accountPage.getPage();
            this.pageSize = accountPage.getPageSize();
            this.totalCount = accountPage.getTotalCount();
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountRolesPageTypeExtension {
        private Account _account;

        public GetAccountRolesPageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets the account's roles")
        public @GraphQLField(description="Gets the account's roles") AccountRolePage roles(@GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (AccountRolePage)Query.this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountRolesPage(this._account.getId(), keywords, Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(accountRoleResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountUsersByExternalReferenceCodePageTypeExtension {
        private Account _account;

        public GetAccountUsersByExternalReferenceCodePageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets the users assigned to an account")
        public @GraphQLField(description="Gets the users assigned to an account") AccountUserPage usersByExternalReferenceCode(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (AccountUserPage)Query.this._applyComponentServiceObjects(_accountUserResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountUserResource -> new AccountUserPage(accountUserResource.getAccountUsersByExternalReferenceCodePage(this._account.getExternalReferenceCode(), search, (Filter)Query.this._filterBiFunction.apply(accountUserResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(accountUserResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=AccountRole.class)
    public class GetAccountTypeExtension {
        private AccountRole _accountRole;

        public GetAccountTypeExtension(AccountRole accountRole) {
            this._accountRole = accountRole;
        }

        @GraphQLField(description="")
        public @GraphQLField(description="") Account account() throws Exception {
            return (Account)Query.this._applyComponentServiceObjects(_accountResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountResource -> accountResource.getAccount(this._accountRole.getAccountId()));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountUsersPageTypeExtension {
        private Account _account;

        public GetAccountUsersPageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets the users assigned to an account")
        public @GraphQLField(description="Gets the users assigned to an account") AccountUserPage users(@GraphQLName(value="search") String search, @GraphQLName(value="filter") String filterString, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (AccountUserPage)Query.this._applyComponentServiceObjects(_accountUserResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountUserResource -> new AccountUserPage(accountUserResource.getAccountUsersPage(this._account.getId(), search, (Filter)Query.this._filterBiFunction.apply(accountUserResource, filterString), Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(accountUserResource, sortsString))));
        }
    }

    @GraphQLTypeExtension(value=Account.class)
    public class GetAccountRolesByExternalReferenceCodePageTypeExtension {
        private Account _account;

        public GetAccountRolesByExternalReferenceCodePageTypeExtension(Account account) {
            this._account = account;
        }

        @GraphQLField(description="Gets the account's roles")
        public @GraphQLField(description="Gets the account's roles") AccountRolePage rolesByExternalReferenceCode(@GraphQLName(value="keywords") String keywords, @GraphQLName(value="pageSize") int pageSize, @GraphQLName(value="page") int page, @GraphQLName(value="sort") String sortsString) throws Exception {
            return (AccountRolePage)Query.this._applyComponentServiceObjects(_accountRoleResourceComponentServiceObjects, x$0 -> Query.this._populateResourceContext(x$0), accountRoleResource -> new AccountRolePage(accountRoleResource.getAccountRolesByExternalReferenceCodePage(this._account.getExternalReferenceCode(), keywords, Pagination.of((int)page, (int)pageSize), (Sort[])Query.this._sortsBiFunction.apply(accountRoleResource, sortsString))));
        }
    }
}

