/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.rest.internal.resource.v1_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.rest.dto.v1_0.Account;
import com.liferay.account.rest.internal.dto.v1_0.converter.AccountResourceDTOConverter;
import com.liferay.account.rest.internal.odata.entity.v1_0.AccountEntityModel;
import com.liferay.account.rest.internal.resource.v1_0.BaseAccountResourceImpl;
import com.liferay.account.rest.resource.v1_0.AccountResource;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountResource.class})
public class AccountResourceImpl
extends BaseAccountResourceImpl
implements EntityModelResource {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountResourceDTOConverter _accountResourceDTOConverter;
    private final EntityModel _entityModel = new AccountEntityModel();

    @Override
    public void deleteAccount(Long accountId) throws Exception {
        this._accountEntryLocalService.deleteAccountEntry(accountId.longValue());
    }

    @Override
    public void deleteAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        this.deleteAccount(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode));
    }

    @Override
    public void deleteOrganizationAccounts(Long organizationId, Long[] accountIds) throws Exception {
        for (Long accountId : accountIds) {
            this._accountEntryOrganizationRelLocalService.deleteAccountEntryOrganizationRel(accountId.longValue(), organizationId.longValue());
        }
    }

    @Override
    public void deleteOrganizationAccountsByExternalReferenceCode(Long organizationId, String[] externalReferenceCodes) throws Exception {
        for (String externalReferenceCode : externalReferenceCodes) {
            this._accountEntryOrganizationRelLocalService.deleteAccountEntryOrganizationRel(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), organizationId.longValue());
        }
    }

    @Override
    public Account getAccount(Long accountId) throws Exception {
        return this._toAccount(this._accountEntryLocalService.getAccountEntry(accountId.longValue()));
    }

    @Override
    public Account getAccountByExternalReferenceCode(String externalReferenceCode) throws Exception {
        return this.getAccount(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode));
    }

    @Override
    public Page<Account> getAccountsPage(String keywords, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_ACCOUNT_ENTRY", "postAccount", "com.liferay.account", 0L)).put((Object)"get", this.addAction("VIEW", 0L, "getAccountsPage", this._accountEntryModelResourcePermission)).build(), booleanQuery -> {}, (Filter)filter, (String)AccountEntry.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> {}, searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (Validator.isNotNull((String)keywords)) {
                searchContext.setKeywords(keywords);
            }
        }, (Sort[])sorts, document -> {
            long accountEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            return this._toAccount(this._accountEntryLocalService.getAccountEntry(accountEntryId));
        });
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return this._entityModel;
    }

    @Override
    public void patchOrganizationMoveAccounts(Long sourceOrganizationId, Long targetOrganizationId, Long[] accountIds) throws Exception {
        this.deleteOrganizationAccounts(sourceOrganizationId, accountIds);
        this.postOrganizationAccounts(targetOrganizationId, accountIds);
    }

    @Override
    public void patchOrganizationMoveAccountsByExternalReferenceCode(Long sourceOrganizationId, Long targetOrganizationId, String[] externalReferenceCodes) throws Exception {
        this.deleteOrganizationAccountsByExternalReferenceCode(sourceOrganizationId, externalReferenceCodes);
        this.postOrganizationAccountsByExternalReferenceCode(targetOrganizationId, externalReferenceCodes);
    }

    @Override
    public Account postAccount(Account account) throws Exception {
        AccountEntry accountEntry = this._accountEntryLocalService.addOrUpdateAccountEntry(account.getExternalReferenceCode(), this.contextUser.getUserId(), this._getParentAccountId(account), account.getName(), account.getDescription(), this._getDomains(account), null, null, null, "business", this._getStatus(account), null);
        this._accountEntryOrganizationRelLocalService.setAccountEntryOrganizationRels(accountEntry.getAccountEntryId(), this._getOrganizationIds(account));
        return this._toAccount(accountEntry);
    }

    @Override
    public void postOrganizationAccounts(Long organizationId, Long[] accountIds) throws Exception {
        for (Long accountId : accountIds) {
            this._accountEntryOrganizationRelLocalService.addAccountEntryOrganizationRel(accountId.longValue(), organizationId.longValue());
        }
    }

    @Override
    public void postOrganizationAccountsByExternalReferenceCode(Long organizationId, String[] externalReferenceCodes) throws Exception {
        for (String externalReferenceCode : externalReferenceCodes) {
            this._accountEntryOrganizationRelLocalService.addAccountEntryOrganizationRel(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), organizationId.longValue());
        }
    }

    @Override
    public Account putAccount(Long accountId, Account account) throws Exception {
        this._accountEntryOrganizationRelLocalService.setAccountEntryOrganizationRels(accountId.longValue(), this._getOrganizationIds(account));
        return this._toAccount(this._accountEntryLocalService.updateAccountEntry(accountId, this._getParentAccountId(account), account.getName(), account.getDescription(), false, this._getDomains(account), null, null, null, this._getStatus(account), null));
    }

    @Override
    public Account putAccountByExternalReferenceCode(String externalReferenceCode, Account account) throws Exception {
        return this.putAccount(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), account);
    }

    private Map<String, Map<String, String>> _getActions(Long accountEntryId) {
        return HashMapBuilder.put((Object)"create-organization-accounts", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "postOrganizationAccounts", this._accountEntryModelResourcePermission)).put((Object)"create-organization-accounts-by-external-reference-code", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "postOrganizationAccountsByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"delete", this.addAction("DELETE", accountEntryId, "deleteAccount", this._accountEntryModelResourcePermission)).put((Object)"delete-by-external-reference-code", this.addAction("DELETE", accountEntryId, "deleteAccountByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"delete-organization-accounts", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "deleteOrganizationAccounts", this._accountEntryModelResourcePermission)).put((Object)"delete-organization-accounts-by-external-reference-code", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "deleteOrganizationAccountsByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"get", this.addAction("VIEW", accountEntryId, "getAccount", this._accountEntryModelResourcePermission)).put((Object)"get-by-external-reference-code", this.addAction("VIEW", accountEntryId, "getAccountByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"move-organization-accounts", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "patchOrganizationMoveAccounts", this._accountEntryModelResourcePermission)).put((Object)"move-organization-accounts-by-external-reference-code", this.addAction("MANAGE_ORGANIZATIONS", accountEntryId, "patchOrganizationMoveAccountsByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"replace", this.addAction("UPDATE", accountEntryId, "putAccount", this._accountEntryModelResourcePermission)).put((Object)"replace-by-external-reference-code", this.addAction("UPDATE", accountEntryId, "putAccountByExternalReferenceCode", this._accountEntryModelResourcePermission)).put((Object)"update", this.addAction("UPDATE", accountEntryId, "patchAccount", this._accountEntryModelResourcePermission)).put((Object)"update-by-external-reference-code", this.addAction("UPDATE", accountEntryId, "patchAccountByExternalReferenceCode", this._accountEntryModelResourcePermission)).build();
    }

    private String[] _getDomains(Account account) {
        return Optional.ofNullable(account.getDomains()).orElse(new String[0]);
    }

    private long[] _getOrganizationIds(Account account) {
        return Optional.ofNullable(account.getOrganizationIds()).map(ArrayUtil::toArray).orElse(new long[0]);
    }

    private long _getParentAccountId(Account account) {
        return Optional.ofNullable(account.getParentAccountId()).orElse(0L);
    }

    private int _getStatus(Account account) {
        return Optional.ofNullable(account.getStatus()).orElse(0);
    }

    private Account _toAccount(AccountEntry accountEntry) throws Exception {
        Account account = (Account)this._accountResourceDTOConverter.toDTO(accountEntry);
        account.setActions(this._getActions(accountEntry.getAccountEntryId()));
        return account;
    }
}

