/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.rest.internal.resource.v1_0;

import com.liferay.account.rest.dto.v1_0.AccountRole;
import com.liferay.account.rest.internal.dto.v1_0.converter.AccountResourceDTOConverter;
import com.liferay.account.rest.internal.dto.v1_0.converter.AccountUserResourceDTOConverter;
import com.liferay.account.rest.internal.resource.v1_0.BaseAccountRoleResourceImpl;
import com.liferay.account.rest.resource.v1_0.AccountRoleResource;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.comparator.RoleDescriptionComparator;
import com.liferay.portal.kernel.util.comparator.RoleNameComparator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import java.util.Collections;
import java.util.Objects;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-role.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountRoleResource.class})
public class AccountRoleResourceImpl
extends BaseAccountRoleResourceImpl
implements EntityModelResource {
    private static final RoleNameComparator _roleNameComparator = new RoleNameComparator();
    @Reference
    private AccountResourceDTOConverter _accountResourceDTOConverter;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private AccountUserResourceDTOConverter _accountUserResourceDTOConverter;
    private final EntityModel _entityModel = Collections::emptyMap;

    @Override
    public void deleteAccountRoleUserAssociation(Long accountId, Long accountRoleId, Long accountUserId) throws Exception {
        this._accountRoleLocalService.unassociateUser(accountId.longValue(), accountRoleId.longValue(), accountUserId.longValue());
    }

    @Override
    public void deleteAccountRoleUserAssociationByExternalReferenceCode(String accountExternalReferenceCode, Long accountRoleId, String accountUserExternalReferenceCode) throws Exception {
        this.deleteAccountRoleUserAssociation(this._accountResourceDTOConverter.getAccountEntryId(accountExternalReferenceCode), accountRoleId, this._accountUserResourceDTOConverter.getUserId(accountUserExternalReferenceCode));
    }

    @Override
    public Page<AccountRole> getAccountRolesByExternalReferenceCodePage(String externalReferenceCode, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getAccountRolesPage(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), keywords, pagination, sorts);
    }

    @Override
    public Page<AccountRole> getAccountRolesPage(Long accountId, String keywords, Pagination pagination, Sort[] sorts) {
        BaseModelSearchResult baseModelSearchResult = this._accountRoleLocalService.searchAccountRoles(this.contextCompany.getCompanyId(), accountId.longValue(), keywords, pagination.getStartPosition(), pagination.getEndPosition(), this._getOrderByComparator(sorts));
        return Page.of(this.transform(baseModelSearchResult.getBaseModels(), this::_toAccountRole), (Pagination)pagination, (long)baseModelSearchResult.getLength());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return this._entityModel;
    }

    @Override
    public AccountRole postAccountRole(Long accountId, AccountRole accountRole) throws Exception {
        return this._toAccountRole(this._accountRoleLocalService.addAccountRole(this.contextUser.getUserId(), accountId.longValue(), accountRole.getName(), Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), accountRole.getDisplayName()), Collections.singletonMap(this.contextAcceptLanguage.getPreferredLocale(), accountRole.getDescription())));
    }

    @Override
    public AccountRole postAccountRoleByExternalReferenceCode(String externalReferenceCode, AccountRole accountRole) throws Exception {
        return this.postAccountRole(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), accountRole);
    }

    @Override
    public void postAccountRoleUserAssociation(Long accountId, Long accountRoleId, Long accountUserId) throws Exception {
        this._accountRoleLocalService.associateUser(accountId.longValue(), accountRoleId.longValue(), accountUserId.longValue());
    }

    @Override
    public void postAccountRoleUserAssociationByExternalReferenceCode(String accountExternalReferenceCode, Long accountRoleId, String accountUserExternalReferenceCode) throws Exception {
        this.postAccountRoleUserAssociation(this._accountResourceDTOConverter.getAccountEntryId(accountExternalReferenceCode), accountRoleId, this._accountUserResourceDTOConverter.getUserId(accountUserExternalReferenceCode));
    }

    private OrderByComparator<?> _getOrderByComparator(Sort[] sorts) {
        if (sorts == null || sorts.length == 0) {
            return _roleNameComparator;
        }
        Sort sort = sorts[0];
        if (Objects.equals(sort.getFieldName(), "description")) {
            return new RoleDescriptionComparator(!sort.isReverse());
        }
        if (Objects.equals(sort.getFieldName(), "name")) {
            return new RoleNameComparator(!sort.isReverse());
        }
        return _roleNameComparator;
    }

    private AccountRole _toAccountRole(final com.liferay.account.model.AccountRole serviceBuilderAccountRole) throws Exception {
        final Role role = serviceBuilderAccountRole.getRole();
        return new AccountRole(){
            {
                this.accountId = serviceBuilderAccountRole.getAccountEntryId();
                this.description = role.getDescription(AccountRoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.displayName = role.getTitle(AccountRoleResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                this.id = serviceBuilderAccountRole.getAccountRoleId();
                this.name = serviceBuilderAccountRole.getRoleName();
                this.roleId = serviceBuilderAccountRole.getRoleId();
            }
        };
    }
}

