/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.rest.internal.resource.v1_0;

import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.rest.dto.v1_0.AccountUser;
import com.liferay.account.rest.internal.dto.v1_0.converter.AccountResourceDTOConverter;
import com.liferay.account.rest.internal.dto.v1_0.converter.AccountUserResourceDTOConverter;
import com.liferay.account.rest.internal.odata.entity.v1_0.AccountUserEntityModel;
import com.liferay.account.rest.internal.resource.v1_0.BaseAccountUserResourceImpl;
import com.liferay.account.rest.resource.v1_0.AccountUserResource;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.account.service.AccountEntryUserRelService;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/account-user.properties"}, scope=ServiceScope.PROTOTYPE, service={AccountUserResource.class})
public class AccountUserResourceImpl
extends BaseAccountUserResourceImpl
implements EntityModelResource {
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private AccountEntryUserRelService _accountEntryUserRelService;
    @Reference
    private AccountResourceDTOConverter _accountResourceDTOConverter;
    private final AccountUserEntityModel _accountUserEntityModel = new AccountUserEntityModel();
    @Reference
    private AccountUserResourceDTOConverter _accountUserResourceDTOConverter;
    @Reference
    private ListTypeLocalService _listTypeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public void deleteAccountUserByEmailAddress(Long accountId, String emailAddress) throws Exception {
        this._accountEntryUserRelService.deleteAccountEntryUserRelByEmailAddress(accountId.longValue(), emailAddress);
    }

    @Override
    public void deleteAccountUserByExternalReferenceCodeByEmailAddress(String externalReferenceCode, String emailAddress) throws Exception {
        this.deleteAccountUserByEmailAddress(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), emailAddress);
    }

    @Override
    public void deleteAccountUsersByEmailAddress(Long accountId, String[] emailAddresses) throws Exception {
        for (String emailAddress : emailAddresses) {
            this.deleteAccountUserByEmailAddress(accountId, emailAddress);
        }
    }

    @Override
    public void deleteAccountUsersByExternalReferenceCodeByEmailAddress(String externalReferenceCode, String[] emailAddresses) throws Exception {
        for (String emailAddress : emailAddresses) {
            this.deleteAccountUserByExternalReferenceCodeByEmailAddress(externalReferenceCode, emailAddress);
        }
    }

    @Override
    public Page<AccountUser> getAccountUsersByExternalReferenceCodePage(String externalReferenceCode, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getAccountUsersPage(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), search, filter, pagination, sorts);
    }

    @Override
    public Page<AccountUser> getAccountUsersPage(Long accountId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("accountEntryIds", String.valueOf(accountId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)User.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), (Sort[])sorts, document -> this._toAccountUser(this._userLocalService.getUserById(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return this._accountUserEntityModel;
    }

    @Override
    public AccountUser postAccountUser(Long accountId, AccountUser accountUser) throws Exception {
        AccountEntryUserRel accountEntryUserRel = this._accountEntryUserRelLocalService.addAccountEntryUserRel(accountId.longValue(), this.contextUser.getUserId(), accountUser.getScreenName(), accountUser.getEmailAddress(), this.contextAcceptLanguage.getPreferredLocale(), accountUser.getFirstName(), accountUser.getMiddleName(), accountUser.getLastName(), this._getPrefixId(accountUser), this._getSuffixId(accountUser));
        User user = this._userLocalService.getUser(accountEntryUserRel.getAccountUserId());
        if (accountUser.getExternalReferenceCode() != null) {
            user.setExternalReferenceCode(accountUser.getExternalReferenceCode());
            user = this._userLocalService.updateUser(user);
        }
        return this._toAccountUser(user);
    }

    @Override
    public void postAccountUserByEmailAddress(Long accountId, String emailAddress) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(this.contextCompany.getCompanyId());
        serviceContext.setLanguageId(this.contextAcceptLanguage.getPreferredLanguageId());
        serviceContext.setUserId(this.contextUser.getUserId());
        this._accountEntryUserRelService.addAccountEntryUserRelByEmailAddress(accountId.longValue(), emailAddress, new long[0], null, serviceContext);
    }

    @Override
    public AccountUser postAccountUserByExternalReferenceCode(String externalReferenceCode, AccountUser accountUser) throws Exception {
        return this.postAccountUser(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), accountUser);
    }

    @Override
    public void postAccountUserByExternalReferenceCodeByEmailAddress(String externalReferenceCode, String emailAddress) throws Exception {
        this.postAccountUserByEmailAddress(this._accountResourceDTOConverter.getAccountEntryId(externalReferenceCode), emailAddress);
    }

    @Override
    public void postAccountUsersByEmailAddress(Long accountId, String[] emailAddresses) throws Exception {
        for (String emailAddress : emailAddresses) {
            this.postAccountUserByEmailAddress(accountId, emailAddress);
        }
    }

    @Override
    public void postAccountUsersByExternalReferenceCodeByEmailAddress(String externalReferenceCode, String[] emailAddresses) throws Exception {
        for (String emailAddress : emailAddresses) {
            this.postAccountUserByExternalReferenceCodeByEmailAddress(externalReferenceCode, emailAddress);
        }
    }

    private long _getListTypeId(String value, String type) {
        ListType listType = this._listTypeLocalService.addListType(value, type);
        return listType.getListTypeId();
    }

    private long _getPrefixId(AccountUser accountUser) {
        return Optional.ofNullable(accountUser.getPrefix()).map(prefix -> this._getListTypeId((String)prefix, ListTypeConstants.CONTACT_PREFIX)).orElse(0L);
    }

    private long _getSuffixId(AccountUser accountUser) {
        return Optional.ofNullable(accountUser.getSuffix()).map(prefix -> this._getListTypeId((String)prefix, ListTypeConstants.CONTACT_SUFFIX)).orElse(0L);
    }

    private AccountUser _toAccountUser(User user) throws Exception {
        return (AccountUser)this._accountUserResourceDTOConverter.toDTO(user);
    }
}

