/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.rest.internal.resource.v1_0;

import com.liferay.account.rest.dto.v1_0.Account;
import com.liferay.account.rest.resource.v1_0.AccountResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseAccountResourceImpl
implements AccountResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<Account> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Operation(description="Retrieves the accounts. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/accounts")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public Page<Account> getAccountsPage(@Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Context Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Creates a new account")
    @Path(value="/accounts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public Account postAccount(Account account) throws Exception {
        return new Account();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/accounts/batch")
    @POST
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="Account")})
    public Response postAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(Account.class.getName(), callbackURL, null, object)).build();
    }

    @DELETE
    @Operation(description="Deletes an account.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public void deleteAccountByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @GET
    @Operation(description="")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public Account getAccountByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new Account();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates the account with information sent in the request body. Only the provided fields are updated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @PATCH
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public Account patchAccountByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode, Account account) throws Exception {
        Account existingAccount = this.getAccountByExternalReferenceCode(externalReferenceCode);
        if (account.getActions() != null) {
            existingAccount.setActions(account.getActions());
        }
        if (account.getDescription() != null) {
            existingAccount.setDescription(account.getDescription());
        }
        if (account.getDomains() != null) {
            existingAccount.setDomains(account.getDomains());
        }
        if (account.getExternalReferenceCode() != null) {
            existingAccount.setExternalReferenceCode(account.getExternalReferenceCode());
        }
        if (account.getName() != null) {
            existingAccount.setName(account.getName());
        }
        if (account.getOrganizationIds() != null) {
            existingAccount.setOrganizationIds(account.getOrganizationIds());
        }
        if (account.getParentAccountId() != null) {
            existingAccount.setParentAccountId(account.getParentAccountId());
        }
        if (account.getStatus() != null) {
            existingAccount.setStatus(account.getStatus());
        }
        this.preparePatch(account, existingAccount);
        return this.putAccountByExternalReferenceCode(externalReferenceCode, existingAccount);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the account with information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Path(value="/accounts/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="Account")})
    public Account putAccountByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="externalReferenceCode") String externalReferenceCode, Account account) throws Exception {
        return new Account();
    }

    @DELETE
    @Operation(description="Deletes an account.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Path(value="/accounts/{accountId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public void deleteAccount(@NotNull @Parameter(hidden=true) @PathParam(value="accountId") Long accountId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/accounts/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="Account")})
    public Response deleteAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(Account.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Operation(description="")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Path(value="/accounts/{accountId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public Account getAccount(@NotNull @Parameter(hidden=true) @PathParam(value="accountId") Long accountId) throws Exception {
        return new Account();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Updates the account with information sent in the request body. Only the provided fields are updated.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @PATCH
    @Path(value="/accounts/{accountId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public Account patchAccount(@NotNull @Parameter(hidden=true) @PathParam(value="accountId") Long accountId, Account account) throws Exception {
        Account existingAccount = this.getAccount(accountId);
        if (account.getActions() != null) {
            existingAccount.setActions(account.getActions());
        }
        if (account.getDescription() != null) {
            existingAccount.setDescription(account.getDescription());
        }
        if (account.getDomains() != null) {
            existingAccount.setDomains(account.getDomains());
        }
        if (account.getExternalReferenceCode() != null) {
            existingAccount.setExternalReferenceCode(account.getExternalReferenceCode());
        }
        if (account.getName() != null) {
            existingAccount.setName(account.getName());
        }
        if (account.getOrganizationIds() != null) {
            existingAccount.setOrganizationIds(account.getOrganizationIds());
        }
        if (account.getParentAccountId() != null) {
            existingAccount.setParentAccountId(account.getParentAccountId());
        }
        if (account.getStatus() != null) {
            existingAccount.setStatus(account.getStatus());
        }
        this.preparePatch(account, existingAccount);
        return this.putAccount(accountId, existingAccount);
    }

    @Consumes(value={"application/json", "application/xml"})
    @Operation(description="Replaces the account with information sent in the request body. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="accountId")})
    @Path(value="/accounts/{accountId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    @Tags(value={@Tag(name="Account")})
    public Account putAccount(@NotNull @Parameter(hidden=true) @PathParam(value="accountId") Long accountId, Account account) throws Exception {
        return new Account();
    }

    @Consumes(value={"application/json"})
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/accounts/batch")
    @Produces(value={"application/json"})
    @PUT
    @Tags(value={@Tag(name="Account")})
    public Response putAccountBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(Account.class.getName(), callbackURL, object)).build();
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="sourceOrganizationId"), @Parameter(in=ParameterIn.PATH, name="targetOrganizationId")})
    @PATCH
    @Path(value="/organizations/move-accounts/{sourceOrganizationId}/{targetOrganizationId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public void patchOrganizationMoveAccounts(@NotNull @Parameter(hidden=true) @PathParam(value="sourceOrganizationId") Long sourceOrganizationId, @NotNull @Parameter(hidden=true) @PathParam(value="targetOrganizationId") Long targetOrganizationId, Long[] longs) throws Exception {
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="sourceOrganizationId"), @Parameter(in=ParameterIn.PATH, name="targetOrganizationId")})
    @PATCH
    @Path(value="/organizations/move-accounts/{sourceOrganizationId}/{targetOrganizationId}/by-external-reference-code")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public void patchOrganizationMoveAccountsByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="sourceOrganizationId") Long sourceOrganizationId, @NotNull @Parameter(hidden=true) @PathParam(value="targetOrganizationId") Long targetOrganizationId, String[] strings) throws Exception {
    }

    @Consumes(value={"application/json", "application/xml"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Path(value="/organizations/{organizationId}/accounts")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public void deleteOrganizationAccounts(@NotNull @Parameter(hidden=true) @PathParam(value="organizationId") Long organizationId, Long[] longs) throws Exception {
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Path(value="/organizations/{organizationId}/accounts")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public void postOrganizationAccounts(@NotNull @Parameter(hidden=true) @PathParam(value="organizationId") Long organizationId, Long[] longs) throws Exception {
    }

    @Consumes(value={"application/json", "application/xml"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Path(value="/organizations/{organizationId}/accounts/by-external-reference-code")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public void deleteOrganizationAccountsByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="organizationId") Long organizationId, String[] strings) throws Exception {
    }

    @Consumes(value={"application/json", "application/xml"})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="organizationId")})
    @Path(value="/organizations/{organizationId}/accounts/by-external-reference-code")
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="Account")})
    public void postOrganizationAccountsByExternalReferenceCode(@NotNull @Parameter(hidden=true) @PathParam(value="organizationId") Long organizationId, String[] strings) throws Exception {
    }

    public void create(Collection<Account> accounts, Map<String, Serializable> parameters) throws Exception {
        for (Account account : accounts) {
            this.postAccount(account);
        }
    }

    public void delete(Collection<Account> accounts, Map<String, Serializable> parameters) throws Exception {
        for (Account account : accounts) {
            this.deleteAccount(account.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<Account> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getAccountsPage((String)((Object)parameters.get("keywords")), filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<Account> accounts, Map<String, Serializable> parameters) throws Exception {
        for (Account account : accounts) {
            this.putAccount(account.getId() != null ? account.getId() : Long.parseLong((String)((Object)parameters.get("accountId"))), account);
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(Account account, Account existingAccount) {
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

