/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.model.listener;

import com.liferay.account.constants.AccountRoleConstants;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredRoleException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class RoleModelListener
extends BaseModelListener<Role> {
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public void onAfterCreate(Role role) throws ModelListenerException {
        if (!Objects.equals(role.getClassNameId(), this._portal.getClassNameId(AccountRole.class)) || !Objects.equals(role.getType(), 6)) {
            return;
        }
        AccountRole accountRole = this._accountRoleLocalService.fetchAccountRoleByRoleId(role.getRoleId());
        if (accountRole != null) {
            return;
        }
        accountRole = this._accountRoleLocalService.createAccountRole(this._counterLocalService.increment());
        accountRole.setCompanyId(role.getCompanyId());
        accountRole.setAccountEntryId(0L);
        accountRole.setRoleId(role.getRoleId());
        this._accountRoleLocalService.addAccountRole(accountRole);
        role.setClassPK(accountRole.getAccountRoleId());
        this._roleLocalService.updateRole(role);
    }

    public void onAfterRemove(Role role) throws ModelListenerException {
        if (role == null) {
            return;
        }
        AccountRole accountRole = this._accountRoleLocalService.fetchAccountRoleByRoleId(role.getRoleId());
        if (accountRole != null) {
            try {
                this._accountRoleLocalService.deleteAccountRole(accountRole);
            }
            catch (PortalException portalException) {
                throw new ModelListenerException((Throwable)portalException);
            }
        }
    }

    public void onBeforeRemove(Role role) throws ModelListenerException {
        if (CompanyThreadLocal.isDeleteInProcess()) {
            return;
        }
        if (ArrayUtil.contains((Object[])AccountRoleConstants.REQUIRED_ROLE_NAMES, (Object)role.getName())) {
            throw new ModelListenerException((Throwable)new RequiredRoleException("Role \"" + role.getName() + "\" is a default account role"));
        }
        AccountRole accountRole = this._accountRoleLocalService.fetchAccountRoleByRoleId(role.getRoleId());
        if (accountRole != null) {
            if (!Objects.equals(0L, accountRole.getAccountEntryId())) {
                throw new ModelListenerException((Throwable)new RequiredRoleException(StringBundler.concat((Object[])new Object[]{"Role \"", role.getName(), "\" is required by account role ", accountRole.getAccountRoleId()})));
            }
            this._userGroupRoleLocalService.deleteUserGroupRolesByRoleId(role.getRoleId());
        }
    }
}

