/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.retriever;

import com.liferay.account.internal.search.searcher.UserSearchRequestBuilder;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.retriever.AccountUserRetriever;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AccountUserRetriever.class})
public class AccountUserRetrieverImpl
implements AccountUserRetriever {
    private static final Log _log = LogFactoryUtil.getLog(AccountUserRetrieverImpl.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private AccountRoleLocalService _accountRoleLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserSearchRequestBuilder _userSearchRequestBuilder;

    public List<User> getAccountUsers(long accountEntryId) {
        return TransformUtil.transform((Collection)this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountEntryId(accountEntryId), accountEntryUserRel -> this._userLocalService.getUserById(accountEntryUserRel.getAccountUserId()));
    }

    public long getAccountUsersCount(long accountEntryId) {
        return this._accountEntryUserRelLocalService.getAccountEntryUserRelsCountByAccountEntryId(accountEntryId);
    }

    public BaseModelSearchResult<User> searchAccountRoleUsers(long accountEntryId, long accountRoleId, String keywords, int start, int end, OrderByComparator<User> orderByComparator) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        AccountRole accountRole = this._accountRoleLocalService.getAccountRole(accountRoleId);
        LinkedHashMap params = LinkedHashMapBuilder.put((Object)"userGroupRole", (Object)new Long[]{accountEntry.getAccountEntryGroupId(), accountRole.getRoleId()}).build();
        List users = this._userLocalService.search(accountEntry.getCompanyId(), keywords, 0, params, start, end, orderByComparator);
        int total = this._userLocalService.searchCount(accountEntry.getCompanyId(), keywords, 0, params);
        return new BaseModelSearchResult(users, total);
    }

    public BaseModelSearchResult<User> searchAccountUsers(long accountEntryId, String keywords, int status, int cur, int delta, String sortField, boolean reverse) throws PortalException {
        return this.searchAccountUsers(new long[]{accountEntryId}, keywords, status, cur, delta, sortField, reverse);
    }

    public BaseModelSearchResult<User> searchAccountUsers(long accountEntryId, String[] emailAddressDomains, String keywords, int status, int cur, int delta, String sortField, boolean reverse) throws PortalException {
        return this._getUserBaseModelSearchResult(this._getSearchResponse(HashMapBuilder.put((Object)"accountEntryIds", (Object)new long[]{accountEntryId}).put((Object)"emailAddressDomains", (Object)emailAddressDomains).build(), cur, delta, keywords, reverse, sortField, status));
    }

    public BaseModelSearchResult<User> searchAccountUsers(long[] accountEntryIds, String keywords, int status, int cur, int delta, String sortField, boolean reverse) throws PortalException {
        for (long accountEntryId : accountEntryIds) {
            if (accountEntryId == -1L || accountEntryId == 0L) continue;
            this._accountEntryLocalService.getAccountEntry(accountEntryId);
        }
        return this._getUserBaseModelSearchResult(this._getSearchResponse(HashMapBuilder.put((Object)"accountEntryIds", (Object)accountEntryIds).build(), cur, delta, keywords, reverse, sortField, status));
    }

    private SearchResponse _getSearchResponse(Map<String, Serializable> attributes, int cur, int delta, String keywords, boolean reverse, String sortField, int status) {
        return this._searcher.search(this._userSearchRequestBuilder.attributes(attributes).cur(cur).delta(delta).keywords(keywords).reverse(reverse).sortField(sortField).status(status).build());
    }

    private BaseModelSearchResult<User> _getUserBaseModelSearchResult(SearchResponse searchResponse) {
        SearchHits searchHits = searchResponse.getSearchHits();
        if (searchHits == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Search hits is null");
            }
            return new BaseModelSearchResult(Collections.emptyList(), 0);
        }
        List users = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long userId = document.getLong("userId");
            User user = this._userLocalService.fetchUser(userId);
            if (user == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
                indexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return user;
        });
        return new BaseModelSearchResult(users, Long.valueOf(searchHits.getTotalHits()));
    }
}

