/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.searcher;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UserSearchRequestBuilder.class})
public class UserSearchRequestBuilder {
    private Map<String, Serializable> _attributes = new HashMap<String, Serializable>();
    private int _cur;
    private int _delta;
    private String _keywords;
    private boolean _reverse;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    private String _sortField;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;
    private int _status;

    public UserSearchRequestBuilder attributes(Map<String, Serializable> attributes) {
        this._attributes = attributes;
        return this;
    }

    public SearchRequest build() {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{User.class.getName()}).withSearchContext(searchContext -> this._populateSearchContext((SearchContext)searchContext)).emptySearchEnabled(true).highlightEnabled(false);
        if (this._cur != -1) {
            searchRequestBuilder.from(Integer.valueOf(this._cur));
            searchRequestBuilder.size(Integer.valueOf(this._delta));
        }
        if (Validator.isNotNull((String)this._sortField)) {
            SortOrder sortOrder = SortOrder.ASC;
            if (this._reverse) {
                sortOrder = SortOrder.DESC;
            }
            FieldSort fieldSort = this._sorts.field(this._sortFieldBuilder.getSortField(User.class.getName(), this._sortField), sortOrder);
            searchRequestBuilder.sorts(new Sort[]{fieldSort});
        }
        return searchRequestBuilder.build();
    }

    public UserSearchRequestBuilder cur(int cur) {
        this._cur = cur;
        return this;
    }

    public UserSearchRequestBuilder delta(int delta) {
        this._delta = delta;
        return this;
    }

    public UserSearchRequestBuilder keywords(String keywords) {
        this._keywords = keywords;
        return this;
    }

    public UserSearchRequestBuilder reverse(boolean reverse) {
        this._reverse = reverse;
        return this;
    }

    public UserSearchRequestBuilder sortField(String sortField) {
        this._sortField = sortField;
        return this;
    }

    public UserSearchRequestBuilder status(int status) {
        this._status = status;
        return this;
    }

    private void _populateSearchContext(SearchContext searchContext) {
        boolean andSearch = false;
        if (Validator.isNull((String)this._keywords)) {
            andSearch = true;
        } else {
            searchContext.setKeywords(this._keywords);
        }
        searchContext.setAndSearch(andSearch);
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"status", (Object)this._status).put((Object)"city", (Object)this._keywords).put((Object)"country", (Object)this._keywords).put((Object)"firstName", (Object)this._keywords).put((Object)"fullName", (Object)this._keywords).put((Object)"lastName", (Object)this._keywords).put((Object)"middleName", (Object)this._keywords).put((Object)"params", new LinkedHashMap()).put((Object)"region", (Object)this._keywords).put((Object)"screenName", (Object)this._keywords).put((Object)"street", (Object)this._keywords).put((Object)"zip", (Object)this._keywords).putAll(this._attributes).build());
        searchContext.setCompanyId(CompanyThreadLocal.getCompanyId().longValue());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            searchContext.setUserId(permissionChecker.getUserId());
        }
    }
}

