/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.permission;

import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.search.spi.model.permission.SearchPermissionFilterContributor;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={SearchPermissionFilterContributor.class})
public class UserSearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    @Reference
    protected RoleLocalService roleLocalService;
    private static final Log _log = LogFactoryUtil.getLog(UserSearchPermissionFilterContributor.class);
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        block6: {
            if (!className.equals(User.class.getName())) {
                return;
            }
            try {
                long[] userOrgIds;
                TermsFilter termsFilter = new TermsFilter("accountEntryIds");
                UserBag userBag = permissionChecker.getUserBag();
                for (long userOrgId : userOrgIds = userBag.getUserOrgIds()) {
                    if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userOrgId, (String)"MANAGE_ACCOUNTS")) continue;
                    List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRelsByOrganizationId(userOrgId);
                    for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
                        termsFilter.addValue(String.valueOf(accountEntryOrganizationRel.getAccountEntryId()));
                    }
                }
                if (!termsFilter.isEmpty()) {
                    booleanFilter.add((Filter)termsFilter);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
    }
}

