/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.security.permission.contributor;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.contributor.RoleCollection;
import com.liferay.portal.kernel.security.permission.contributor.RoleContributor;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RoleContributor.class})
public class AccountRoleContributor
implements RoleContributor {
    private static final Log _log = LogFactoryUtil.getLog(AccountRoleContributor.class);
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private RoleLocalService _roleLocalService;

    public void contribute(RoleCollection roleCollection) {
        try {
            if (roleCollection.getGroupId() <= 0L) {
                return;
            }
            Group group = this._groupLocalService.getGroup(roleCollection.getGroupId());
            if (!Objects.equals(AccountEntry.class.getName(), group.getClassName())) {
                return;
            }
            User user = roleCollection.getUser();
            if (this._accountEntryUserRelLocalService.hasAccountEntryUserRel(group.getClassPK(), user.getUserId())) {
                this._addRoleId(roleCollection, "Account Member");
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }

    private void _addRoleId(RoleCollection roleCollection, String roleName) throws PortalException {
        Role role = this._roleLocalService.getRole(roleCollection.getCompanyId(), roleName);
        roleCollection.addRoleId(role.getRoleId());
    }
}

