/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.constants.AccountConstants;
import com.liferay.account.exception.AccountEntryDomainsException;
import com.liferay.account.exception.AccountEntryEmailAddressException;
import com.liferay.account.exception.AccountEntryNameException;
import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRelTable;
import com.liferay.account.model.AccountEntryTable;
import com.liferay.account.model.AccountEntryUserRelTable;
import com.liferay.account.model.impl.AccountEntryImpl;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.base.AccountEntryLocalServiceBaseImpl;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.OrganizationModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.util.TransformUtil;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Stream;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntry"}, service={AopService.class})
public class AccountEntryLocalServiceImpl
extends AccountEntryLocalServiceBaseImpl {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private Portal _portal;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserFileUploadsSettings _userFileUploadsSettings;

    public void activateAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)this::activateAccountEntry));
    }

    public AccountEntry activateAccountEntry(AccountEntry accountEntry) {
        return this.updateStatus(accountEntry, 0);
    }

    public AccountEntry activateAccountEntry(long accountEntryId) throws Exception {
        return this.activateAccountEntry(this.getAccountEntry(accountEntryId));
    }

    @Deprecated
    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, byte[] logoBytes, int status) throws PortalException {
        return this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, logoBytes, null, "business", status, null);
    }

    @Deprecated
    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, byte[] logoBytes, int status, ServiceContext serviceContext) throws PortalException {
        return this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, logoBytes, null, "business", status, serviceContext);
    }

    @Deprecated
    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        return this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, null, logoBytes, taxIdNumber, type, status, serviceContext);
    }

    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        long accountEntryId = this.counterLocalService.increment();
        AccountEntry accountEntry = this.accountEntryPersistence.create(accountEntryId);
        User user = this.userLocalService.getUser(userId);
        accountEntry.setCompanyId(user.getCompanyId());
        accountEntry.setUserId(user.getUserId());
        accountEntry.setUserName(user.getFullName());
        accountEntry.setParentAccountEntryId(parentAccountEntryId);
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)AccountEntry.class.getName(), (String)"name");
        name = StringUtil.shorten((String)name, (int)nameMaxLength);
        this._validateName(name);
        accountEntry.setName(name);
        accountEntry.setDescription(description);
        domains = this._validateDomains(domains);
        accountEntry.setDomains(StringUtil.merge((Object[])domains, (String)","));
        this._validateEmailAddress(emailAddress);
        accountEntry.setEmailAddress(emailAddress);
        this._portal.updateImageId((BaseModel)accountEntry, true, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        accountEntry.setTaxIdNumber(taxIdNumber);
        this._validateType(type);
        accountEntry.setType(type);
        accountEntry.setStatus(status);
        accountEntry = (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
        this.groupLocalService.addGroup(userId, 0L, AccountEntry.class.getName(), accountEntryId, 0L, this.getLocalizationMap(name), null, 3, false, 0, null, false, true, null);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), AccountEntry.class.getName(), accountEntryId, false, false, false);
        if (serviceContext != null) {
            this._updateAsset(accountEntry, serviceContext);
            accountEntry.setExpandoBridgeAttributes(serviceContext);
        }
        return accountEntry;
    }

    public AccountEntry addOrUpdateAccountEntry(String externalReferenceCode, long userId, long parentAccountEntryId, String name, String description, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        AccountEntry accountEntry = this.fetchAccountEntryByReferenceCode(user.getCompanyId(), externalReferenceCode);
        if (accountEntry != null) {
            return this.updateAccountEntry(accountEntry.getAccountEntryId(), parentAccountEntryId, name, description, false, domains, emailAddress, logoBytes, taxIdNumber, status, serviceContext);
        }
        accountEntry = this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, emailAddress, logoBytes, taxIdNumber, type, status, serviceContext);
        accountEntry.setExternalReferenceCode(externalReferenceCode);
        return (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
    }

    public void deactivateAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)this::deactivateAccountEntry));
    }

    public AccountEntry deactivateAccountEntry(AccountEntry accountEntry) {
        return this.updateStatus(accountEntry, 5);
    }

    public AccountEntry deactivateAccountEntry(long accountEntryId) throws Exception {
        return this.deactivateAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public void deleteAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)arg_0 -> ((AccountEntryLocalService)this.accountEntryLocalService).deleteAccountEntry(arg_0)));
    }

    public void deleteAccountEntriesByCompanyId(long companyId) {
        if (!CompanyThreadLocal.isDeleteInProcess()) {
            throw new UnsupportedOperationException("Deleting account entries by company must be called when deleting a company");
        }
        for (AccountEntry accountRole : this.accountEntryPersistence.findByCompanyId(companyId)) {
            this.accountEntryPersistence.remove((BaseModel)accountRole);
        }
    }

    @Override
    public AccountEntry deleteAccountEntry(AccountEntry accountEntry) throws PortalException {
        accountEntry = super.deleteAccountEntry(accountEntry);
        this.groupLocalService.deleteGroup(accountEntry.getAccountEntryGroup());
        this.resourceLocalService.deleteResource(accountEntry.getCompanyId(), AccountEntry.class.getName(), 4, accountEntry.getAccountEntryId());
        this.assetEntryLocalService.deleteEntry(AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        this.expandoRowLocalService.deleteRows(accountEntry.getAccountEntryId());
        return accountEntry;
    }

    @Override
    public AccountEntry deleteAccountEntry(long accountEntryId) throws PortalException {
        return this.deleteAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public AccountEntry fetchPersonAccountEntry(long userId) {
        return this.accountEntryPersistence.fetchByU_T_First(userId, "person", null);
    }

    public AccountEntry fetchUserAccountEntry(long userId, long accountEntryId) {
        DSLQuery dslQuery;
        List accountEntries;
        JoinStep joinStep = DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE).from((Table)UserTable.INSTANCE).leftJoinOn((Table)AccountEntryUserRelTable.INSTANCE, AccountEntryUserRelTable.INSTANCE.accountUserId.eq((Expression)UserTable.INSTANCE.userId));
        Predicate accountEntryTablePredicate = AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryUserRelTable.INSTANCE.accountEntryId).or((Expression)AccountEntryTable.INSTANCE.userId.eq((Expression)UserTable.INSTANCE.userId));
        Object[] organizationIds = this._getOrganizationIds(userId);
        if (ArrayUtil.isNotEmpty((Object[])organizationIds)) {
            joinStep = joinStep.leftJoinOn((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.organizationId.in(organizationIds));
            accountEntryTablePredicate = accountEntryTablePredicate.or((Expression)AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryOrganizationRelTable.INSTANCE.accountEntryId));
        }
        if ((accountEntries = (List)this.dslQuery(dslQuery = (joinStep = joinStep.leftJoinOn((Table)AccountEntryTable.INSTANCE, accountEntryTablePredicate)).where(UserTable.INSTANCE.userId.eq((Object)userId).and((Expression)AccountEntryTable.INSTANCE.type.neq((Object)"guest")).and((Expression)AccountEntryTable.INSTANCE.accountEntryId.eq((Object)accountEntryId))).limit(0, 1))).isEmpty()) {
            return null;
        }
        return (AccountEntry)accountEntries.get(0);
    }

    public List<AccountEntry> getAccountEntries(long companyId, int status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) {
        return this.accountEntryPersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public int getAccountEntriesCount(long companyId, int status) {
        return this.accountEntryPersistence.countByC_S(companyId, status);
    }

    public AccountEntry getGuestAccountEntry(long companyId) throws PortalException {
        User defaultUser = this.userLocalService.getDefaultUser(companyId);
        AccountEntryImpl accountEntryImpl = new AccountEntryImpl();
        accountEntryImpl.setAccountEntryId(-1L);
        accountEntryImpl.setCompanyId(defaultUser.getCompanyId());
        accountEntryImpl.setUserId(defaultUser.getUserId());
        accountEntryImpl.setUserName(defaultUser.getFullName());
        accountEntryImpl.setParentAccountEntryId(0L);
        accountEntryImpl.setEmailAddress(defaultUser.getEmailAddress());
        accountEntryImpl.setName(defaultUser.getFullName());
        accountEntryImpl.setType("guest");
        accountEntryImpl.setStatus(0);
        return accountEntryImpl;
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, int start, int end) throws PortalException {
        return this.getUserAccountEntries(userId, parentAccountEntryId, keywords, types, -1, start, end);
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status, int start, int end) throws PortalException {
        return (List)this.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE), userId, parentAccountEntryId, keywords, types, status).limit(start, end));
    }

    public int getUserAccountEntriesCount(long userId, Long parentAccountEntryId, String keywords, String[] types) throws PortalException {
        return this.getUserAccountEntriesCount(userId, parentAccountEntryId, keywords, types, -1);
    }

    public int getUserAccountEntriesCount(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status) throws PortalException {
        return this.accountEntryPersistence.dslQueryCount((DSLQuery)this._getGroupByStep(DSLQueryFactoryUtil.countDistinct((Expression)AccountEntryTable.INSTANCE.accountEntryId), userId, parentAccountEntryId, keywords, types, status));
    }

    public BaseModelSearchResult<AccountEntry> searchAccountEntries(long companyId, String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(companyId, keywords, params, cur, delta, orderByField, reverse));
        SearchHits searchHits = searchResponse.getSearchHits();
        List accountEntries = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long accountEntryId = document.getLong("entryClassPK");
            AccountEntry accountEntry = this.fetchAccountEntry(accountEntryId);
            if (accountEntry == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(AccountEntry.class);
                indexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return accountEntry;
        });
        return new BaseModelSearchResult(accountEntries, searchResponse.getTotalHits());
    }

    @Deprecated
    public AccountEntry updateAccountEntry(Long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, byte[] logoBytes, int status) throws PortalException {
        return this.updateAccountEntry(accountEntryId, parentAccountEntryId, name, description, deleteLogo, domains, logoBytes, null, status, null);
    }

    @Deprecated
    public AccountEntry updateAccountEntry(Long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, byte[] logoBytes, int status, ServiceContext serviceContext) throws PortalException {
        return this.updateAccountEntry(accountEntryId, parentAccountEntryId, name, description, deleteLogo, domains, logoBytes, null, status, serviceContext);
    }

    @Deprecated
    public AccountEntry updateAccountEntry(Long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, byte[] logoBytes, String taxIdNumber, int status, ServiceContext serviceContext) throws PortalException {
        return this.updateAccountEntry(accountEntryId, parentAccountEntryId, name, description, deleteLogo, domains, null, logoBytes, taxIdNumber, status, serviceContext);
    }

    public AccountEntry updateAccountEntry(Long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, int status, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = (AccountEntry)this.accountEntryPersistence.fetchByPrimaryKey((Serializable)accountEntryId);
        accountEntry.setParentAccountEntryId(parentAccountEntryId);
        this._validateName(name);
        accountEntry.setName(name);
        accountEntry.setDescription(description);
        domains = this._validateDomains(domains);
        accountEntry.setDomains(StringUtil.merge((Object[])domains, (String)","));
        this._validateEmailAddress(emailAddress);
        accountEntry.setEmailAddress(emailAddress);
        this._portal.updateImageId((BaseModel)accountEntry, !deleteLogo, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        accountEntry.setTaxIdNumber(taxIdNumber);
        accountEntry.setStatus(status);
        if (serviceContext != null) {
            this._updateAsset(accountEntry, serviceContext);
            accountEntry.setExpandoBridgeAttributes(serviceContext);
        }
        return (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateDefaultBillingAddressId(long accountEntryId, long addressId) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        accountEntry.setDefaultBillingAddressId(addressId);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateDefaultShippingAddressId(long accountEntryId, long addressId) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        accountEntry.setDefaultShippingAddressId(addressId);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateStatus(AccountEntry accountEntry, int status) {
        accountEntry.setStatus(status);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateStatus(long accountEntryId, int status) throws PortalException {
        return this.updateStatus(this.getAccountEntry(accountEntryId), status);
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, long userId, Long parentAccountId, String keywords, String[] types, Integer status) throws PortalException {
        JoinStep joinStep = fromStep.from((Table)UserTable.INSTANCE).leftJoinOn((Table)AccountEntryUserRelTable.INSTANCE, AccountEntryUserRelTable.INSTANCE.accountUserId.eq((Expression)UserTable.INSTANCE.userId));
        Object[] organizationIds = this._getOrganizationIds(userId);
        if (ArrayUtil.isNotEmpty((Object[])organizationIds)) {
            joinStep = joinStep.leftJoinOn((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.organizationId.in(organizationIds));
        }
        Predicate accountEntryPredicate = AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryUserRelTable.INSTANCE.accountEntryId).or((Expression)AccountEntryTable.INSTANCE.userId.eq((Object)userId));
        if (ArrayUtil.isNotEmpty((Object[])organizationIds)) {
            accountEntryPredicate = accountEntryPredicate.or((Expression)AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryOrganizationRelTable.INSTANCE.accountEntryId));
        }
        joinStep = joinStep.leftJoinOn((Table)AccountEntryTable.INSTANCE, accountEntryPredicate);
        return joinStep.where(() -> {
            Predicate predicate = UserTable.INSTANCE.userId.eq((Object)userId);
            if (parentAccountId != null) {
                predicate = predicate.and((Expression)AccountEntryTable.INSTANCE.parentAccountEntryId.eq((Object)parentAccountId));
            }
            if (Validator.isNotNull((String)keywords)) {
                predicate = predicate.and((Expression)Predicate.withParentheses((Predicate)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)AccountEntryTable.INSTANCE.name), this._customSQL.keywords(keywords, true))));
            }
            if (types != null) {
                predicate = predicate.and((Expression)AccountEntryTable.INSTANCE.type.in((Object[])types));
            }
            if (status != null && status != -1) {
                predicate = predicate.and((Expression)AccountEntryTable.INSTANCE.status.eq((Object)status));
            }
            return predicate;
        });
    }

    private Long[] _getOrganizationIds(long userId) {
        List organizations = this.organizationLocalService.getUserOrganizations(userId);
        ListIterator<Organization> listIterator = organizations.listIterator();
        while (listIterator.hasNext()) {
            Organization organization = (Organization)listIterator.next();
            for (Organization curOrganization : this.organizationLocalService.getOrganizations(organization.getCompanyId(), organization.getTreePath() + "%")) {
                listIterator.add(curOrganization);
            }
        }
        Stream stream = organizations.stream();
        return (Long[])stream.map(OrganizationModel::getOrganizationId).distinct().toArray(Long[]::new);
    }

    private SearchRequest _getSearchRequest(long companyId, String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{AccountEntry.class.getName()}).emptySearchEnabled(true).highlightEnabled(false).withSearchContext(searchContext -> this._populateSearchContext((SearchContext)searchContext, companyId, keywords, params));
        if (cur != -1) {
            searchRequestBuilder.from(Integer.valueOf(cur));
            searchRequestBuilder.size(Integer.valueOf(delta));
        }
        if (Validator.isNotNull((String)orderByField)) {
            SortOrder sortOrder = SortOrder.ASC;
            if (reverse) {
                sortOrder = SortOrder.DESC;
            }
            FieldSort fieldSort = this._sorts.field(this._sortFieldBuilder.getSortField(AccountEntry.class.getName(), orderByField), sortOrder);
            searchRequestBuilder.sorts(new Sort[]{fieldSort});
        }
        return searchRequestBuilder.build();
    }

    private void _performActions(long[] accountEntryIds, ActionableDynamicQuery.PerformActionMethod<AccountEntry> performActionMethod) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.in((String)"accountEntryId", (Object[])ArrayUtil.toArray((long[])accountEntryIds))));
        actionableDynamicQuery.setPerformActionMethod(performActionMethod);
        actionableDynamicQuery.performActions();
    }

    private void _populateSearchContext(SearchContext searchContext, long companyId, String keywords, LinkedHashMap<String, Object> params) {
        long parentAccountEntryId;
        long[] organizationIds;
        Object[] domains;
        long[] accountUserIds;
        searchContext.setCompanyId(companyId);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (MapUtil.isEmpty(params)) {
            return;
        }
        long[] accountGroupIds = (long[])params.get("accountGroupIds");
        if (ArrayUtil.isNotEmpty((long[])accountGroupIds)) {
            searchContext.setAttribute("accountGroupIds", (Serializable)accountGroupIds);
        }
        if (ArrayUtil.isNotEmpty((long[])(accountUserIds = (long[])params.get("accountUserIds")))) {
            searchContext.setAttribute("accountUserIds", (Serializable)accountUserIds);
        }
        if (ArrayUtil.isNotEmpty((Object[])(domains = (String[])params.get("domains")))) {
            searchContext.setAttribute("domains", (Serializable)domains);
        }
        if (ArrayUtil.isNotEmpty((long[])(organizationIds = (long[])params.get("organizationIds")))) {
            searchContext.setAttribute("organizationIds", (Serializable)organizationIds);
        }
        if ((parentAccountEntryId = GetterUtil.getLong((Object)params.get("parentAccountEntryId"), (long)-1L)) != -1L) {
            searchContext.setAttribute("parentAccountEntryId", (Serializable)Long.valueOf(parentAccountEntryId));
        }
        int status = GetterUtil.getInteger((Object)params.get("status"), (int)0);
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        String type = (String)params.get("type");
        if (Validator.isNotNull((String)type)) {
            searchContext.setAttribute("type", (Serializable)((Object)type));
        }
    }

    private void _updateAsset(AccountEntry accountEntry, ServiceContext serviceContext) throws PortalException {
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this.assetEntryLocalService.updateEntry(serviceContext.getUserId(), company.getGroupId(), accountEntry.getCreateDate(), accountEntry.getModifiedDate(), AccountEntry.class.getName(), accountEntry.getAccountEntryId(), null, 0L, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, true, null, null, null, null, null, accountEntry.getName(), accountEntry.getDescription(), null, null, null, 0, 0, null);
    }

    private String[] _validateDomains(String[] domains) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])domains)) {
            return domains;
        }
        DomainValidator domainValidator = DomainValidator.getInstance();
        for (String domain : domains) {
            if (domainValidator.isValid(domain)) continue;
            throw new AccountEntryDomainsException();
        }
        return ArrayUtil.distinct((String[])domains);
    }

    private void _validateEmailAddress(String emailAddress) throws AccountEntryEmailAddressException {
        EmailValidator emailValidator;
        if (Validator.isNotNull((String)emailAddress) && !(emailValidator = EmailValidator.getInstance()).isValid(emailAddress)) {
            throw new AccountEntryEmailAddressException();
        }
    }

    private void _validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new AccountEntryNameException();
        }
    }

    private void _validateType(String type) throws PortalException {
        if (!ArrayUtil.contains((Object[])AccountConstants.ACCOUNT_ENTRY_TYPES, (Object)type)) {
            throw new AccountEntryTypeException();
        }
    }
}

