/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.base.AccountEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.OrganizationModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.OrganizationPermission;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountEntry"}, service={AopService.class})
public class AccountEntryServiceImpl
extends AccountEntryServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryServiceImpl.class);
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private OrganizationPermission _organizationPermission;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(resource.name=com.liferay.account)")
    private volatile PortletResourcePermission _portletResourcePermission;

    @Deprecated
    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, byte[] logoBytes, int status) throws PortalException {
        return this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, null, logoBytes, null, "business", status, null);
    }

    @Deprecated
    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, byte[] logoBytes, int status, ServiceContext serviceContext) throws PortalException {
        return this.addAccountEntry(userId, parentAccountEntryId, name, description, domains, null, logoBytes, null, "business", status, serviceContext);
    }

    public AccountEntry addAccountEntry(long userId, long parentAccountEntryId, String name, String description, String[] domains, String email, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_ACCOUNT_ENTRY");
        return this.accountEntryLocalService.addAccountEntry(userId, parentAccountEntryId, name, description, domains, email, logoBytes, taxIdNumber, type, status, serviceContext);
    }

    public List<AccountEntry> getAccountEntries(long companyId, int status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.hasPermission(null, AccountEntry.class.getName(), companyId, "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), 0L, new String[]{"VIEW"});
        }
        return this.accountEntryLocalService.getAccountEntries(companyId, status, start, end, orderByComparator);
    }

    public BaseModelSearchResult<AccountEntry> searchAccountEntries(String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        PermissionChecker permissionChecker = this._getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin()) {
            try {
                User user = this.userLocalService.getUser(permissionChecker.getUserId());
                BaseModelSearchResult baseModelSearchResult = this._organizationLocalService.searchOrganizations(user.getCompanyId(), -1L, null, LinkedHashMapBuilder.put((Object)"accountsOrgsTree", (Object)ListUtil.filter((List)user.getOrganizations(true), organization -> this._hasManageAccountsPermission(permissionChecker, (Organization)organization))).build(), -1, -1, null);
                if (baseModelSearchResult.getLength() == 0) {
                    return new BaseModelSearchResult(Collections.emptyList(), 0);
                }
                if (params == null) {
                    params = new LinkedHashMap();
                }
                params.put("organizationIds", ListUtil.toLongArray((List)baseModelSearchResult.getBaseModels(), OrganizationModel::getOrganizationId));
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)portalException, (Throwable)portalException);
                }
                return new BaseModelSearchResult(Collections.emptyList(), 0);
            }
        }
        return this.accountEntryLocalService.searchAccountEntries(permissionChecker.getCompanyId(), keywords, params, cur, delta, orderByField, reverse);
    }

    private PermissionChecker _getPermissionChecker() {
        try {
            return this.getPermissionChecker();
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)principalException, (Throwable)principalException);
            }
            return PermissionThreadLocal.getPermissionChecker();
        }
    }

    private boolean _hasManageAccountsPermission(PermissionChecker permissionChecker, Organization organization) {
        try {
            this._organizationPermission.check(permissionChecker, organization, "MANAGE_ACCOUNTS");
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return false;
        }
        return true;
    }
}

