/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.account.service.base.AccountGroupLocalServiceBaseImpl;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.account.model.AccountGroup"}, service={AopService.class})
public class AccountGroupLocalServiceImpl
extends AccountGroupLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};

    @Indexable(type=IndexableType.REINDEX)
    public AccountGroup addAccountGroup(long userId, String description, String name) throws PortalException {
        long accountGroupId = this.counterLocalService.increment();
        AccountGroup accountGroup = this.accountGroupPersistence.create(accountGroupId);
        User user = this.userLocalService.getUser(userId);
        accountGroup.setCompanyId(user.getCompanyId());
        accountGroup.setUserId(user.getUserId());
        accountGroup.setUserName(user.getFullName());
        accountGroup.setDefaultAccountGroup(false);
        accountGroup.setDescription(description);
        accountGroup.setName(name);
        accountGroup.setType("static");
        return (AccountGroup)this.accountGroupPersistence.update((BaseModel)accountGroup);
    }

    public AccountGroup checkGuestAccountGroup(long companyId) throws PortalException {
        if (this.hasDefaultAccountGroup(companyId)) {
            return this.accountGroupPersistence.findByC_D_First(companyId, true, null);
        }
        AccountGroup accountGroup = this.createAccountGroup(this.counterLocalService.increment());
        accountGroup.setCompanyId(companyId);
        User user = this.userLocalService.getDefaultUser(companyId);
        accountGroup.setUserId(user.getUserId());
        accountGroup.setUserName(user.getFullName());
        accountGroup.setDefaultAccountGroup(true);
        accountGroup.setDescription("This account group is used for guest users.");
        accountGroup.setName("Guest");
        return this.addAccountGroup(accountGroup);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public AccountGroup deleteAccountGroup(AccountGroup accountGroup) {
        this.accountGroupPersistence.remove((BaseModel)accountGroup);
        List accountGroupRels = this.accountGroupRelPersistence.findByAccountGroupId(accountGroup.getAccountGroupId());
        for (AccountGroupRel accountGroupRel : accountGroupRels) {
            this.accountGroupRelPersistence.remove((BaseModel)accountGroupRel);
        }
        return accountGroup;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public AccountGroup deleteAccountGroup(long accountGroupId) throws PortalException {
        return this.deleteAccountGroup(this.accountGroupLocalService.getAccountGroup(accountGroupId));
    }

    public List<AccountGroup> getAccountGroups(long companyId, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return this.accountGroupPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<AccountGroup> getAccountGroupsByAccountGroupId(long[] accountGroupIds) {
        return this.accountGroupPersistence.findByAccountGroupId(accountGroupIds);
    }

    public int getAccountGroupsCount(long companyId) {
        return this.accountGroupPersistence.countByCompanyId(companyId);
    }

    public AccountGroup getDefaultAccountGroup(long companyId) {
        return this.accountGroupPersistence.fetchByC_D_First(companyId, true, null);
    }

    public boolean hasDefaultAccountGroup(long companyId) {
        int count = this.accountGroupPersistence.countByC_D(companyId, true);
        return count > 0;
    }

    public BaseModelSearchResult<AccountGroup> searchAccountGroups(long companyId, String keywords, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        try {
            SearchContext searchContext = this._buildSearchContext(companyId, start, end, orderByComparator);
            searchContext.setKeywords(keywords);
            return this._searchAccountGroups(searchContext);
        }
        catch (PortalException portalException) {
            return (BaseModelSearchResult)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountGroup updateAccountGroup(long accountGroupId, String description, String name) throws PortalException {
        AccountGroup accountGroup = this.accountGroupPersistence.fetchByPrimaryKey(accountGroupId);
        accountGroup.setDescription(description);
        accountGroup.setName(name);
        return (AccountGroup)this.accountGroupPersistence.update((BaseModel)accountGroup);
    }

    private SearchContext _buildSearchContext(long companyId, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        Object[] orderByFields;
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (orderByComparator != null && ArrayUtil.isNotEmpty((Object[])(orderByFields = orderByComparator.getOrderByFields()))) {
            searchContext.setSorts(new Sort[]{SortFactoryUtil.getSort(AccountGroup.class, (String)orderByFields[0], (String)(orderByComparator.isAscending() ? "asc" : "desc"))});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    private BaseModelSearchResult<AccountGroup> _searchAccountGroups(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AccountGroup.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List accountGroups = TransformUtil.transform((Collection)hits.toList(), document -> {
                long accountGroupId = GetterUtil.getLong((String)document.get("entryClassPK"));
                AccountGroup accountGroup = this.accountGroupPersistence.fetchByPrimaryKey(accountGroupId);
                if (accountGroup == null) {
                    long companyId = GetterUtil.getLong((String)document.get("companyId"));
                    indexer.delete(companyId, document.getUID());
                }
                return accountGroup;
            });
            if (accountGroups == null) continue;
            return new BaseModelSearchResult(accountGroups, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }
}

