/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.exception.DuplicateAccountGroupRelException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.account.service.base.AccountGroupRelLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountGroupRel"}, service={AopService.class})
public class AccountGroupRelLocalServiceImpl
extends AccountGroupRelLocalServiceBaseImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;

    public AccountGroupRel addAccountGroupRel(long accountGroupId, String className, long classPK) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        AccountGroupRel accountGroupRel = this.accountGroupRelPersistence.fetchByA_C_C(accountGroupId, classNameId, classPK);
        if (accountGroupRel != null) {
            throw new DuplicateAccountGroupRelException();
        }
        if (Objects.equals(AccountEntry.class.getName(), className) && classPK != 0L) {
            this._accountEntryLocalService.getAccountEntry(classPK);
        }
        accountGroupRel = this.createAccountGroupRel(this.counterLocalService.increment());
        AccountGroup accountGroup = this._accountGroupLocalService.getAccountGroup(accountGroupId);
        User user = GuestOrUserUtil.getGuestOrUser((long)accountGroup.getCompanyId());
        accountGroupRel.setCompanyId(user.getCompanyId());
        accountGroupRel.setUserId(user.getUserId());
        accountGroupRel.setUserName(user.getFullName());
        accountGroupRel.setCreateDate(new Date());
        accountGroupRel.setModifiedDate(new Date());
        accountGroupRel.setAccountGroupId(accountGroupId);
        accountGroupRel.setClassNameId(classNameId);
        accountGroupRel.setClassPK(classPK);
        return this.addAccountGroupRel(accountGroupRel);
    }

    public void addAccountGroupRels(long accountGroupId, String className, long[] classPKs) throws PortalException {
        for (long classPK : classPKs) {
            this.addAccountGroupRel(accountGroupId, className, classPK);
        }
    }

    public void deleteAccountGroupRels(long accountGroupId, String className, long[] classPKs) throws PortalException {
        for (long classPK : classPKs) {
            this.accountGroupRelPersistence.removeByA_C_C(accountGroupId, this._classNameLocalService.getClassNameId(className), classPK);
        }
    }

    public void deleteAccountGroupRels(String className, long[] classPKs) {
        for (long classPK : classPKs) {
            this.accountGroupRelPersistence.removeByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        }
    }

    public void deleteAccountGroupRelsByAccountGroupId(long accountGroupId) {
        this.accountGroupRelPersistence.removeByAccountGroupId(accountGroupId);
    }

    public AccountGroupRel fetchAccountGroupRel(long accountGroupId, String className, long classPK) {
        return this.accountGroupRelPersistence.fetchByA_C_C(accountGroupId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<AccountGroupRel> getAccountGroupRels(String className, long classPK) {
        return this.accountGroupRelPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<AccountGroupRel> getAccountGroupRels(String className, long classPK, int start, int end, OrderByComparator<AccountGroupRel> orderByComparator) {
        return this.accountGroupRelPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public List<AccountGroupRel> getAccountGroupRelsByAccountGroupId(long accountGroupId) {
        return this.accountGroupRelPersistence.findByAccountGroupId(accountGroupId);
    }

    public List<AccountGroupRel> getAccountGroupRelsByAccountGroupId(long accountGroupId, int start, int end, OrderByComparator<AccountGroupRel> orderByComparator) {
        return this.accountGroupRelPersistence.findByAccountGroupId(accountGroupId, start, end, orderByComparator);
    }

    public int getAccountGroupRelsCount(String className, long classPK) {
        return this.accountGroupRelPersistence.countByC_C(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public long getAccountGroupRelsCountByAccountGroupId(long accountGroupId) {
        return this.accountGroupRelPersistence.countByAccountGroupId(accountGroupId);
    }
}

