/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.base.AccountRoleLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.account.model.AccountRole"}, service={AopService.class})
public class AccountRoleLocalServiceImpl
extends AccountRoleLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountRoleLocalServiceImpl.class);
    private static final Map<String, Map<Locale, String>> _roleDescriptionsMaps = HashMapBuilder.put((Object)"Account Administrator", Collections.singletonMap(LocaleUtil.US, "Account Administrators are super users of their account.")).put((Object)"Account Manager", Collections.singletonMap(LocaleUtil.US, "Account Managers who belong to an organization can administer all accounts associated to that organization.")).put((Object)"Account Member", Collections.singletonMap(LocaleUtil.US, "All users who belong to an account have this role within that account.")).build();

    public AccountRole addAccountRole(long userId, long accountEntryId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) throws PortalException {
        Role role = this.roleLocalService.addRole(userId, AccountRole.class.getName(), 0L, name, titleMap, descriptionMap, 6, null, null);
        AccountRole accountRole = this.fetchAccountRoleByRoleId(role.getRoleId());
        if (accountRole != null) {
            accountRole.setAccountEntryId(accountEntryId);
            return this.updateAccountRole(accountRole);
        }
        accountRole = this.createAccountRole(this.counterLocalService.increment());
        accountRole.setCompanyId(role.getCompanyId());
        accountRole.setAccountEntryId(accountEntryId);
        accountRole.setRoleId(role.getRoleId());
        role.setClassPK(accountRole.getAccountRoleId());
        this.roleLocalService.updateRole(role);
        return this.addAccountRole(accountRole);
    }

    public void associateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
        AccountRole accountRole = this.getAccountRole(accountRoleId);
        this.userGroupRoleLocalService.addUserGroupRoles(userId, accountEntry.getAccountEntryGroupId(), new long[]{accountRole.getRoleId()});
    }

    public void associateUser(long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        for (long accountRoleId : accountRoleIds) {
            this.associateUser(accountEntryId, accountRoleId, userId);
        }
    }

    public void checkCompanyAccountRoles(long companyId) throws PortalException {
        Company company = this.companyLocalService.getCompany(companyId);
        this._checkAccountRole(company, "Account Member");
        this._checkAccountRole(company, "Account Administrator");
        Role role = this.roleLocalService.fetchRole(companyId, "Account Manager");
        if (role == null) {
            User defaultUser = company.getDefaultUser();
            this.roleLocalService.addRole(defaultUser.getUserId(), null, 0L, "Account Manager", null, _roleDescriptionsMaps.get("Account Manager"), 3, null, null);
        }
    }

    @Override
    public AccountRole deleteAccountRole(AccountRole accountRole) throws PortalException {
        Role role = this.roleLocalService.fetchRole((accountRole = super.deleteAccountRole(accountRole)).getRoleId());
        if (role != null) {
            this.userGroupRoleLocalService.deleteUserGroupRolesByRoleId(accountRole.getRoleId());
            this.roleLocalService.deleteRole(accountRole.getRoleId());
        }
        return accountRole;
    }

    @Override
    public AccountRole deleteAccountRole(long accountRoleId) throws PortalException {
        return this.deleteAccountRole(this.getAccountRole(accountRoleId));
    }

    public void deleteAccountRolesByCompanyId(long companyId) {
        if (!CompanyThreadLocal.isDeleteInProcess()) {
            throw new UnsupportedOperationException("Deleting account roles by company must be called when deleting a company");
        }
        for (AccountRole accountRole : this.accountRolePersistence.findByCompanyId(companyId)) {
            this.accountRolePersistence.remove((BaseModel)accountRole);
            this.userGroupRoleLocalService.deleteUserGroupRolesByRoleId(accountRole.getRoleId());
        }
    }

    public AccountRole fetchAccountRoleByRoleId(long roleId) {
        return this.accountRolePersistence.fetchByRoleId(roleId);
    }

    public AccountRole getAccountRoleByRoleId(long roleId) throws PortalException {
        return this.accountRolePersistence.findByRoleId(roleId);
    }

    public List<AccountRole> getAccountRoles(long accountEntryId, long userId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
        List userGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId, accountEntry.getAccountEntryGroupId());
        return TransformUtil.transform((Collection)ListUtil.filter((List)userGroupRoles, userGroupRole -> {
            try {
                Role role = userGroupRole.getRole();
                return role.getType() == 6;
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
                return false;
            }
        }), userGroupRole -> this.getAccountRoleByRoleId(userGroupRole.getRoleId()));
    }

    public List<AccountRole> getAccountRolesByAccountEntryIds(long[] accountEntryIds) {
        return this.accountRolePersistence.findByAccountEntryId(accountEntryIds);
    }

    public boolean hasUserAccountRole(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
        AccountRole accountRole = this.getAccountRole(accountRoleId);
        return this.userGroupRoleLocalService.hasUserGroupRole(userId, accountEntry.getAccountEntryGroupId(), accountRole.getRoleId());
    }

    public BaseModelSearchResult<AccountRole> searchAccountRoles(long companyId, long accountEntryId, String keywords, int start, int end, OrderByComparator<?> orderByComparator) {
        return this.searchAccountRoles(companyId, new long[]{accountEntryId}, keywords, start, end, orderByComparator);
    }

    public BaseModelSearchResult<AccountRole> searchAccountRoles(long companyId, long[] accountEntryIds, String keywords, int start, int end, OrderByComparator<?> orderByComparator) {
        DynamicQuery roleDynamicQuery = this._getRoleDynamicQuery(companyId, accountEntryIds, keywords, orderByComparator);
        if (roleDynamicQuery == null) {
            return new BaseModelSearchResult(Collections.emptyList(), 0);
        }
        List accountRoles = TransformUtil.transform((Collection)this.roleLocalService.dynamicQuery(roleDynamicQuery, start, end), userGroupRole -> this.getAccountRoleByRoleId(userGroupRole.getRoleId()));
        return new BaseModelSearchResult(accountRoles, (int)this.roleLocalService.dynamicQueryCount(this._getRoleDynamicQuery(companyId, accountEntryIds, keywords, null)));
    }

    @Deprecated
    public BaseModelSearchResult<AccountRole> searchAccountRoles(long accountEntryId, String keywords, int start, int end, OrderByComparator<?> orderByComparator) {
        return this.searchAccountRoles((long)CompanyThreadLocal.getCompanyId(), new long[]{accountEntryId}, keywords, start, end, orderByComparator);
    }

    @Deprecated
    public BaseModelSearchResult<AccountRole> searchAccountRoles(long[] accountEntryIds, String keywords, int start, int end, OrderByComparator<?> orderByComparator) {
        return this.searchAccountRoles((long)CompanyThreadLocal.getCompanyId(), accountEntryIds, keywords, start, end, orderByComparator);
    }

    public void unassociateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
        AccountRole accountRole = this.getAccountRole(accountRoleId);
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, accountEntry.getAccountEntryGroupId(), new long[]{accountRole.getRoleId()});
    }

    private void _checkAccountRole(Company company, String roleName) throws PortalException {
        Role role = this.roleLocalService.fetchRole(company.getCompanyId(), roleName);
        if (role != null) {
            if (MapUtil.isEmpty((Map)role.getDescriptionMap())) {
                role.setDescriptionMap(_roleDescriptionsMaps.get(role.getName()));
                this.roleLocalService.updateRole(role);
            }
            return;
        }
        User defaultUser = company.getDefaultUser();
        this.addAccountRole(defaultUser.getUserId(), 0L, roleName, null, _roleDescriptionsMaps.get(roleName));
    }

    private DynamicQuery _getRoleDynamicQuery(long companyId, long[] accountEntryIds, String keywords, OrderByComparator<?> orderByComparator) {
        DynamicQuery accountRoleDynamicQuery = this.accountRoleLocalService.dynamicQuery();
        accountRoleDynamicQuery.add(RestrictionsFactoryUtil.in((String)"accountEntryId", (Collection)ListUtil.fromArray((long[])accountEntryIds)));
        accountRoleDynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)companyId));
        accountRoleDynamicQuery.setProjection(ProjectionFactoryUtil.property((String)"roleId"));
        List roleIds = this.accountRoleLocalService.dynamicQuery(accountRoleDynamicQuery);
        if (roleIds.isEmpty()) {
            return null;
        }
        DynamicQuery roleDynamicQuery = this.roleLocalService.dynamicQuery();
        roleDynamicQuery.add(RestrictionsFactoryUtil.in((String)"roleId", (Collection)roleIds));
        if (Validator.isNotNull((String)keywords)) {
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"name", (Object)StringUtil.quote((String)keywords, (String)"%")));
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"description", (Object)StringUtil.quote((String)keywords, (String)"%")));
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"title", (Object)StringUtil.quote((String)keywords, (String)"%")));
            roleDynamicQuery.add((Criterion)disjunction);
        }
        OrderFactoryUtil.addOrderByComparator((DynamicQuery)roleDynamicQuery, orderByComparator);
        return roleDynamicQuery;
    }
}

