/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.persistence.impl;

import com.liferay.account.exception.NoSuchGroupException;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupTable;
import com.liferay.account.model.impl.AccountGroupImpl;
import com.liferay.account.model.impl.AccountGroupModelImpl;
import com.liferay.account.service.persistence.AccountGroupPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AccountGroupPersistence.class, BasePersistence.class})
public class AccountGroupPersistenceImpl
extends BasePersistenceImpl<AccountGroup>
implements AccountGroupPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AccountGroupImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByAccountGroupId;
    private FinderPath _finderPathWithoutPaginationFindByAccountGroupId;
    private FinderPath _finderPathCountByAccountGroupId;
    private FinderPath _finderPathWithPaginationCountByAccountGroupId;
    private static final String _FINDER_COLUMN_ACCOUNTGROUPID_ACCOUNTGROUPID_2 = "accountGroup.accountGroupId = ?";
    private static final String _FINDER_COLUMN_ACCOUNTGROUPID_ACCOUNTGROUPID_7 = "accountGroup.accountGroupId IN (";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "accountGroup.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByC_D;
    private FinderPath _finderPathWithoutPaginationFindByC_D;
    private FinderPath _finderPathCountByC_D;
    private static final String _FINDER_COLUMN_C_D_COMPANYID_2 = "accountGroup.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_D_DEFAULTACCOUNTGROUP_2 = "accountGroup.defaultAccountGroup = ?";
    private FinderPath _finderPathWithPaginationFindByC_T;
    private FinderPath _finderPathWithoutPaginationFindByC_T;
    private FinderPath _finderPathCountByC_T;
    private static final String _FINDER_COLUMN_C_T_COMPANYID_2 = "accountGroup.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_T_TYPE_2 = "accountGroup.type = ?";
    private static final String _FINDER_COLUMN_C_T_TYPE_3 = "(accountGroup.type IS NULL OR accountGroup.type = '')";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "accountGroup.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "accountGroup.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(accountGroup.externalReferenceCode IS NULL OR accountGroup.externalReferenceCode = '')";
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ACCOUNTGROUP = "SELECT accountGroup FROM AccountGroup accountGroup";
    private static final String _SQL_SELECT_ACCOUNTGROUP_WHERE = "SELECT accountGroup FROM AccountGroup accountGroup WHERE ";
    private static final String _SQL_COUNT_ACCOUNTGROUP = "SELECT COUNT(accountGroup) FROM AccountGroup accountGroup";
    private static final String _SQL_COUNT_ACCOUNTGROUP_WHERE = "SELECT COUNT(accountGroup) FROM AccountGroup accountGroup WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "accountGroup.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No AccountGroup exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No AccountGroup exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AccountGroupPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"type"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<AccountGroup> findByAccountGroupId(long accountGroupId) {
        return this.findByAccountGroupId(accountGroupId, -1, -1, null);
    }

    public List<AccountGroup> findByAccountGroupId(long accountGroupId, int start, int end) {
        return this.findByAccountGroupId(accountGroupId, start, end, null);
    }

    public List<AccountGroup> findByAccountGroupId(long accountGroupId, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return this.findByAccountGroupId(accountGroupId, start, end, orderByComparator, true);
    }

    public List<AccountGroup> findByAccountGroupId(long accountGroupId, int start, int end, OrderByComparator<AccountGroup> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByAccountGroupId;
                finderArgs = new Object[]{accountGroupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByAccountGroupId;
            finderArgs = new Object[]{accountGroupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (AccountGroup accountGroup : list) {
                if (accountGroupId == accountGroup.getAccountGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
            sb.append(_FINDER_COLUMN_ACCOUNTGROUPID_ACCOUNTGROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY accountGroup.accountGroupId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accountGroupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AccountGroup findByAccountGroupId_First(long accountGroupId, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByAccountGroupId_First(accountGroupId, orderByComparator);
        if (accountGroup != null) {
            return accountGroup;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("accountGroupId=");
        sb.append(accountGroupId);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public AccountGroup fetchByAccountGroupId_First(long accountGroupId, OrderByComparator<AccountGroup> orderByComparator) {
        List<AccountGroup> list = this.findByAccountGroupId(accountGroupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountGroup findByAccountGroupId_Last(long accountGroupId, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByAccountGroupId_Last(accountGroupId, orderByComparator);
        if (accountGroup != null) {
            return accountGroup;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("accountGroupId=");
        sb.append(accountGroupId);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public AccountGroup fetchByAccountGroupId_Last(long accountGroupId, OrderByComparator<AccountGroup> orderByComparator) {
        int count = this.countByAccountGroupId(accountGroupId);
        if (count == 0) {
            return null;
        }
        List<AccountGroup> list = this.findByAccountGroupId(accountGroupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<AccountGroup> findByAccountGroupId(long[] accountGroupIds) {
        return this.findByAccountGroupId(accountGroupIds, -1, -1, null);
    }

    public List<AccountGroup> findByAccountGroupId(long[] accountGroupIds, int start, int end) {
        return this.findByAccountGroupId(accountGroupIds, start, end, null);
    }

    public List<AccountGroup> findByAccountGroupId(long[] accountGroupIds, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return this.findByAccountGroupId(accountGroupIds, start, end, orderByComparator, true);
    }

    public List<AccountGroup> findByAccountGroupId(long[] accountGroupIds, int start, int end, OrderByComparator<AccountGroup> orderByComparator, boolean useFinderCache) {
        if (accountGroupIds == null) {
            accountGroupIds = new long[]{};
        } else if (accountGroupIds.length > 1) {
            accountGroupIds = ArrayUtil.sortedUnique((long[])accountGroupIds);
        }
        if (accountGroupIds.length == 1) {
            return this.findByAccountGroupId(accountGroupIds[0], start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{StringUtil.merge((long[])accountGroupIds)};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{StringUtil.merge((long[])accountGroupIds), start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByAccountGroupId, finderArgs)) != null && !list.isEmpty()) {
            for (AccountGroup accountGroup : list) {
                if (ArrayUtil.contains((long[])accountGroupIds, (long)accountGroup.getAccountGroupId())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
            if (accountGroupIds.length > 0) {
                sb.append("(");
                sb.append(_FINDER_COLUMN_ACCOUNTGROUPID_ACCOUNTGROUPID_7);
                sb.append(StringUtil.merge((long[])accountGroupIds));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(AccountGroupPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY accountGroup.accountGroupId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByAccountGroupId, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByAccountGroupId(long accountGroupId) {
        for (AccountGroup accountGroup : this.findByAccountGroupId(accountGroupId, -1, -1, null)) {
            this.remove((BaseModel)accountGroup);
        }
    }

    public int countByAccountGroupId(long accountGroupId) {
        FinderPath finderPath = this._finderPathCountByAccountGroupId;
        Object[] finderArgs = new Object[]{accountGroupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ACCOUNTGROUP_WHERE);
            sb.append(_FINDER_COLUMN_ACCOUNTGROUPID_ACCOUNTGROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accountGroupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByAccountGroupId(long[] accountGroupIds) {
        if (accountGroupIds == null) {
            accountGroupIds = new long[]{};
        } else if (accountGroupIds.length > 1) {
            accountGroupIds = ArrayUtil.sortedUnique((long[])accountGroupIds);
        }
        Object[] finderArgs = new Object[]{StringUtil.merge((long[])accountGroupIds)};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByAccountGroupId, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_ACCOUNTGROUP_WHERE);
            if (accountGroupIds.length > 0) {
                sb.append("(");
                sb.append(_FINDER_COLUMN_ACCOUNTGROUPID_ACCOUNTGROUPID_7);
                sb.append(StringUtil.merge((long[])accountGroupIds));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(AccountGroupPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByAccountGroupId, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<AccountGroup> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<AccountGroup> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<AccountGroup> findByCompanyId(long companyId, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<AccountGroup> findByCompanyId(long companyId, int start, int end, OrderByComparator<AccountGroup> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (AccountGroup accountGroup : list) {
                if (companyId == accountGroup.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY accountGroup.accountGroupId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AccountGroup findByCompanyId_First(long companyId, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (accountGroup != null) {
            return accountGroup;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public AccountGroup fetchByCompanyId_First(long companyId, OrderByComparator<AccountGroup> orderByComparator) {
        List<AccountGroup> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountGroup findByCompanyId_Last(long companyId, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (accountGroup != null) {
            return accountGroup;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public AccountGroup fetchByCompanyId_Last(long companyId, OrderByComparator<AccountGroup> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<AccountGroup> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountGroup[] findByCompanyId_PrevAndNext(long accountGroupId, long companyId, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.findByPrimaryKey(accountGroupId);
        Session session = null;
        try {
            session = this.openSession();
            AccountGroup[] array = new AccountGroupImpl[]{this.getByCompanyId_PrevAndNext(session, accountGroup, companyId, orderByComparator, true), accountGroup, this.getByCompanyId_PrevAndNext(session, accountGroup, companyId, orderByComparator, false)};
            AccountGroup[] accountGroupArray = array;
            return accountGroupArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AccountGroup getByCompanyId_PrevAndNext(Session session, AccountGroup accountGroup, long companyId, OrderByComparator<AccountGroup> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY accountGroup.accountGroupId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)accountGroup)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AccountGroup)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (AccountGroup accountGroup : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)accountGroup);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ACCOUNTGROUP_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<AccountGroup> findByC_D(long companyId, boolean defaultAccountGroup) {
        return this.findByC_D(companyId, defaultAccountGroup, -1, -1, null);
    }

    public List<AccountGroup> findByC_D(long companyId, boolean defaultAccountGroup, int start, int end) {
        return this.findByC_D(companyId, defaultAccountGroup, start, end, null);
    }

    public List<AccountGroup> findByC_D(long companyId, boolean defaultAccountGroup, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return this.findByC_D(companyId, defaultAccountGroup, start, end, orderByComparator, true);
    }

    public List<AccountGroup> findByC_D(long companyId, boolean defaultAccountGroup, int start, int end, OrderByComparator<AccountGroup> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_D;
                finderArgs = new Object[]{companyId, defaultAccountGroup};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_D;
            finderArgs = new Object[]{companyId, defaultAccountGroup, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (AccountGroup accountGroup : list) {
                if (companyId == accountGroup.getCompanyId() && defaultAccountGroup == accountGroup.isDefaultAccountGroup()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
            sb.append("accountGroup.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_D_DEFAULTACCOUNTGROUP_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY accountGroup.accountGroupId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(defaultAccountGroup);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AccountGroup findByC_D_First(long companyId, boolean defaultAccountGroup, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByC_D_First(companyId, defaultAccountGroup, orderByComparator);
        if (accountGroup != null) {
            return accountGroup;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", defaultAccountGroup=");
        sb.append(defaultAccountGroup);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public AccountGroup fetchByC_D_First(long companyId, boolean defaultAccountGroup, OrderByComparator<AccountGroup> orderByComparator) {
        List<AccountGroup> list = this.findByC_D(companyId, defaultAccountGroup, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountGroup findByC_D_Last(long companyId, boolean defaultAccountGroup, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByC_D_Last(companyId, defaultAccountGroup, orderByComparator);
        if (accountGroup != null) {
            return accountGroup;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", defaultAccountGroup=");
        sb.append(defaultAccountGroup);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public AccountGroup fetchByC_D_Last(long companyId, boolean defaultAccountGroup, OrderByComparator<AccountGroup> orderByComparator) {
        int count = this.countByC_D(companyId, defaultAccountGroup);
        if (count == 0) {
            return null;
        }
        List<AccountGroup> list = this.findByC_D(companyId, defaultAccountGroup, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountGroup[] findByC_D_PrevAndNext(long accountGroupId, long companyId, boolean defaultAccountGroup, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.findByPrimaryKey(accountGroupId);
        Session session = null;
        try {
            session = this.openSession();
            AccountGroup[] array = new AccountGroupImpl[]{this.getByC_D_PrevAndNext(session, accountGroup, companyId, defaultAccountGroup, orderByComparator, true), accountGroup, this.getByC_D_PrevAndNext(session, accountGroup, companyId, defaultAccountGroup, orderByComparator, false)};
            AccountGroup[] accountGroupArray = array;
            return accountGroupArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AccountGroup getByC_D_PrevAndNext(Session session, AccountGroup accountGroup, long companyId, boolean defaultAccountGroup, OrderByComparator<AccountGroup> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
        sb.append("accountGroup.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_D_DEFAULTACCOUNTGROUP_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY accountGroup.accountGroupId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(defaultAccountGroup);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)accountGroup)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AccountGroup)list.get(1);
        }
        return null;
    }

    public void removeByC_D(long companyId, boolean defaultAccountGroup) {
        for (AccountGroup accountGroup : this.findByC_D(companyId, defaultAccountGroup, -1, -1, null)) {
            this.remove((BaseModel)accountGroup);
        }
    }

    public int countByC_D(long companyId, boolean defaultAccountGroup) {
        FinderPath finderPath = this._finderPathCountByC_D;
        Object[] finderArgs = new Object[]{companyId, defaultAccountGroup};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_ACCOUNTGROUP_WHERE);
            sb.append("accountGroup.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_D_DEFAULTACCOUNTGROUP_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(defaultAccountGroup);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<AccountGroup> findByC_T(long companyId, String type) {
        return this.findByC_T(companyId, type, -1, -1, null);
    }

    public List<AccountGroup> findByC_T(long companyId, String type, int start, int end) {
        return this.findByC_T(companyId, type, start, end, null);
    }

    public List<AccountGroup> findByC_T(long companyId, String type, int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return this.findByC_T(companyId, type, start, end, orderByComparator, true);
    }

    public List<AccountGroup> findByC_T(long companyId, String type, int start, int end, OrderByComparator<AccountGroup> orderByComparator, boolean useFinderCache) {
        type = Objects.toString(type, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_T;
                finderArgs = new Object[]{companyId, type};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_T;
            finderArgs = new Object[]{companyId, type, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (AccountGroup accountGroup : list) {
                if (companyId == accountGroup.getCompanyId() && type.equals(accountGroup.getType())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
            sb.append("accountGroup.companyId = ? AND ");
            boolean bindType = false;
            if (type.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_T_TYPE_3);
            } else {
                bindType = true;
                sb.append(_FINDER_COLUMN_C_T_TYPE_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY accountGroup.accountGroupId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindType) {
                    queryPos.add(type);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AccountGroup findByC_T_First(long companyId, String type, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByC_T_First(companyId, type, orderByComparator);
        if (accountGroup != null) {
            return accountGroup;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", type=");
        sb.append(type);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public AccountGroup fetchByC_T_First(long companyId, String type, OrderByComparator<AccountGroup> orderByComparator) {
        List<AccountGroup> list = this.findByC_T(companyId, type, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountGroup findByC_T_Last(long companyId, String type, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByC_T_Last(companyId, type, orderByComparator);
        if (accountGroup != null) {
            return accountGroup;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", type=");
        sb.append(type);
        sb.append("}");
        throw new NoSuchGroupException(sb.toString());
    }

    public AccountGroup fetchByC_T_Last(long companyId, String type, OrderByComparator<AccountGroup> orderByComparator) {
        int count = this.countByC_T(companyId, type);
        if (count == 0) {
            return null;
        }
        List<AccountGroup> list = this.findByC_T(companyId, type, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountGroup[] findByC_T_PrevAndNext(long accountGroupId, long companyId, String type, OrderByComparator<AccountGroup> orderByComparator) throws NoSuchGroupException {
        type = Objects.toString(type, "");
        AccountGroup accountGroup = this.findByPrimaryKey(accountGroupId);
        Session session = null;
        try {
            session = this.openSession();
            AccountGroup[] array = new AccountGroupImpl[]{this.getByC_T_PrevAndNext(session, accountGroup, companyId, type, orderByComparator, true), accountGroup, this.getByC_T_PrevAndNext(session, accountGroup, companyId, type, orderByComparator, false)};
            AccountGroup[] accountGroupArray = array;
            return accountGroupArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AccountGroup getByC_T_PrevAndNext(Session session, AccountGroup accountGroup, long companyId, String type, OrderByComparator<AccountGroup> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
        sb.append("accountGroup.companyId = ? AND ");
        boolean bindType = false;
        if (type.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_T_TYPE_3);
        } else {
            bindType = true;
            sb.append(_FINDER_COLUMN_C_T_TYPE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY accountGroup.accountGroupId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindType) {
            queryPos.add(type);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)accountGroup)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AccountGroup)list.get(1);
        }
        return null;
    }

    public void removeByC_T(long companyId, String type) {
        for (AccountGroup accountGroup : this.findByC_T(companyId, type, -1, -1, null)) {
            this.remove((BaseModel)accountGroup);
        }
    }

    public int countByC_T(long companyId, String type) {
        type = Objects.toString(type, "");
        FinderPath finderPath = this._finderPathCountByC_T;
        Object[] finderArgs = new Object[]{companyId, type};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_ACCOUNTGROUP_WHERE);
            sb.append("accountGroup.companyId = ? AND ");
            boolean bindType = false;
            if (type.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_T_TYPE_3);
            } else {
                bindType = true;
                sb.append(_FINDER_COLUMN_C_T_TYPE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindType) {
                    queryPos.add(type);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AccountGroup findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchGroupException {
        AccountGroup accountGroup = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (accountGroup == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchGroupException(sb.toString());
        }
        return accountGroup;
    }

    public AccountGroup fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    public AccountGroup fetchByC_ERC(long companyId, String externalReferenceCode, boolean useFinderCache) {
        AccountGroup accountGroup;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_ERC, finderArgs);
        }
        if (result instanceof AccountGroup && (companyId != (accountGroup = (AccountGroup)result).getCompanyId() || !Objects.equals(externalReferenceCode, accountGroup.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_ACCOUNTGROUP_WHERE);
            sb.append("accountGroup.companyId = ? AND ");
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("AccountGroupPersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    AccountGroup accountGroup2 = (AccountGroup)list.get(0);
                    result = accountGroup2;
                    this.cacheResult(accountGroup2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (AccountGroup)result;
    }

    public AccountGroup removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchGroupException {
        AccountGroup accountGroup = this.findByC_ERC(companyId, externalReferenceCode);
        return (AccountGroup)this.remove((BaseModel)accountGroup);
    }

    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_ACCOUNTGROUP_WHERE);
            sb.append("accountGroup.companyId = ? AND ");
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AccountGroupPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(AccountGroup.class);
        this.setModelImplClass(AccountGroupImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)AccountGroupTable.INSTANCE);
    }

    public void cacheResult(AccountGroup accountGroup) {
        this.entityCache.putResult(AccountGroupImpl.class, (Serializable)Long.valueOf(accountGroup.getPrimaryKey()), (Serializable)accountGroup);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, new Object[]{accountGroup.getCompanyId(), accountGroup.getExternalReferenceCode()}, (Object)accountGroup);
    }

    public void cacheResult(List<AccountGroup> accountGroups) {
        for (AccountGroup accountGroup : accountGroups) {
            if (this.entityCache.getResult(AccountGroupImpl.class, (Serializable)Long.valueOf(accountGroup.getPrimaryKey())) != null) continue;
            this.cacheResult(accountGroup);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AccountGroupImpl.class);
        this.finderCache.clearCache(AccountGroupImpl.class);
    }

    public void clearCache(AccountGroup accountGroup) {
        this.entityCache.removeResult(AccountGroupImpl.class, (BaseModel)accountGroup);
    }

    public void clearCache(List<AccountGroup> accountGroups) {
        for (AccountGroup accountGroup : accountGroups) {
            this.entityCache.removeResult(AccountGroupImpl.class, (BaseModel)accountGroup);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(AccountGroupImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(AccountGroupImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(AccountGroupModelImpl accountGroupModelImpl) {
        Object[] args = new Object[]{accountGroupModelImpl.getCompanyId(), accountGroupModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByC_ERC, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, args, (Object)accountGroupModelImpl);
    }

    public AccountGroup create(long accountGroupId) {
        AccountGroupImpl accountGroup = new AccountGroupImpl();
        accountGroup.setNew(true);
        accountGroup.setPrimaryKey(accountGroupId);
        accountGroup.setCompanyId(CompanyThreadLocal.getCompanyId());
        return accountGroup;
    }

    public AccountGroup remove(long accountGroupId) throws NoSuchGroupException {
        return this.remove(Long.valueOf(accountGroupId));
    }

    public AccountGroup remove(Serializable primaryKey) throws NoSuchGroupException {
        Session session = null;
        try {
            session = this.openSession();
            AccountGroup accountGroup = (AccountGroup)session.get(AccountGroupImpl.class, primaryKey);
            if (accountGroup == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchGroupException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            AccountGroup accountGroup2 = (AccountGroup)this.remove((BaseModel)accountGroup);
            return accountGroup2;
        }
        catch (NoSuchGroupException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AccountGroup removeImpl(AccountGroup accountGroup) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)accountGroup)) {
                accountGroup = (AccountGroup)session.get(AccountGroupImpl.class, accountGroup.getPrimaryKeyObj());
            }
            if (accountGroup != null) {
                session.delete((Object)accountGroup);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (accountGroup != null) {
            this.clearCache(accountGroup);
        }
        return accountGroup;
    }

    public AccountGroup updateImpl(AccountGroup accountGroup) {
        boolean isNew = accountGroup.isNew();
        if (!(accountGroup instanceof AccountGroupModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(accountGroup.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)accountGroup);
                throw new IllegalArgumentException("Implement ModelWrapper in accountGroup proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom AccountGroup implementation " + accountGroup.getClass());
        }
        AccountGroupModelImpl accountGroupModelImpl = (AccountGroupModelImpl)accountGroup;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && accountGroup.getCreateDate() == null) {
            if (serviceContext == null) {
                accountGroup.setCreateDate(date);
            } else {
                accountGroup.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!accountGroupModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                accountGroup.setModifiedDate(date);
            } else {
                accountGroup.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)accountGroup);
            } else {
                accountGroup = (AccountGroup)session.merge((Object)accountGroup);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(AccountGroupImpl.class, (BaseModel)accountGroupModelImpl, false, true);
        this.cacheUniqueFindersCache(accountGroupModelImpl);
        if (isNew) {
            accountGroup.setNew(false);
        }
        accountGroup.resetOriginalValues();
        return accountGroup;
    }

    public AccountGroup findByPrimaryKey(Serializable primaryKey) throws NoSuchGroupException {
        AccountGroup accountGroup = (AccountGroup)this.fetchByPrimaryKey(primaryKey);
        if (accountGroup == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchGroupException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return accountGroup;
    }

    public AccountGroup findByPrimaryKey(long accountGroupId) throws NoSuchGroupException {
        return this.findByPrimaryKey(Long.valueOf(accountGroupId));
    }

    public AccountGroup fetchByPrimaryKey(long accountGroupId) {
        return (AccountGroup)this.fetchByPrimaryKey(Long.valueOf(accountGroupId));
    }

    public List<AccountGroup> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<AccountGroup> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<AccountGroup> findAll(int start, int end, OrderByComparator<AccountGroup> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<AccountGroup> findAll(int start, int end, OrderByComparator<AccountGroup> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ACCOUNTGROUP);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ACCOUNTGROUP;
                sql = sql.concat(" ORDER BY accountGroup.accountGroupId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (AccountGroup accountGroup : this.findAll()) {
            this.remove((BaseModel)accountGroup);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ACCOUNTGROUP);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "accountGroupId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ACCOUNTGROUP;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AccountGroupModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new AccountGroupModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByAccountGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByAccountGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"accountGroupId"}, true);
        this._finderPathWithoutPaginationFindByAccountGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByAccountGroupId", new String[]{Long.class.getName()}, new String[]{"accountGroupId"}, true);
        this._finderPathCountByAccountGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByAccountGroupId", new String[]{Long.class.getName()}, new String[]{"accountGroupId"}, false);
        this._finderPathWithPaginationCountByAccountGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByAccountGroupId", new String[]{Long.class.getName()}, new String[]{"accountGroupId"}, false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByC_D = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_D", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "defaultAccountGroup"}, true);
        this._finderPathWithoutPaginationFindByC_D = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_D", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "defaultAccountGroup"}, true);
        this._finderPathCountByC_D = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_D", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "defaultAccountGroup"}, false);
        this._finderPathWithPaginationFindByC_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_T", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "type_"}, true);
        this._finderPathWithoutPaginationFindByC_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_T", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "type_"}, true);
        this._finderPathCountByC_T = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_T", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "type_"}, false);
        this._finderPathFetchByC_ERC = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, true);
        this._finderPathCountByC_ERC = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(AccountGroupImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.account.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.account.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.account.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class AccountGroupModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private AccountGroupModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            AccountGroupModelImpl accountGroupModelImpl = (AccountGroupModelImpl)baseModel;
            long columnBitmask = accountGroupModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return AccountGroupModelArgumentsResolver._getValue(accountGroupModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | AccountGroupModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return AccountGroupModelArgumentsResolver._getValue(accountGroupModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return AccountGroupImpl.class.getName();
        }

        public String getTableName() {
            return AccountGroupTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(AccountGroupModelImpl accountGroupModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? accountGroupModelImpl.getColumnOriginalValue(columnName) : accountGroupModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

