/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.persistence.impl;

import com.liferay.account.exception.NoSuchRoleException;
import com.liferay.account.model.AccountRole;
import com.liferay.account.model.AccountRoleTable;
import com.liferay.account.model.impl.AccountRoleImpl;
import com.liferay.account.model.impl.AccountRoleModelImpl;
import com.liferay.account.service.persistence.AccountRolePersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AccountRolePersistence.class, BasePersistence.class})
public class AccountRolePersistenceImpl
extends BasePersistenceImpl<AccountRole>
implements AccountRolePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AccountRoleImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "accountRole.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByAccountEntryId;
    private FinderPath _finderPathWithoutPaginationFindByAccountEntryId;
    private FinderPath _finderPathCountByAccountEntryId;
    private FinderPath _finderPathWithPaginationCountByAccountEntryId;
    private static final String _FINDER_COLUMN_ACCOUNTENTRYID_ACCOUNTENTRYID_2 = "accountRole.accountEntryId = ?";
    private static final String _FINDER_COLUMN_ACCOUNTENTRYID_ACCOUNTENTRYID_7 = "accountRole.accountEntryId IN (";
    private FinderPath _finderPathFetchByRoleId;
    private FinderPath _finderPathCountByRoleId;
    private static final String _FINDER_COLUMN_ROLEID_ROLEID_2 = "accountRole.roleId = ?";
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ACCOUNTROLE = "SELECT accountRole FROM AccountRole accountRole";
    private static final String _SQL_SELECT_ACCOUNTROLE_WHERE = "SELECT accountRole FROM AccountRole accountRole WHERE ";
    private static final String _SQL_COUNT_ACCOUNTROLE = "SELECT COUNT(accountRole) FROM AccountRole accountRole";
    private static final String _SQL_COUNT_ACCOUNTROLE_WHERE = "SELECT COUNT(accountRole) FROM AccountRole accountRole WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "accountRole.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No AccountRole exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No AccountRole exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AccountRolePersistenceImpl.class);
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<AccountRole> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<AccountRole> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<AccountRole> findByCompanyId(long companyId, int start, int end, OrderByComparator<AccountRole> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<AccountRole> findByCompanyId(long companyId, int start, int end, OrderByComparator<AccountRole> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (AccountRole accountRole : list) {
                if (companyId == accountRole.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_ACCOUNTROLE_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY accountRole.accountRoleId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AccountRole findByCompanyId_First(long companyId, OrderByComparator<AccountRole> orderByComparator) throws NoSuchRoleException {
        AccountRole accountRole = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (accountRole != null) {
            return accountRole;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchRoleException(sb.toString());
    }

    public AccountRole fetchByCompanyId_First(long companyId, OrderByComparator<AccountRole> orderByComparator) {
        List<AccountRole> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountRole findByCompanyId_Last(long companyId, OrderByComparator<AccountRole> orderByComparator) throws NoSuchRoleException {
        AccountRole accountRole = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (accountRole != null) {
            return accountRole;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchRoleException(sb.toString());
    }

    public AccountRole fetchByCompanyId_Last(long companyId, OrderByComparator<AccountRole> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<AccountRole> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountRole[] findByCompanyId_PrevAndNext(long accountRoleId, long companyId, OrderByComparator<AccountRole> orderByComparator) throws NoSuchRoleException {
        AccountRole accountRole = this.findByPrimaryKey(accountRoleId);
        Session session = null;
        try {
            session = this.openSession();
            AccountRole[] array = new AccountRoleImpl[]{this.getByCompanyId_PrevAndNext(session, accountRole, companyId, orderByComparator, true), accountRole, this.getByCompanyId_PrevAndNext(session, accountRole, companyId, orderByComparator, false)};
            AccountRole[] accountRoleArray = array;
            return accountRoleArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AccountRole getByCompanyId_PrevAndNext(Session session, AccountRole accountRole, long companyId, OrderByComparator<AccountRole> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_ACCOUNTROLE_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY accountRole.accountRoleId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)accountRole)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AccountRole)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (AccountRole accountRole : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)accountRole);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ACCOUNTROLE_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<AccountRole> findByAccountEntryId(long accountEntryId) {
        return this.findByAccountEntryId(accountEntryId, -1, -1, null);
    }

    public List<AccountRole> findByAccountEntryId(long accountEntryId, int start, int end) {
        return this.findByAccountEntryId(accountEntryId, start, end, null);
    }

    public List<AccountRole> findByAccountEntryId(long accountEntryId, int start, int end, OrderByComparator<AccountRole> orderByComparator) {
        return this.findByAccountEntryId(accountEntryId, start, end, orderByComparator, true);
    }

    public List<AccountRole> findByAccountEntryId(long accountEntryId, int start, int end, OrderByComparator<AccountRole> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByAccountEntryId;
                finderArgs = new Object[]{accountEntryId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByAccountEntryId;
            finderArgs = new Object[]{accountEntryId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (AccountRole accountRole : list) {
                if (accountEntryId == accountRole.getAccountEntryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_ACCOUNTROLE_WHERE);
            sb.append(_FINDER_COLUMN_ACCOUNTENTRYID_ACCOUNTENTRYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY accountRole.accountRoleId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accountEntryId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public AccountRole findByAccountEntryId_First(long accountEntryId, OrderByComparator<AccountRole> orderByComparator) throws NoSuchRoleException {
        AccountRole accountRole = this.fetchByAccountEntryId_First(accountEntryId, orderByComparator);
        if (accountRole != null) {
            return accountRole;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("accountEntryId=");
        sb.append(accountEntryId);
        sb.append("}");
        throw new NoSuchRoleException(sb.toString());
    }

    public AccountRole fetchByAccountEntryId_First(long accountEntryId, OrderByComparator<AccountRole> orderByComparator) {
        List<AccountRole> list = this.findByAccountEntryId(accountEntryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountRole findByAccountEntryId_Last(long accountEntryId, OrderByComparator<AccountRole> orderByComparator) throws NoSuchRoleException {
        AccountRole accountRole = this.fetchByAccountEntryId_Last(accountEntryId, orderByComparator);
        if (accountRole != null) {
            return accountRole;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("accountEntryId=");
        sb.append(accountEntryId);
        sb.append("}");
        throw new NoSuchRoleException(sb.toString());
    }

    public AccountRole fetchByAccountEntryId_Last(long accountEntryId, OrderByComparator<AccountRole> orderByComparator) {
        int count = this.countByAccountEntryId(accountEntryId);
        if (count == 0) {
            return null;
        }
        List<AccountRole> list = this.findByAccountEntryId(accountEntryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public AccountRole[] findByAccountEntryId_PrevAndNext(long accountRoleId, long accountEntryId, OrderByComparator<AccountRole> orderByComparator) throws NoSuchRoleException {
        AccountRole accountRole = this.findByPrimaryKey(accountRoleId);
        Session session = null;
        try {
            session = this.openSession();
            AccountRole[] array = new AccountRoleImpl[]{this.getByAccountEntryId_PrevAndNext(session, accountRole, accountEntryId, orderByComparator, true), accountRole, this.getByAccountEntryId_PrevAndNext(session, accountRole, accountEntryId, orderByComparator, false)};
            AccountRole[] accountRoleArray = array;
            return accountRoleArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AccountRole getByAccountEntryId_PrevAndNext(Session session, AccountRole accountRole, long accountEntryId, OrderByComparator<AccountRole> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_ACCOUNTROLE_WHERE);
        sb.append(_FINDER_COLUMN_ACCOUNTENTRYID_ACCOUNTENTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY accountRole.accountRoleId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(accountEntryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)accountRole)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (AccountRole)list.get(1);
        }
        return null;
    }

    public List<AccountRole> findByAccountEntryId(long[] accountEntryIds) {
        return this.findByAccountEntryId(accountEntryIds, -1, -1, null);
    }

    public List<AccountRole> findByAccountEntryId(long[] accountEntryIds, int start, int end) {
        return this.findByAccountEntryId(accountEntryIds, start, end, null);
    }

    public List<AccountRole> findByAccountEntryId(long[] accountEntryIds, int start, int end, OrderByComparator<AccountRole> orderByComparator) {
        return this.findByAccountEntryId(accountEntryIds, start, end, orderByComparator, true);
    }

    public List<AccountRole> findByAccountEntryId(long[] accountEntryIds, int start, int end, OrderByComparator<AccountRole> orderByComparator, boolean useFinderCache) {
        if (accountEntryIds == null) {
            accountEntryIds = new long[]{};
        } else if (accountEntryIds.length > 1) {
            accountEntryIds = ArrayUtil.sortedUnique((long[])accountEntryIds);
        }
        if (accountEntryIds.length == 1) {
            return this.findByAccountEntryId(accountEntryIds[0], start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{StringUtil.merge((long[])accountEntryIds)};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{StringUtil.merge((long[])accountEntryIds), start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByAccountEntryId, finderArgs)) != null && !list.isEmpty()) {
            for (AccountRole accountRole : list) {
                if (ArrayUtil.contains((long[])accountEntryIds, (long)accountRole.getAccountEntryId())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_ACCOUNTROLE_WHERE);
            if (accountEntryIds.length > 0) {
                sb.append("(");
                sb.append(_FINDER_COLUMN_ACCOUNTENTRYID_ACCOUNTENTRYID_7);
                sb.append(StringUtil.merge((long[])accountEntryIds));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(AccountRolePersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY accountRole.accountRoleId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByAccountEntryId, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByAccountEntryId(long accountEntryId) {
        for (AccountRole accountRole : this.findByAccountEntryId(accountEntryId, -1, -1, null)) {
            this.remove((BaseModel)accountRole);
        }
    }

    public int countByAccountEntryId(long accountEntryId) {
        FinderPath finderPath = this._finderPathCountByAccountEntryId;
        Object[] finderArgs = new Object[]{accountEntryId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ACCOUNTROLE_WHERE);
            sb.append(_FINDER_COLUMN_ACCOUNTENTRYID_ACCOUNTENTRYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accountEntryId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByAccountEntryId(long[] accountEntryIds) {
        if (accountEntryIds == null) {
            accountEntryIds = new long[]{};
        } else if (accountEntryIds.length > 1) {
            accountEntryIds = ArrayUtil.sortedUnique((long[])accountEntryIds);
        }
        Object[] finderArgs = new Object[]{StringUtil.merge((long[])accountEntryIds)};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByAccountEntryId, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_ACCOUNTROLE_WHERE);
            if (accountEntryIds.length > 0) {
                sb.append("(");
                sb.append(_FINDER_COLUMN_ACCOUNTENTRYID_ACCOUNTENTRYID_7);
                sb.append(StringUtil.merge((long[])accountEntryIds));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(AccountRolePersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByAccountEntryId, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AccountRole findByRoleId(long roleId) throws NoSuchRoleException {
        AccountRole accountRole = this.fetchByRoleId(roleId);
        if (accountRole == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("roleId=");
            sb.append(roleId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchRoleException(sb.toString());
        }
        return accountRole;
    }

    public AccountRole fetchByRoleId(long roleId) {
        return this.fetchByRoleId(roleId, true);
    }

    public AccountRole fetchByRoleId(long roleId, boolean useFinderCache) {
        AccountRole accountRole;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{roleId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByRoleId, finderArgs);
        }
        if (result instanceof AccountRole && roleId != (accountRole = (AccountRole)result).getRoleId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_ACCOUNTROLE_WHERE);
            sb.append(_FINDER_COLUMN_ROLEID_ROLEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(roleId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByRoleId, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{roleId};
                            }
                            _log.warn((Object)("AccountRolePersistenceImpl.fetchByRoleId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    AccountRole accountRole2 = (AccountRole)list.get(0);
                    result = accountRole2;
                    this.cacheResult(accountRole2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (AccountRole)result;
    }

    public AccountRole removeByRoleId(long roleId) throws NoSuchRoleException {
        AccountRole accountRole = this.findByRoleId(roleId);
        return (AccountRole)this.remove((BaseModel)accountRole);
    }

    public int countByRoleId(long roleId) {
        FinderPath finderPath = this._finderPathCountByRoleId;
        Object[] finderArgs = new Object[]{roleId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ACCOUNTROLE_WHERE);
            sb.append(_FINDER_COLUMN_ROLEID_ROLEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(roleId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AccountRolePersistenceImpl() {
        this.setModelClass(AccountRole.class);
        this.setModelImplClass(AccountRoleImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)AccountRoleTable.INSTANCE);
    }

    public void cacheResult(AccountRole accountRole) {
        this.entityCache.putResult(AccountRoleImpl.class, (Serializable)Long.valueOf(accountRole.getPrimaryKey()), (Serializable)accountRole);
        this.finderCache.putResult(this._finderPathFetchByRoleId, new Object[]{accountRole.getRoleId()}, (Object)accountRole);
    }

    public void cacheResult(List<AccountRole> accountRoles) {
        for (AccountRole accountRole : accountRoles) {
            if (this.entityCache.getResult(AccountRoleImpl.class, (Serializable)Long.valueOf(accountRole.getPrimaryKey())) != null) continue;
            this.cacheResult(accountRole);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AccountRoleImpl.class);
        this.finderCache.clearCache(AccountRoleImpl.class);
    }

    public void clearCache(AccountRole accountRole) {
        this.entityCache.removeResult(AccountRoleImpl.class, (BaseModel)accountRole);
    }

    public void clearCache(List<AccountRole> accountRoles) {
        for (AccountRole accountRole : accountRoles) {
            this.entityCache.removeResult(AccountRoleImpl.class, (BaseModel)accountRole);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(AccountRoleImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(AccountRoleImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(AccountRoleModelImpl accountRoleModelImpl) {
        Object[] args = new Object[]{accountRoleModelImpl.getRoleId()};
        this.finderCache.putResult(this._finderPathCountByRoleId, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByRoleId, args, (Object)accountRoleModelImpl);
    }

    public AccountRole create(long accountRoleId) {
        AccountRoleImpl accountRole = new AccountRoleImpl();
        accountRole.setNew(true);
        accountRole.setPrimaryKey(accountRoleId);
        accountRole.setCompanyId(CompanyThreadLocal.getCompanyId());
        return accountRole;
    }

    public AccountRole remove(long accountRoleId) throws NoSuchRoleException {
        return this.remove(Long.valueOf(accountRoleId));
    }

    public AccountRole remove(Serializable primaryKey) throws NoSuchRoleException {
        Session session = null;
        try {
            session = this.openSession();
            AccountRole accountRole = (AccountRole)session.get(AccountRoleImpl.class, primaryKey);
            if (accountRole == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchRoleException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            AccountRole accountRole2 = (AccountRole)this.remove((BaseModel)accountRole);
            return accountRole2;
        }
        catch (NoSuchRoleException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AccountRole removeImpl(AccountRole accountRole) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)accountRole)) {
                accountRole = (AccountRole)session.get(AccountRoleImpl.class, accountRole.getPrimaryKeyObj());
            }
            if (accountRole != null) {
                session.delete((Object)accountRole);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (accountRole != null) {
            this.clearCache(accountRole);
        }
        return accountRole;
    }

    public AccountRole updateImpl(AccountRole accountRole) {
        boolean isNew = accountRole.isNew();
        if (!(accountRole instanceof AccountRoleModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(accountRole.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)accountRole);
                throw new IllegalArgumentException("Implement ModelWrapper in accountRole proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom AccountRole implementation " + accountRole.getClass());
        }
        AccountRoleModelImpl accountRoleModelImpl = (AccountRoleModelImpl)accountRole;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)accountRole);
            } else {
                accountRole = (AccountRole)session.merge((Object)accountRole);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(AccountRoleImpl.class, (BaseModel)accountRoleModelImpl, false, true);
        this.cacheUniqueFindersCache(accountRoleModelImpl);
        if (isNew) {
            accountRole.setNew(false);
        }
        accountRole.resetOriginalValues();
        return accountRole;
    }

    public AccountRole findByPrimaryKey(Serializable primaryKey) throws NoSuchRoleException {
        AccountRole accountRole = (AccountRole)this.fetchByPrimaryKey(primaryKey);
        if (accountRole == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchRoleException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return accountRole;
    }

    public AccountRole findByPrimaryKey(long accountRoleId) throws NoSuchRoleException {
        return this.findByPrimaryKey(Long.valueOf(accountRoleId));
    }

    public AccountRole fetchByPrimaryKey(long accountRoleId) {
        return (AccountRole)this.fetchByPrimaryKey(Long.valueOf(accountRoleId));
    }

    public List<AccountRole> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<AccountRole> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<AccountRole> findAll(int start, int end, OrderByComparator<AccountRole> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<AccountRole> findAll(int start, int end, OrderByComparator<AccountRole> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ACCOUNTROLE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ACCOUNTROLE;
                sql = sql.concat(" ORDER BY accountRole.accountRoleId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (AccountRole accountRole : this.findAll()) {
            this.remove((BaseModel)accountRole);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ACCOUNTROLE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "accountRoleId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ACCOUNTROLE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AccountRoleModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new AccountRoleModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByAccountEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByAccountEntryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"accountEntryId"}, true);
        this._finderPathWithoutPaginationFindByAccountEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByAccountEntryId", new String[]{Long.class.getName()}, new String[]{"accountEntryId"}, true);
        this._finderPathCountByAccountEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByAccountEntryId", new String[]{Long.class.getName()}, new String[]{"accountEntryId"}, false);
        this._finderPathWithPaginationCountByAccountEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByAccountEntryId", new String[]{Long.class.getName()}, new String[]{"accountEntryId"}, false);
        this._finderPathFetchByRoleId = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByRoleId", new String[]{Long.class.getName()}, new String[]{"roleId"}, true);
        this._finderPathCountByRoleId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRoleId", new String[]{Long.class.getName()}, new String[]{"roleId"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(AccountRoleImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.account.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.account.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.account.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class AccountRoleModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private AccountRoleModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            AccountRoleModelImpl accountRoleModelImpl = (AccountRoleModelImpl)baseModel;
            long columnBitmask = accountRoleModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return AccountRoleModelArgumentsResolver._getValue(accountRoleModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | AccountRoleModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return AccountRoleModelArgumentsResolver._getValue(accountRoleModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return AccountRoleImpl.class.getName();
        }

        public String getTableName() {
            return AccountRoleTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(AccountRoleModelImpl accountRoleModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? accountRoleModelImpl.getColumnOriginalValue(columnName) : accountRoleModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

