/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.account.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;

import org.osgi.service.component.annotations.Component;

/**
 * @author Erick Monteiro
 */
@Component(
	immediate = true,
	property = "indexer.class.name=com.liferay.account.model.AccountGroup",
	service = ModelPreFilterContributor.class
)
public class AccountGroupModelPreFilterContributor
	implements ModelPreFilterContributor {

	@Override
	public void contribute(
		BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings,
		SearchContext searchContext) {

		booleanFilter.addRequiredTerm("defaultAccountGroup", false);

		long[] accountEntryIds = GetterUtil.getLongValues(
			searchContext.getAttribute("accountEntryIds"), null);

		if (ArrayUtil.isNotEmpty(accountEntryIds)) {
			TermsFilter termsFilter = new TermsFilter("accountEntryIds");

			termsFilter.addValues(ArrayUtil.toStringArray(accountEntryIds));

			booleanFilter.add(termsFilter, BooleanClauseOccur.MUST);
		}
	}

}