/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.manager;

import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.internal.manager.CurrentAccountEntryManagerStore;
import com.liferay.account.manager.CurrentAccountEntryManager;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.settings.AccountEntryGroupSettings;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CurrentAccountEntryManager.class})
public class CurrentAccountEntryManagerImpl
implements CurrentAccountEntryManager {
    private static final Log _log = LogFactoryUtil.getLog(CurrentAccountEntryManagerImpl.class);
    @Reference
    private AccountEntryGroupSettings _accountEntryGroupSettings;
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private CurrentAccountEntryManagerStore _currentAccountEntryManagerStore;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private UserLocalService _userLocalService;

    public AccountEntry getCurrentAccountEntry(long groupId, long userId) throws PortalException {
        String[] allowedTypes;
        AccountEntry guestAccountEntry = this._accountEntryLocalService.getGuestAccountEntry(CompanyThreadLocal.getCompanyId().longValue());
        if (userId <= 0L) {
            return guestAccountEntry;
        }
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            return guestAccountEntry;
        }
        PermissionChecker permissionChecker = this._permissionCheckerFactory.create(user);
        AccountEntry accountEntry = this._currentAccountEntryManagerStore.getAccountEntryFromHttpSession(groupId);
        if (this._isValid(accountEntry, allowedTypes = this._getAllowedTypes(groupId), permissionChecker)) {
            return accountEntry;
        }
        accountEntry = this._currentAccountEntryManagerStore.getAccountEntryFromPortalPreferences(groupId, userId);
        if (this._isValid(accountEntry, allowedTypes, permissionChecker)) {
            this._currentAccountEntryManagerStore.saveInHttpSession(accountEntry.getAccountEntryId(), groupId);
            return accountEntry;
        }
        accountEntry = this._getDefaultAccountEntry(allowedTypes, userId);
        if (this._isValid(accountEntry, allowedTypes, permissionChecker)) {
            this.setCurrentAccountEntry(accountEntry.getAccountEntryId(), groupId, userId);
            return accountEntry;
        }
        this.setCurrentAccountEntry(-1L, groupId, userId);
        return null;
    }

    public void setCurrentAccountEntry(long accountEntryId, long groupId, long userId) {
        block3: {
            try {
                AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(accountEntryId);
                if (accountEntry != null && !ArrayUtil.contains((Object[])this._getAllowedTypes(groupId), (Object)accountEntry.getType())) {
                    throw new AccountEntryTypeException("Cannot set a current account entry of a disallowed type: " + accountEntry.getType());
                }
                this._currentAccountEntryManagerStore.setCurrentAccountEntry(accountEntryId, groupId, userId);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
    }

    private String[] _getAllowedTypes(long groupId) {
        return this._accountEntryGroupSettings.getAllowedTypes(groupId);
    }

    private AccountEntry _getDefaultAccountEntry(String[] allowedTypes, long userId) throws PortalException {
        List accountEntries = this._accountEntryLocalService.getUserAccountEntries(userId, Long.valueOf(0L), null, allowedTypes, 0, 1);
        if (accountEntries.size() == 1) {
            return (AccountEntry)accountEntries.get(0);
        }
        return null;
    }

    private boolean _isValid(AccountEntry accountEntry, String[] allowedTypes, PermissionChecker permissionChecker) {
        block3: {
            try {
                if (accountEntry != null && Objects.equals(0, accountEntry.getStatus()) && (accountEntry.getAccountEntryId() == -1L || ArrayUtil.contains((Object[])allowedTypes, (Object)accountEntry.getType())) && this._accountEntryModelResourcePermission.contains(permissionChecker, accountEntry.getAccountEntryId(), "VIEW")) {
                    return true;
                }
            }
            catch (PortalException portalException) {
                if (!_log.isInfoEnabled()) break block3;
                _log.info((Throwable)portalException);
            }
        }
        return false;
    }
}

