/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.model.listener;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class AccountEntryUserRelModelListener
extends BaseModelListener<AccountEntryUserRel> {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryUserRelModelListener.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;

    public void onAfterCreate(AccountEntryUserRel accountEntryUserRel) throws ModelListenerException {
        this._updateDefaultAccountEntry(accountEntryUserRel);
        this._reindexAccountEntry(accountEntryUserRel.getAccountEntryId());
        this._reindexUser(accountEntryUserRel.getAccountUserId());
    }

    public void onAfterRemove(AccountEntryUserRel accountEntryUserRel) throws ModelListenerException {
        if (accountEntryUserRel.getAccountUserId() == 0L) {
            return;
        }
        AccountEntry accountEntry = this._accountEntryLocalService.fetchAccountEntry(accountEntryUserRel.getAccountEntryId());
        if (accountEntry != null) {
            this._userGroupRoleLocalService.deleteUserGroupRoles(accountEntryUserRel.getAccountUserId(), new long[]{accountEntry.getAccountEntryGroupId()});
        }
        this._updateDefaultAccountEntry(accountEntryUserRel);
        this._reindexAccountEntry(accountEntryUserRel.getAccountEntryId());
        this._reindexUser(accountEntryUserRel.getAccountUserId());
    }

    public void onBeforeCreate(AccountEntryUserRel accountEntryUserRel) throws ModelListenerException {
        this._checkPersonTypeAccountEntry(accountEntryUserRel.getAccountEntryId());
    }

    private void _checkPersonTypeAccountEntry(long accountEntryId) throws ModelListenerException {
        try {
            if (accountEntryId == 0L) {
                return;
            }
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
            if (Objects.equals(accountEntry.getType(), "person") && ListUtil.isNotEmpty((List)this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountEntryId(accountEntryId))) {
                throw new ModelListenerException();
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    private void _reindexAccountEntry(long accountEntryId) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AccountEntry.class);
            indexer.reindex(AccountEntry.class.getName(), accountEntryId);
        }
        catch (SearchException searchException) {
            throw new ModelListenerException((Throwable)searchException);
        }
    }

    private void _reindexUser(long accountUserId) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex(User.class.getName(), accountUserId);
        }
        catch (SearchException searchException) {
            throw new ModelListenerException((Throwable)searchException);
        }
    }

    private void _updateDefaultAccountEntry(AccountEntryUserRel accountEntryUserRel) throws ModelListenerException {
        List accountEntryUserRels = this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(accountEntryUserRel.getAccountUserId());
        if (accountEntryUserRels.size() > 1) {
            for (AccountEntryUserRel curAccountEntryUserRel : accountEntryUserRels) {
                if (curAccountEntryUserRel.getAccountEntryId() != 0L) continue;
                this._accountEntryUserRelLocalService.deleteAccountEntryUserRel(curAccountEntryUserRel);
            }
        }
    }
}

