/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.model.listener;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class AccountGroupRelModelListener
extends BaseModelListener<AccountGroupRel> {
    @Reference
    private ClassNameLocalService _classNameLocalService;

    public void onAfterCreate(AccountGroupRel accountGroupRel) throws ModelListenerException {
        if (accountGroupRel.getClassNameId() == this._classNameLocalService.getClassNameId(AccountEntry.class.getName())) {
            this._reindexAccountEntry(accountGroupRel.getClassPK());
            this._reindexAccountGroup(accountGroupRel.getAccountGroupId());
        }
    }

    public void onAfterRemove(AccountGroupRel accountGroupRel) throws ModelListenerException {
        if (accountGroupRel.getClassNameId() == this._classNameLocalService.getClassNameId(AccountEntry.class.getName())) {
            this._reindexAccountEntry(accountGroupRel.getClassPK());
            this._reindexAccountGroup(accountGroupRel.getAccountGroupId());
        }
    }

    private void _reindexAccountEntry(long accountEntryId) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AccountEntry.class);
            indexer.reindex(AccountEntry.class.getName(), accountEntryId);
        }
        catch (SearchException searchException) {
            throw new ModelListenerException((Throwable)searchException);
        }
    }

    private void _reindexAccountGroup(long accountGroupId) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(AccountGroup.class);
            indexer.reindex(AccountGroup.class.getName(), accountGroupId);
        }
        catch (SearchException searchException) {
            throw new ModelListenerException((Throwable)searchException);
        }
    }
}

