/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.model.listener;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.object.exception.ObjectDefinitionAccountEntryRestrictedException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectEntryModelListener
extends BaseModelListener<ObjectEntry> {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;

    public void onBeforeCreate(ObjectEntry objectEntry) throws ModelListenerException {
        try {
            this._validateAccountEntry(objectEntry);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        try {
            this._validateAccountEntry(objectEntry);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _validateAccountEntry(ObjectEntry objectEntry) throws PortalException {
        ObjectField objectField;
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
        if (!objectDefinition.isAccountEntryRestricted()) {
            return;
        }
        Map values = objectEntry.getValues();
        if (!values.containsKey((objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId())).getName())) {
            return;
        }
        List accountEntries = this._accountEntryLocalService.getUserAccountEntries(objectEntry.getUserId(), Long.valueOf(0L), null, new String[]{"business", "person"}, Integer.valueOf(0), -1, -1);
        long accountEntryId = GetterUtil.getLong(values.get(objectField.getName()));
        for (AccountEntry accountEntry : accountEntries) {
            if (accountEntryId != accountEntry.getAccountEntryId()) continue;
            return;
        }
        throw new ObjectDefinitionAccountEntryRestrictedException(StringBundler.concat((Object[])new Object[]{"The account entry ", accountEntryId, " does not exist or the user ", objectEntry.getUserId(), " does not belong to it"}));
    }
}

